/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.sdes;

import ch.imvs.sdes4j.srtp.SrtpCryptoAttribute;
import ch.imvs.sdes4j.srtp.SrtpSDesFactory;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.transform.sdes.SDesTransformEngine;
import org.jitsi.service.neomedia.AbstractSrtpControl;
import org.jitsi.service.neomedia.SDesControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.event.SrtpListener;
import org.jitsi.utils.MediaType;

public class SDesControlImpl
extends AbstractSrtpControl<SDesTransformEngine>
implements SDesControl {
    private final List<String> enabledCryptoSuites = new ArrayList<String>(3);
    private final List<String> supportedCryptoSuites = new ArrayList<String>(7);
    private SrtpCryptoAttribute[] attributes;
    private SrtpSDesFactory sdesFactory;
    private SrtpCryptoAttribute selectedInAttribute;
    private SrtpCryptoAttribute selectedOutAttribute;

    public SDesControlImpl() {
        super(SrtpControlType.SDES);
        this.enabledCryptoSuites.add("AES_CM_128_HMAC_SHA1_80");
        this.enabledCryptoSuites.add("AES_CM_128_HMAC_SHA1_32");
        this.enabledCryptoSuites.add("F8_128_HMAC_SHA1_80");
        this.supportedCryptoSuites.add("AES_CM_128_HMAC_SHA1_80");
        this.supportedCryptoSuites.add("AES_CM_128_HMAC_SHA1_32");
        this.supportedCryptoSuites.add("AES_192_CM_HMAC_SHA1_80");
        this.supportedCryptoSuites.add("AES_192_CM_HMAC_SHA1_32");
        this.supportedCryptoSuites.add("AES_256_CM_HMAC_SHA1_80");
        this.supportedCryptoSuites.add("AES_256_CM_HMAC_SHA1_32");
        this.supportedCryptoSuites.add("F8_128_HMAC_SHA1_80");
        this.sdesFactory = new SrtpSDesFactory();
        this.sdesFactory.setRandomGenerator((Random)new SecureRandom());
    }

    @Override
    public SrtpCryptoAttribute getInAttribute() {
        return this.selectedInAttribute;
    }

    @Override
    public SrtpCryptoAttribute[] getInitiatorCryptoAttributes() {
        this.initAttributes();
        return this.attributes;
    }

    @Override
    public SrtpCryptoAttribute getOutAttribute() {
        return this.selectedOutAttribute;
    }

    @Override
    public boolean getSecureCommunicationStatus() {
        return this.transformEngine != null;
    }

    @Override
    public Iterable<String> getSupportedCryptoSuites() {
        return Collections.unmodifiableList(this.supportedCryptoSuites);
    }

    @Override
    protected SDesTransformEngine createTransformEngine() {
        return new SDesTransformEngine(this.selectedInAttribute, this.selectedOutAttribute);
    }

    private void initAttributes() {
        if (this.attributes == null) {
            if (this.selectedOutAttribute != null) {
                this.attributes = new SrtpCryptoAttribute[1];
                this.attributes[0] = this.selectedOutAttribute;
                return;
            }
            this.attributes = new SrtpCryptoAttribute[this.enabledCryptoSuites.size()];
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i] = this.sdesFactory.createCryptoAttribute(i + 1, this.enabledCryptoSuites.get(i));
            }
        }
    }

    @Override
    public SrtpCryptoAttribute initiatorSelectAttribute(Iterable<SrtpCryptoAttribute> peerAttributes) {
        for (SrtpCryptoAttribute peerCA : peerAttributes) {
            for (SrtpCryptoAttribute localCA : this.attributes) {
                if (!localCA.getCryptoSuite().equals((Object)peerCA.getCryptoSuite())) continue;
                this.selectedInAttribute = peerCA;
                this.selectedOutAttribute = localCA;
                if (this.transformEngine != null) {
                    ((SDesTransformEngine)this.transformEngine).update(this.selectedInAttribute, this.selectedOutAttribute);
                }
                return peerCA;
            }
        }
        return null;
    }

    @Override
    public boolean requiresSecureSignalingTransport() {
        return true;
    }

    @Override
    public SrtpCryptoAttribute responderSelectAttribute(Iterable<SrtpCryptoAttribute> peerAttributes) {
        for (SrtpCryptoAttribute ea : peerAttributes) {
            for (String suite : this.enabledCryptoSuites) {
                if (!suite.equals(ea.getCryptoSuite().encode())) continue;
                this.selectedInAttribute = ea;
                this.selectedOutAttribute = this.sdesFactory.createCryptoAttribute(ea.getTag(), suite);
                if (this.transformEngine != null) {
                    ((SDesTransformEngine)this.transformEngine).update(this.selectedInAttribute, this.selectedOutAttribute);
                }
                return this.selectedOutAttribute;
            }
        }
        return null;
    }

    @Override
    public void setConnector(AbstractRTPConnector connector) {
    }

    @Override
    public void setEnabledCiphers(Iterable<String> ciphers) {
        this.enabledCryptoSuites.clear();
        for (String c : ciphers) {
            this.enabledCryptoSuites.add(c);
        }
    }

    @Override
    public void start(MediaType mediaType) {
        SrtpListener srtpListener = this.getSrtpListener();
        srtpListener.securityNegotiationStarted(mediaType, this);
        srtpListener.securityTurnedOn(mediaType, this.selectedInAttribute.getCryptoSuite().encode(), this);
    }
}

