/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import java.util.Map;
import java.util.TreeMap;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.service.neomedia.ByteArrayBufferImpl;
import org.jitsi.util.RTCPUtils;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.Logger;

public class RTCPTCCPacket
extends RTCPFBPacket {
    public static final int MAX_PACKET_COUNT = 200;
    private static final Logger logger = Logger.getLogger(RTCPTCCPacket.class);
    public static final int FMT = 15;
    private static final int SYMBOL_NOT_RECEIVED = 0;
    private static final int SYMBOL_SMALL_DELTA = 1;
    private static final int SYMBOL_LARGE_DELTA = 2;
    private static final int CHUNK_TYPE_VECTOR = 1;
    private static final int CHUNK_TYPE_RLE = 0;
    private static final int SYMBOL_TYPE_SHORT = 0;
    private static final int SYMBOL_TYPE_LONG = 1;
    private static final Long NEGATIVE_ONE = -1L;
    private static final int MIN_FCI_LENGTH = 10;
    private static final int CHUNK_SIZE_BYTES = 2;
    private static final int PACKET_STATUS_CHUNK_OFFSET = 8;
    private static final String PARSE_ERROR = "Failed to parse an RTCP transport-cc feedback packet: ";
    private PacketMap packets = null;

    public static boolean isTCCPacket(ByteArrayBuffer baf) {
        int rc = RTCPUtils.getReportCount(baf);
        return rc == 15 && RTCPTCCPacket.isRTPFBPacket(baf);
    }

    public static PacketMap getPackets(ByteArrayBuffer baf) {
        return RTCPTCCPacket.getPacketsFromFci(RTCPTCCPacket.getFCI(baf));
    }

    public static long getReferenceTime250us(ByteArrayBuffer fciBuffer) {
        byte[] buf = fciBuffer.getBuffer();
        int off = fciBuffer.getOffset();
        long referenceTime = RTPUtils.readUint24AsInt(buf, off + 4) << 8;
        return referenceTime;
    }

    public static PacketMap getPacketsFromFci(ByteArrayBuffer fciBuffer) {
        return RTCPTCCPacket.getPacketsFromFci(fciBuffer, false);
    }

    static PacketMap getPacketsFromFci(ByteArrayBuffer fciBuffer, boolean includeNotReceived) {
        int packetsInChunk;
        int fciLen = -1;
        if (fciBuffer == null || (fciLen = fciBuffer.getLength()) < 10) {
            logger.warn((Object)("Failed to parse an RTCP transport-cc feedback packet: buffer is null or length too small: " + fciLen));
            return null;
        }
        byte[] fciBuf = fciBuffer.getBuffer();
        int fciOff = fciBuffer.getOffset();
        int currentSeq = RTPUtils.readUint16AsInt(fciBuf, fciOff);
        int packetStatusCount = RTPUtils.readUint16AsInt(fciBuf, fciOff + 2);
        long referenceTime = RTCPTCCPacket.getReferenceTime250us(fciBuffer);
        int currentPscOff = fciOff + 8;
        int packetsRemaining = packetStatusCount;
        while (packetsRemaining > 0) {
            if (currentPscOff + 2 > fciOff + fciLen) {
                logger.warn((Object)"Failed to parse an RTCP transport-cc feedback packet: reached the end while reading chunks");
                return null;
            }
            int packetsInChunk2 = RTCPTCCPacket.getPacketCount(fciBuf, currentPscOff);
            packetsRemaining -= packetsInChunk2;
            currentPscOff += 2;
        }
        int deltaOff = currentPscOff;
        int currentDeltaOff = currentPscOff;
        currentPscOff = fciOff + 8;
        PacketMap packets = new PacketMap();
        for (packetsRemaining = packetStatusCount; packetsRemaining > 0 && currentPscOff < deltaOff; currentPscOff += 2, packetsRemaining -= packetsInChunk) {
            int i;
            packetsInChunk = Math.min(RTCPTCCPacket.getPacketCount(fciBuf, currentPscOff), packetsRemaining);
            int chunkType = RTCPTCCPacket.getChunkType(fciBuf, currentPscOff);
            if (packetsInChunk > 0 && chunkType == 0 && RTCPTCCPacket.readSymbol(fciBuf, currentPscOff, chunkType, 0) == 0) {
                if (includeNotReceived) {
                    for (i = 0; i < packetsInChunk; ++i) {
                        int seq = (currentSeq + i) % 65535;
                        RTCPTCCPacket.logPacket(seq, NEGATIVE_ONE, -1, 0);
                        packets.put(seq, NEGATIVE_ONE);
                    }
                }
                currentSeq = (currentSeq + packetsInChunk) % 65535;
                continue;
            }
            for (i = 0; i < packetsInChunk; ++i) {
                int symbol = RTCPTCCPacket.readSymbol(fciBuf, currentPscOff, chunkType, i);
                int delta = -1;
                switch (symbol) {
                    case 1: {
                        if (currentDeltaOff >= fciOff + fciLen) {
                            logger.warn((Object)"Failed to parse an RTCP transport-cc feedback packet: reached the end while reading delta.");
                            return null;
                        }
                        delta = fciBuf[currentDeltaOff++] & 0xFF;
                        break;
                    }
                    case 2: {
                        if (currentDeltaOff + 1 >= fciOff + fciLen) {
                            logger.warn((Object)"Failed to parse an RTCP transport-cc feedback packet: reached the end while reading long delta.");
                            return null;
                        }
                        delta = RTPUtils.readInt16AsInt(fciBuf, currentDeltaOff);
                        currentDeltaOff += 2;
                        break;
                    }
                    case 0: {
                        delta = -1;
                        break;
                    }
                    default: {
                        logger.warn((Object)("Failed to parse an RTCP transport-cc feedback packet:  invalid symbol: " + symbol));
                        return null;
                    }
                }
                if (delta == -1) {
                    if (includeNotReceived) {
                        RTCPTCCPacket.logPacket(currentSeq, NEGATIVE_ONE, delta, symbol);
                        packets.put(currentSeq, NEGATIVE_ONE);
                    }
                } else {
                    RTCPTCCPacket.logPacket(currentSeq, referenceTime += (long)delta, delta, symbol);
                    packets.put(currentSeq, referenceTime);
                }
                currentSeq = currentSeq + 1 & 0xFFFF;
            }
        }
        if (packetsRemaining > 0) {
            logger.warn((Object)"Reached the end of the buffer before having read all expected packets. Ill-formatted RTCP packet?");
        }
        return packets;
    }

    private static int getChunkType(byte[] buf, int off) {
        return (buf[off] & 0x80) >> 7;
    }

    private static int readSymbol(byte[] buf, int off, int chunkType, int i) {
        if (chunkType == 1) {
            int symbolType = (buf[off] & 0x40) >> 6;
            switch (symbolType) {
                case 1: {
                    if (0 <= i && i <= 2) {
                        return buf[off] >> 4 - 2 * i & 3;
                    }
                    if (3 <= i && i <= 6) {
                        return buf[off + 1] >> 6 - 2 * (i - 3) & 3;
                    }
                    return -1;
                }
                case 0: {
                    if (0 <= i && i <= 5) {
                        return buf[off] >> 5 - i & 1;
                    }
                    if (6 <= i && i <= 13) {
                        return buf[off + 1] >> 13 - i & 1;
                    }
                    return -1;
                }
            }
            return -1;
        }
        if (chunkType == 0) {
            return buf[off] >> 5 & 3;
        }
        return -1;
    }

    private static int getPacketCount(byte[] buf, int off) {
        int chunkType = RTCPTCCPacket.getChunkType(buf, off);
        if (chunkType == 1) {
            int symbolType = (buf[off] & 0x40) >> 6;
            return symbolType == 0 ? 14 : 7;
        }
        if (chunkType == 0) {
            return (buf[off] & 0x1F) << 8 | buf[off + 1] & 0xFF;
        }
        throw new IllegalStateException("The one-bit chunk type is neither 0 nor 1. A superposition is  not a valid chunk type.");
    }

    public RTCPTCCPacket(RTCPCompoundPacket base) {
        super(base);
    }

    public RTCPTCCPacket(long senderSSRC, long sourceSSRC, PacketMap packets, byte fbPacketCount, DiagnosticContext diagnosticContext) {
        super(15, 205, senderSSRC, sourceSSRC);
        Map.Entry first = packets.firstEntry();
        int firstSeq = (Integer)first.getKey();
        Map.Entry last = packets.lastEntry();
        int packetCount = 1 + RTPUtils.subtractNumber((Integer)last.getKey(), firstSeq);
        if (packetCount > 200) {
            throw new IllegalArgumentException("Too many packets: " + packetCount);
        }
        byte[] buf = packetCount % 7 == 0 ? new byte[packetCount / 7 * 2 + 8] : new byte[(packetCount / 7 + 1) * 2 + 8];
        byte[] deltas = new byte[packetCount * 2];
        int deltaOff = 0;
        int off = 0;
        long referenceTime = (Long)first.getValue();
        referenceTime -= referenceTime % 64L;
        off += RTPUtils.writeShort(buf, off, (short)((Integer)first.getKey()).intValue());
        off += RTPUtils.writeShort(buf, off, (short)packetCount);
        off += RTPUtils.writeUint24(buf, off, (int)(referenceTime >> 6 & 0xFFFFFFL));
        buf[off++] = fbPacketCount;
        long nextReferenceTime = referenceTime;
        --off;
        for (int seqDelta = 0; seqDelta < packetCount; ++seqDelta) {
            int symbolShift;
            int symbol;
            if (seqDelta % 7 == 0) {
                buf[++off] = -64;
            } else if (seqDelta % 7 == 3) {
                buf[++off] = 0;
            }
            int seq = firstSeq + seqDelta & 0xFFFF;
            Long ts = (Long)packets.get(seq);
            if (ts == null || ts < 0L) {
                symbol = 0;
            } else {
                long tsDelta = ts - nextReferenceTime;
                if (tsDelta >= 0L && tsDelta <= 63L) {
                    symbol = 1;
                    deltas[deltaOff++] = (byte)(tsDelta << 2 & 0xFFL);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)diagnosticContext.makeTimeSeriesPoint("small_delta").addField("seq", (Object)seq).addField("arrival_time_ms", (Object)ts).addField("ref_time_ms", (Object)nextReferenceTime).addField("delta", (Object)tsDelta));
                    }
                } else if (tsDelta < 8191L && tsDelta > -8192L) {
                    symbol = 2;
                    short d = (short)(tsDelta << 2);
                    deltas[deltaOff++] = (byte)(d >> 8 & 0xFF);
                    deltas[deltaOff++] = (byte)(d & 0xFF);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)diagnosticContext.makeTimeSeriesPoint("large_delta").addField("seq", (Object)seq).addField("arrival_time_ms", (Object)ts).addField("ref_time_ms", (Object)nextReferenceTime).addField("delta", (Object)tsDelta));
                    }
                } else {
                    throw new IllegalArgumentException("Delta too big, needs new reference.");
                }
                nextReferenceTime = ts;
            }
            switch (seqDelta % 7) {
                case 0: 
                case 4: {
                    symbolShift = 4;
                    break;
                }
                case 1: 
                case 5: {
                    symbolShift = 2;
                    break;
                }
                case 2: 
                case 6: {
                    symbolShift = 0;
                    break;
                }
                default: {
                    symbolShift = 6;
                }
            }
            int n = off;
            buf[n] = (byte)(buf[n] | (symbol <<= symbolShift));
        }
        ++off;
        if (packetCount % 7 > 0 && packetCount % 7 <= 3) {
            buf[off++] = 0;
        }
        this.fci = new byte[off + deltaOff];
        System.arraycopy(buf, 0, this.fci, 0, off);
        System.arraycopy(deltas, 0, this.fci, off, deltaOff);
    }

    public synchronized PacketMap getPackets() {
        if (this.packets == null) {
            this.packets = RTCPTCCPacket.getPacketsFromFci(new ByteArrayBufferImpl(this.fci, 0, this.fci.length));
        }
        return this.packets;
    }

    public int getFbPacketCount() {
        return this.fci == null || this.fci.length < 10 ? -1 : this.fci[7] & 0xFF;
    }

    @Override
    public String toString() {
        return "RTCP transport-cc feedback";
    }

    private static void logPacket(int seq, long referenceTime, int delta, int symbol) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("seq=" + seq + ",reference_time=" + referenceTime + ",delta=" + delta + ",symbol=" + symbol));
        }
    }

    public static class PacketMap
    extends TreeMap<Integer, Long> {
        public PacketMap() {
            super(RTPUtils.sequenceNumberComparator);
        }
    }
}

