/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.vp9;

public class DePacketizer {
    private static final byte E_BIT = 4;
    private static final byte B_BIT = 8;
    private static final byte L_BIT = 32;
    private static final byte I_BIT = -128;

    public static boolean isKeyFrame(byte[] buf, int off, int len) {
        return true;
    }

    public static class VP9PayloadDescriptor {
        public static boolean isStartOfFrame(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 8) != 0;
        }

        public static boolean isEndOfFrame(byte[] buf, int off, int len) {
            return VP9PayloadDescriptor.isValid(buf, off, len) && (buf[off] & 4) != 0;
        }

        private static boolean isValid(byte[] buf, int off, int len) {
            return buf != null && buf.length >= off + len && off > -1 && len > 0;
        }

        public static int getTemporalLayerIndex(byte[] buf, int off, int len) {
            if (!VP9PayloadDescriptor.isValid(buf, off, len) || (buf[off] & 0x20) == 0) {
                return -1;
            }
            int loff = off + 1;
            if ((buf[off] & 0xFFFFFF80) != 0) {
                ++loff;
                if ((buf[off + 1] & 0x80) != 0) {
                    ++loff;
                }
            }
            return (buf[loff] & 0xE0) >> 5;
        }

        public static int getSpatialLayerIndex(byte[] buf, int off, int len) {
            if (!VP9PayloadDescriptor.isValid(buf, off, len) || (buf[off] & 0x20) == 0) {
                return -1;
            }
            int loff = off + 1;
            if ((buf[off] & 0xFFFFFF80) != 0) {
                ++loff;
                if ((buf[off + 1] & 0x80) != 0) {
                    ++loff;
                }
            }
            return (buf[loff] & 0xE) >> 1;
        }
    }
}

