/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.audio.AbstractFFmpegAudioCodec;
import org.jitsi.utils.logging.Logger;

public class FFmpegAudioEncoder
extends AbstractFFmpegAudioCodec {
    private static final Logger logger = Logger.getLogger(FFmpegAudioEncoder.class);
    private byte[] prevIn;
    protected int prevInLen;

    public static void assertFindAVCodec(int codecID) {
        if (FFmpeg.avcodec_find_encoder((int)codecID) == 0L) {
            throw new RuntimeException("Could not find FFmpeg encoder " + FFmpegAudioEncoder.codecIDToString(codecID) + "!");
        }
    }

    protected FFmpegAudioEncoder(String name, int codecID, Format[] supportedOutputFormats) {
        super(name, codecID, supportedOutputFormats);
    }

    @Override
    protected void configureAVCodecContext(long avctx, AudioFormat format) {
        super.configureAVCodecContext(avctx, format);
        try {
            FFmpeg.avcodeccontext_set_sample_fmt((long)avctx, (int)6);
        }
        catch (UnsatisfiedLinkError ule) {
            logger.warn((Object)"The FFmpeg JNI library is out-of-date.");
        }
    }

    @Override
    protected synchronized void doClose() {
        super.doClose();
        this.prevIn = null;
        this.prevInLen = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized int doProcess(Buffer inBuf, Buffer outBuf) {
        int outLen;
        byte[] in = (byte[])inBuf.getData();
        int inLen = inBuf.getLength();
        int inOff = inBuf.getOffset();
        if (this.prevInLen > 0 || inLen < this.frameSizeInBytes) {
            int newPrevInLen = Math.min(this.frameSizeInBytes - this.prevInLen, inLen);
            if (newPrevInLen > 0) {
                if (this.prevIn == null) {
                    this.prevIn = new byte[this.frameSizeInBytes];
                    this.prevInLen = 0;
                }
                System.arraycopy(in, inOff, this.prevIn, this.prevInLen, newPrevInLen);
                inBuf.setLength(inLen - newPrevInLen);
                inBuf.setOffset(inOff + newPrevInLen);
                this.prevInLen += newPrevInLen;
                if (this.prevInLen != this.frameSizeInBytes) return 4;
                in = this.prevIn;
                inLen = this.prevInLen;
                inOff = 0;
                this.prevInLen = 0;
            }
        } else {
            inBuf.setLength(inLen - this.frameSizeInBytes);
            inBuf.setOffset(inOff + this.frameSizeInBytes);
        }
        Object outData = outBuf.getData();
        byte[] out = outData instanceof byte[] ? (byte[])outData : null;
        int outOff = outBuf.getOffset();
        int minOutLen = Math.max(16384, inLen);
        if (out == null || out.length - outOff < minOutLen) {
            out = new byte[minOutLen];
            outBuf.setData((Object)out);
            outOff = 0;
            outBuf.setOffset(outOff);
        }
        if ((outLen = FFmpeg.avcodec_encode_audio((long)this.avctx, (byte[])out, (int)outOff, (int)(out.length - outOff), (byte[])in, (int)inOff)) < 0) {
            return 1;
        }
        outBuf.setFormat(this.getOutputFormat());
        outBuf.setLength(outLen);
        if (inBuf.getLength() > 0) {
            return 2;
        }
        if (outLen != 0) return 0;
        return 4;
    }

    @Override
    protected long findAVCodec(int codecID) {
        return FFmpeg.avcodec_find_encoder((int)codecID);
    }

    @Override
    protected AudioFormat getAVCodecContextFormat() {
        return (AudioFormat)this.getInputFormat();
    }
}

