/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm.advice.jvm;

import io.mockk.proxy.MockKInvocationHandler;
import io.mockk.proxy.jvm.advice.BaseAdvice;
import io.mockk.proxy.jvm.advice.ProxyAdviceId;
import io.mockk.proxy.jvm.dispatcher.JvmMockKDispatcher;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;

public class JvmMockKHashMapStaticProxyAdvice
extends BaseAdvice {
    public JvmMockKHashMapStaticProxyAdvice(Map<Object, MockKInvocationHandler> handlers) {
        super(handlers);
    }

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    private static Callable<?> enterStatic(@ProxyAdviceId long id, @Advice.Origin Method method, @Advice.AllArguments Object[] arguments) throws Throwable {
        if (arguments.length == 1 && arguments[0] == HashMap.class) {
            return null;
        }
        Class<?> self = method.getDeclaringClass();
        JvmMockKDispatcher dispatcher = JvmMockKDispatcher.get((long)id, self);
        if (dispatcher == null) {
            return null;
        }
        return dispatcher.handler(self, method, arguments);
    }

    @Advice.OnMethodExit
    private static void exit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Enter Callable<?> mocked) throws Throwable {
        if (mocked != null) {
            returned = mocked.call();
        }
    }
}

