/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.checkin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.add.GitAddCommand;
import org.apache.maven.scm.provider.git.gitexe.command.branch.GitBranchCommand;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusCommand;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.provider.git.util.GitUtil;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitCheckInCommand
extends AbstractCheckInCommand
implements GitCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion version) throws ScmException {
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)message);
        }
        catch (IOException ex) {
            return new CheckInScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        try {
            Commandline clCommit;
            GitStatusConsumer statusConsumer;
            Commandline clAdd;
            int exitCode;
            if (!fileSet.getFileList().isEmpty() && (exitCode = GitCommandLineUtils.execute(clAdd = GitAddCommand.createCommandLine(fileSet.getBasedir(), fileSet.getFileList()), stdout, stderr, this.getLogger())) != 0) {
                CheckInScmResult checkInScmResult = new CheckInScmResult(clAdd.toString(), "The git-add command failed.", stderr.getOutput(), false);
                return checkInScmResult;
            }
            Commandline clStatus = GitStatusCommand.createCommandLine(repository, fileSet);
            exitCode = GitCommandLineUtils.execute(clStatus, statusConsumer = new GitStatusConsumer(this.getLogger(), fileSet.getBasedir()), stderr, this.getLogger());
            if (exitCode != 0 && this.getLogger().isInfoEnabled()) {
                this.getLogger().info("nothing added to commit but untracked files present (use \"git add\" to track)");
            }
            if ((exitCode = GitCommandLineUtils.execute(clCommit = GitCheckInCommand.createCommitCommandLine(repository, fileSet, messageFile), stdout, stderr, this.getLogger())) != 0) {
                CheckInScmResult checkInScmResult = new CheckInScmResult(clCommit.toString(), "The git-commit command failed.", stderr.getOutput(), false);
                return checkInScmResult;
            }
            Commandline cl = GitCheckInCommand.createPushCommandLine(this.getLogger(), repository, fileSet, version);
            exitCode = GitCommandLineUtils.execute(cl, stdout, stderr, this.getLogger());
            if (exitCode != 0) {
                CheckInScmResult ex = new CheckInScmResult(cl.toString(), "The git-push command failed.", stderr.getOutput(), false);
                return ex;
            }
            ArrayList<ScmFile> checkedInFiles = new ArrayList<ScmFile>(statusConsumer.getChangedFiles().size());
            Iterator it = statusConsumer.getChangedFiles().iterator();
            while (it.hasNext()) {
                ScmFile scmfile = new ScmFile(((ScmFile)it.next()).getPath(), ScmFileStatus.CHECKED_IN);
                if (fileSet.getFileList().isEmpty()) {
                    checkedInFiles.add(scmfile);
                    continue;
                }
                Iterator itfl = fileSet.getFileList().iterator();
                while (itfl.hasNext()) {
                    File f = (File)itfl.next();
                    if (!f.toString().equals(scmfile.getPath())) continue;
                    checkedInFiles.add(scmfile);
                }
            }
            CheckInScmResult checkInScmResult = new CheckInScmResult(cl.toString(), checkedInFiles);
            return checkInScmResult;
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException ex) {}
        }
    }

    public static Commandline createPushCommandLine(ScmLogger logger, GitScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "push");
        String branch = GitBranchCommand.getCurrentBranch(logger, repository, fileSet);
        if (branch == null || branch.length() == 0) {
            throw new ScmException("Could not detect the current branch. Don't know where I should push to!");
        }
        cl.createArg().setValue(repository.getPushUrl());
        cl.createArg().setValue(branch + ":" + branch);
        return cl;
    }

    public static Commandline createCommitCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet, File messageFile) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "commit");
        cl.createArg().setValue("--verbose");
        cl.createArg().setValue("-F");
        cl.createArg().setValue(messageFile.getAbsolutePath());
        if (fileSet.getFileList().isEmpty()) {
            cl.createArg().setValue("-a");
        } else {
            GitCommandLineUtils.addTarget(cl, fileSet.getFileList());
        }
        if (GitUtil.getSettings().isCommitNoVerify()) {
            cl.createArg().setValue("--no-verify");
        }
        return cl;
    }
}

