/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.WASAPISystem;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.AudioCaptureClient;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.DataSource;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.HResultException;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.IMediaBuffer;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.NativelySupportedAudioFormat;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.PtrMediaBuffer;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.VoiceCaptureDSP;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.WASAPI;
import org.jitsi.impl.neomedia.jmfext.media.renderer.AbstractRenderer;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.WASAPIRenderer;
import org.jitsi.utils.logging.Logger;

public class WASAPIStream
extends AbstractPushBufferStream<DataSource> {
    private static final int CAPTURE_INPUT_STREAM_INDEX = 0;
    private static final boolean DEFAULT_SOURCE_MODE = true;
    private static Logger logger = Logger.getLogger(WASAPIStream.class);
    private static final int RENDER_INPUT_STREAM_INDEX = 1;
    private boolean aec;
    private int bufferMaxLength;
    private int bufferSize;
    private AudioCaptureClient capture;
    private int captureBufferMaxLength;
    private PtrMediaBuffer captureIMediaBuffer;
    private boolean captureIsBusy;
    private double captureNanosPerByte;
    private long devicePeriod;
    private long dmoOutputDataBuffer;
    private AudioFormat effectiveFormat;
    private AudioFormat format;
    private long iMediaBuffer;
    private long iMediaObject;
    private Object iMediaObjectLock = new Object();
    private MediaLocator locator;
    private byte[] processed;
    private int processedLength;
    private byte[] processInputBuffer;
    private Thread processThread;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            try {
                WASAPIStream.this.propertyChange(ev);
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder();
                msg.append("Failed to handle a change to the value of the property ");
                msg.append(ev.getPropertyName());
                Object source = ev.getSource();
                if (source != null) {
                    msg.append(" of a ");
                    msg.append(source.getClass());
                }
                msg.append('.');
                logger.error((Object)msg, (Throwable)e);
            }
        }
    };
    private AudioCaptureClient render;
    private int renderBufferMaxLength;
    private double renderBytesPerNano;
    private PtrMediaBuffer renderIMediaBuffer;
    private boolean renderIsBusy;
    private MediaLocator renderDevice;
    private int renderDeviceIndex;
    private Renderer renderer;
    private boolean replenishRender;
    private Codec resampler;
    private Buffer resamplerBuffer;
    private boolean sourceMode;
    private boolean started;

    private static AudioFormat findClosestMatch(Format[] formats, AudioFormat format, Class<? extends AudioFormat> clazz) {
        AudioFormat match = WASAPIStream.findFirstMatch(formats, format, clazz);
        if (match == null && (match = WASAPIStream.findFirstMatch(formats, new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), -1, format.getEndian(), format.getSigned(), -1, -1.0, format.getDataType()), clazz)) == null) {
            match = WASAPIStream.findFirstMatch(formats, new AudioFormat(format.getEncoding(), -1.0, format.getSampleSizeInBits(), -1, format.getEndian(), format.getSigned(), -1, -1.0, format.getDataType()), clazz);
        }
        return match;
    }

    private static AudioFormat findClosestMatch(List<AudioFormat> formats, AudioFormat format, Class<? extends AudioFormat> clazz) {
        return WASAPIStream.findClosestMatch(formats.toArray(new Format[formats.size()]), format, clazz);
    }

    private static AudioFormat findFirstMatch(Format[] formats, AudioFormat format, Class<? extends AudioFormat> clazz) {
        for (Format aFormat : formats) {
            if (!aFormat.matches((Format)format) || clazz != null && !clazz.isInstance(aFormat)) continue;
            return (AudioFormat)aFormat.intersects((Format)format);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int IMediaObject_SetXXXputType(long iMediaObject, boolean inOrOut, int dwXXXputStreamIndex, AudioFormat audioFormat, int dwFlags) throws HResultException {
        int hresult;
        int channels = audioFormat.getChannels();
        double sampleRate = audioFormat.getSampleRate();
        int sampleSizeInBits = audioFormat.getSampleSizeInBits();
        if (-1 == channels) {
            throw new IllegalArgumentException("audioFormat.channels");
        }
        if (-1.0 == sampleRate) {
            throw new IllegalArgumentException("audioFormat.sampleRate");
        }
        if (-1 == sampleSizeInBits) {
            throw new IllegalArgumentException("audioFormat.sampleSizeInBits");
        }
        char nChannels = (char)channels;
        int nSamplesPerSec = (int)sampleRate;
        char wBitsPerSample = (char)sampleSizeInBits;
        char nBlockAlign = (char)(nChannels * wBitsPerSample / 8);
        char cbSize = '\u0000';
        long waveformatex = WASAPI.WAVEFORMATEX_alloc();
        if (waveformatex == 0L) {
            throw new OutOfMemoryError("WAVEFORMATEX_alloc");
        }
        try {
            WASAPI.WAVEFORMATEX_fill(waveformatex, '\u0001', nChannels, nSamplesPerSec, nSamplesPerSec * nBlockAlign, nBlockAlign, wBitsPerSample, cbSize);
            long pmt = VoiceCaptureDSP.MoCreateMediaType(0);
            if (pmt == 0L) {
                throw new OutOfMemoryError("MoCreateMediaType");
            }
            try {
                int cbFormat = WASAPI.WAVEFORMATEX_sizeof() + cbSize;
                hresult = VoiceCaptureDSP.DMO_MEDIA_TYPE_fill(pmt, "{73647561-0000-0010-8000-00aa00389b71}", "{00000001-0000-0010-8000-00AA00389B71}", true, false, wBitsPerSample / 8, "{05589f81-c356-11ce-bf01-00aa0055595a}", 0L, cbFormat, waveformatex);
                if (WASAPI.FAILED(hresult)) {
                    throw new HResultException(hresult, "DMO_MEDIA_TYPE_fill");
                }
                int n = hresult = inOrOut ? VoiceCaptureDSP.IMediaObject_SetInputType(iMediaObject, dwXXXputStreamIndex, pmt, dwFlags) : VoiceCaptureDSP.IMediaObject_SetOutputType(iMediaObject, dwXXXputStreamIndex, pmt, dwFlags);
                if (WASAPI.FAILED(hresult)) {
                    throw new HResultException(hresult, inOrOut ? "IMediaObject_SetInputType" : "IMediaObject_SetOutputType");
                }
            }
            finally {
                VoiceCaptureDSP.DMO_MEDIA_TYPE_setCbFormat(pmt, 0);
                VoiceCaptureDSP.DMO_MEDIA_TYPE_setFormattype(pmt, "{0f6417d6-c318-11d0-a43f-00a0c9223196}");
                VoiceCaptureDSP.DMO_MEDIA_TYPE_setPbFormat(pmt, 0L);
                VoiceCaptureDSP.MoDeleteMediaType(pmt);
            }
        }
        finally {
            WASAPI.CoTaskMemFree(waveformatex);
        }
        return hresult;
    }

    private static int maybeIMediaBufferGetLength(IMediaBuffer iMediaBuffer) {
        int length;
        try {
            length = iMediaBuffer.GetLength();
        }
        catch (IOException ioe) {
            length = 0;
            logger.error((Object)"IMediaBuffer.GetLength", (Throwable)ioe);
        }
        return length;
    }

    private static int maybeIMediaBufferGetLength(long iMediaBuffer) {
        int length;
        try {
            length = VoiceCaptureDSP.IMediaBuffer_GetLength(iMediaBuffer);
        }
        catch (HResultException hre) {
            length = 0;
            logger.error((Object)"IMediaBuffer_GetLength", (Throwable)hre);
        }
        return length;
    }

    private static int maybeMediaBufferPush(long pBuffer, byte[] buffer, int offset, int length) {
        HResultException exception;
        int written;
        try {
            written = VoiceCaptureDSP.MediaBuffer_push(pBuffer, buffer, offset, length);
            exception = null;
        }
        catch (HResultException hre) {
            written = 0;
            exception = hre;
        }
        if (exception != null || written != length) {
            logger.error((Object)("Failed to push/write " + (written <= 0 ? length : length - written) + " bytes into an IMediaBuffer."), (Throwable)exception);
        }
        return written;
    }

    static void throwNewIOException(String message, HResultException hre) throws IOException {
        logger.error((Object)message, (Throwable)hre);
        IOException ioe = new IOException(message);
        ioe.initCause(hre);
        throw ioe;
    }

    public WASAPIStream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
    }

    private long computeCaptureDuration(int length) {
        return (long)((double)length * this.captureNanosPerByte);
    }

    private int computeRenderLength(long duration) {
        return (int)((double)duration * this.renderBytesPerNano);
    }

    private void configureAEC(long iPropertyStore) throws HResultException {
        try {
            if (VoiceCaptureDSP.MFPKEY_WMAAECMA_FEATURE_MODE != 0L) {
                VoiceCaptureDSP.IPropertyStore_SetValue(iPropertyStore, VoiceCaptureDSP.MFPKEY_WMAAECMA_FEATURE_MODE, true);
                WASAPISystem audioSystem = ((DataSource)this.dataSource).audioSystem;
                if (VoiceCaptureDSP.MFPKEY_WMAAECMA_FEATR_AES != 0L) {
                    VoiceCaptureDSP.IPropertyStore_SetValue(iPropertyStore, VoiceCaptureDSP.MFPKEY_WMAAECMA_FEATR_AES, audioSystem.isEchoCancel() ? 2 : 0);
                }
                boolean isAGC = audioSystem.isAutomaticGainControl();
                if (VoiceCaptureDSP.MFPKEY_WMAAECMA_FEATR_AGC != 0L) {
                    VoiceCaptureDSP.IPropertyStore_SetValue(iPropertyStore, VoiceCaptureDSP.MFPKEY_WMAAECMA_FEATR_AGC, isAGC);
                }
                if (VoiceCaptureDSP.MFPKEY_WMAAECMA_MIC_GAIN_BOUNDER != 0L) {
                    VoiceCaptureDSP.IPropertyStore_SetValue(iPropertyStore, VoiceCaptureDSP.MFPKEY_WMAAECMA_MIC_GAIN_BOUNDER, isAGC);
                }
                if (VoiceCaptureDSP.MFPKEY_WMAAECMA_FEATR_NS != 0L) {
                    VoiceCaptureDSP.IPropertyStore_SetValue(iPropertyStore, VoiceCaptureDSP.MFPKEY_WMAAECMA_FEATR_NS, audioSystem.isDenoise() ? 1 : 0);
                }
                if (VoiceCaptureDSP.MFPKEY_WMAAECMA_FEATR_ECHO_LENGTH != 0L) {
                    VoiceCaptureDSP.IPropertyStore_SetValue(iPropertyStore, VoiceCaptureDSP.MFPKEY_WMAAECMA_FEATR_ECHO_LENGTH, 256);
                }
            }
        }
        catch (HResultException hre) {
            logger.error((Object)"Failed to perform optional configuration on the Voice Capture DSP that implements acoustic echo cancellation (AEC).", (Throwable)hre);
        }
    }

    private synchronized void connect() throws IOException {
        if (this.capture != null) {
            return;
        }
        try {
            this.doConnect();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"Failed to connect a WASAPIStream to an audio endpoint device.", t);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            IOException ioe = new IOException();
            ioe.initCause(t);
            throw ioe;
        }
    }

    private synchronized void disconnect() throws IOException {
        try {
            this.stop();
        }
        finally {
            this.uninitializeAEC();
            this.uninitializeRender();
            this.uninitializeCapture();
            this.maybeCloseResampler();
            this.effectiveFormat = null;
            this.format = null;
            this.sourceMode = false;
            ((DataSource)this.dataSource).audioSystem.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() throws Exception {
        MediaLocator locator = this.getLocator();
        if (locator == null) {
            throw new NullPointerException("No locator set.");
        }
        AudioFormat format = (AudioFormat)this.getFormat();
        if (format == null) {
            throw new NullPointerException("No format set.");
        }
        WASAPISystem audioSystem = ((DataSource)this.dataSource).audioSystem;
        AudioFormat effectiveFormat = null;
        if (((DataSource)this.dataSource).aec) {
            this.aec = true;
            try {
                CaptureDeviceInfo2 renderDevice;
                CaptureDeviceInfo2 captureDevice = audioSystem.getDevice(AudioSystem.DataFlow.CAPTURE, locator);
                if (captureDevice != null && (renderDevice = audioSystem.getSelectedDevice(AudioSystem.DataFlow.PLAYBACK)) != null) {
                    boolean sourceMode = true;
                    effectiveFormat = sourceMode ? this.doConnectInSourceMode(captureDevice, renderDevice, format) : this.doConnectInFilterMode(captureDevice, renderDevice, format);
                    this.sourceMode = sourceMode;
                }
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error((Object)"Failed to enable acoustic echo cancellation (AEC). Will try without it.", t);
            }
        }
        if (this.iMediaObject == 0L) {
            this.aec = false;
            this.renderDevice = null;
            this.renderDeviceIndex = -1;
            this.initializeCapture(locator, format);
            effectiveFormat = this.capture.outFormat;
        }
        this.effectiveFormat = effectiveFormat;
        this.format = format;
        boolean disconnect = true;
        try {
            this.maybeOpenResampler();
            if (this.resampler != null) {
                this.resamplerBuffer = new Buffer();
            }
            if (((DataSource)this.dataSource).aec) {
                audioSystem.addPropertyChangeListener(this.propertyChangeListener);
            } else {
                audioSystem.removePropertyChangeListener(this.propertyChangeListener);
            }
            disconnect = false;
        }
        finally {
            if (disconnect) {
                this.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioFormat doConnectInFilterMode(CaptureDeviceInfo2 captureDevice, CaptureDeviceInfo2 renderDevice, AudioFormat outFormat) throws Exception {
        AudioFormat aecOutFormat;
        AudioFormat renderFormat;
        MediaLocator renderLocator;
        AudioFormat captureFormat = this.findClosestMatchCaptureSupportedFormat(outFormat);
        if (captureFormat == null) {
            throw new IllegalStateException("Failed to determine an AudioFormat with which to initialize IAudioClient for MediaLocator " + this.locator + " based on AudioFormat " + outFormat);
        }
        if (renderDevice == null) {
            renderLocator = null;
            renderFormat = captureFormat;
        } else {
            renderLocator = renderDevice.getLocator();
            if (renderLocator == null) {
                throw new IllegalStateException("A CaptureDeviceInfo2 instance which describes a Windows Audio Session API (WASAPI) render endpoint device and which does not have an actual locator/MediaLocator is illegal.");
            }
            renderFormat = WASAPIStream.findClosestMatch(renderDevice.getFormats(), outFormat, NativelySupportedAudioFormat.class);
            if (renderFormat == null) {
                throw new IllegalStateException("Failed to determine an AudioFormat with which to initialize IAudioClient for MediaLocator " + renderLocator + " based on AudioFormat " + outFormat);
            }
        }
        boolean uninitialize = true;
        this.initializeCapture(this.locator, captureFormat);
        try {
            if (renderLocator != null) {
                this.initializeRender(renderLocator, renderFormat);
            }
            try {
                aecOutFormat = this.initializeAEC(false, captureDevice, captureFormat, renderDevice, renderFormat, outFormat);
                uninitialize = false;
            }
            finally {
                if (uninitialize) {
                    this.uninitializeRender();
                }
            }
        }
        finally {
            if (uninitialize) {
                this.uninitializeCapture();
            }
        }
        return aecOutFormat;
    }

    private AudioFormat doConnectInSourceMode(CaptureDeviceInfo2 captureDevice, CaptureDeviceInfo2 renderDevice, AudioFormat outFormat) throws Exception {
        return this.initializeAEC(true, captureDevice, null, renderDevice, null, outFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Format doGetFormat() {
        WASAPIStream wASAPIStream = this;
        synchronized (wASAPIStream) {
            if (this.format != null) {
                return this.format;
            }
        }
        return super.doGetFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(Buffer buffer) throws IOException {
        int length;
        block31: {
            Throwable cause;
            int capacity = this.aec ? this.bufferMaxLength : this.bufferSize;
            byte[] data = AbstractCodec2.validateByteArraySize(buffer, capacity, false);
            length = 0;
            buffer.setLength(0);
            buffer.setOffset(0);
            while (true) {
                int read;
                String message;
                WASAPIStream wASAPIStream = this;
                synchronized (wASAPIStream) {
                    boolean connected;
                    boolean bl = connected = this.capture != null || this.sourceMode;
                    if (connected) {
                        message = null;
                        this.captureIsBusy = true;
                        this.renderIsBusy = true;
                    } else {
                        message = this.getClass().getName() + " is disconnected.";
                    }
                }
                if (message != null) {
                    this.yield();
                    throw new IOException(message);
                }
                try {
                    boolean aec;
                    int toRead = capacity - length;
                    boolean bl = aec = this.iMediaObject != 0L;
                    if (aec) {
                        if ((toRead = Math.min(toRead, this.processedLength)) == 0) {
                            read = 0;
                        } else {
                            System.arraycopy(this.processed, 0, data, length, toRead);
                            this.popFromProcessed(toRead);
                            read = toRead;
                        }
                    } else {
                        read = this.capture.read(data, length, toRead);
                    }
                    cause = null;
                }
                catch (Throwable t) {
                    read = 0;
                    cause = t;
                }
                finally {
                    WASAPIStream toRead = this;
                    synchronized (toRead) {
                        this.captureIsBusy = false;
                        this.renderIsBusy = false;
                        this.notifyAll();
                    }
                }
                if (cause != null) break;
                if (length == 0) {
                    long timeStamp = System.nanoTime();
                    buffer.setFlags(128);
                    buffer.setTimeStamp(timeStamp);
                }
                if ((length += read) >= capacity || read == 0) {
                    if (this.effectiveFormat != null) {
                        buffer.setFormat((Format)this.effectiveFormat);
                    }
                    break block31;
                }
                this.yield();
            }
            if (cause instanceof ThreadDeath) {
                throw (ThreadDeath)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            IOException ioe = new IOException();
            ioe.initCause(cause);
            throw ioe;
        }
        buffer.setLength(length);
    }

    private AudioFormat findClosestMatchCaptureSupportedFormat(AudioFormat format) {
        return WASAPIStream.findClosestMatch(((DataSource)this.dataSource).getIAudioClientSupportedFormats(), format, NativelySupportedAudioFormat.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Format getFormat() {
        WASAPIStream wASAPIStream = this;
        synchronized (wASAPIStream) {
            if (this.format != null) {
                return this.format;
            }
        }
        return super.getFormat();
    }

    private MediaLocator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioFormat initializeAEC(boolean sourceMode, CaptureDeviceInfo2 captureDevice, AudioFormat captureFormat, CaptureDeviceInfo2 renderDevice, AudioFormat renderFormat, AudioFormat outFormat) throws Exception {
        WASAPISystem audioSystem = ((DataSource)this.dataSource).audioSystem;
        AudioFormat aecOutFormat = WASAPIStream.findClosestMatch(audioSystem.getAECSupportedFormats(), outFormat, null);
        if (aecOutFormat == null) {
            throw new IllegalStateException("Failed to determine an AudioFormat with which to initialize Voice Capture DSP/acoustic echo cancellation (AEC) based on AudioFormat " + outFormat);
        }
        long iMediaObject = audioSystem.initializeAEC();
        if (iMediaObject == 0L) {
            throw new ResourceUnavailableException("Failed to initialize a Voice Capture DSP for the purposes of acoustic echo cancellation (AEC).");
        }
        try {
            long iPropertyStore = VoiceCaptureDSP.IMediaObject_QueryInterface(iMediaObject, "{886d8eeb-8cf2-4446-8d02-cdba1dbdcf99}");
            if (iPropertyStore == 0L) {
                throw new RuntimeException("IMediaObject_QueryInterface IID_IPropertyStore");
            }
            try {
                int outFrames;
                int hresult = VoiceCaptureDSP.IPropertyStore_SetValue(iPropertyStore, VoiceCaptureDSP.MFPKEY_WMAAECMA_DMO_SOURCE_MODE, sourceMode);
                if (WASAPI.FAILED(hresult)) {
                    throw new HResultException(hresult, "IPropertyStore_SetValue MFPKEY_WMAAECMA_DMO_SOURCE_MODE");
                }
                this.configureAEC(iPropertyStore);
                hresult = WASAPIStream.IMediaObject_SetXXXputType(iMediaObject, false, 0, aecOutFormat, 0);
                if (WASAPI.FAILED(hresult)) {
                    throw new HResultException(hresult, "IMediaObject_SetOutputType, " + aecOutFormat);
                }
                int outFrameSize = WASAPISystem.getSampleSizeInBytes(aecOutFormat) * aecOutFormat.getChannels();
                long iMediaBuffer = VoiceCaptureDSP.MediaBuffer_alloc(outFrameSize * (outFrames = (int)(20L * (long)((int)aecOutFormat.getSampleRate()) / 1000L)));
                if (iMediaBuffer == 0L) {
                    throw new OutOfMemoryError("MediaBuffer_alloc");
                }
                try {
                    long dmoOutputDataBuffer = VoiceCaptureDSP.DMO_OUTPUT_DATA_BUFFER_alloc(iMediaBuffer, 0, 0L, 0L);
                    if (dmoOutputDataBuffer == 0L) {
                        throw new OutOfMemoryError("DMO_OUTPUT_DATA_BUFFER_alloc");
                    }
                    try {
                        this.bufferMaxLength = VoiceCaptureDSP.IMediaBuffer_GetMaxLength(iMediaBuffer);
                        this.processed = new byte[this.bufferMaxLength * 3];
                        this.processedLength = 0;
                        this.renderDevice = renderDevice == null ? null : renderDevice.getLocator();
                        this.renderDeviceIndex = -1;
                        if (sourceMode) {
                            this.initializeAECInSourceMode(iPropertyStore, captureDevice, renderDevice);
                        } else {
                            this.initializeAECInFilterMode(iMediaObject, captureFormat, renderFormat);
                        }
                        this.dmoOutputDataBuffer = dmoOutputDataBuffer;
                        dmoOutputDataBuffer = 0L;
                        this.iMediaBuffer = iMediaBuffer;
                        iMediaBuffer = 0L;
                        Object object = this.iMediaObjectLock;
                        synchronized (object) {
                            this.iMediaObject = iMediaObject;
                        }
                        iMediaObject = 0L;
                    }
                    finally {
                        if (dmoOutputDataBuffer != 0L) {
                            WASAPI.CoTaskMemFree(dmoOutputDataBuffer);
                        }
                    }
                }
                finally {
                    if (iMediaBuffer != 0L) {
                        VoiceCaptureDSP.IMediaBuffer_Release(iMediaBuffer);
                    }
                }
            }
            finally {
                if (iPropertyStore != 0L) {
                    WASAPI.IPropertyStore_Release(iPropertyStore);
                }
            }
        }
        finally {
            if (iMediaObject != 0L) {
                VoiceCaptureDSP.IMediaObject_Release(iMediaObject);
            }
        }
        return aecOutFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAECInFilterMode(long iMediaObject, AudioFormat inFormat0, AudioFormat inFormat1) throws Exception {
        int dwInputStreamIndex = 0;
        int hresult = WASAPIStream.IMediaObject_SetXXXputType(iMediaObject, true, dwInputStreamIndex, inFormat0, 0);
        if (WASAPI.FAILED(hresult)) {
            throw new HResultException(hresult, "IMediaObject_SetInputType, dwInputStreamIndex " + dwInputStreamIndex + ", " + inFormat0);
        }
        dwInputStreamIndex = 1;
        hresult = WASAPIStream.IMediaObject_SetXXXputType(iMediaObject, true, dwInputStreamIndex, inFormat1, 0);
        if (WASAPI.FAILED(hresult)) {
            throw new HResultException(hresult, "IMediaObject_SetInputType, dwInputStreamIndex " + dwInputStreamIndex + ", " + inFormat1);
        }
        long captureIMediaBuffer = VoiceCaptureDSP.MediaBuffer_alloc(this.capture.bufferSize);
        if (captureIMediaBuffer == 0L) {
            throw new OutOfMemoryError("MediaBuffer_alloc");
        }
        try {
            long renderIMediaBuffer = VoiceCaptureDSP.MediaBuffer_alloc((this.render == null ? this.capture : this.render).bufferSize);
            if (renderIMediaBuffer == 0L) {
                throw new OutOfMemoryError("MediaBuffer_alloc");
            }
            try {
                this.captureBufferMaxLength = VoiceCaptureDSP.IMediaBuffer_GetMaxLength(captureIMediaBuffer);
                this.renderBufferMaxLength = VoiceCaptureDSP.IMediaBuffer_GetMaxLength(renderIMediaBuffer);
                this.captureIMediaBuffer = new PtrMediaBuffer(captureIMediaBuffer);
                captureIMediaBuffer = 0L;
                this.renderIMediaBuffer = new PtrMediaBuffer(renderIMediaBuffer);
                renderIMediaBuffer = 0L;
                AudioFormat af = this.capture.outFormat;
                double sampleRate = af.getSampleRate();
                int sampleSizeInBits = af.getSampleSizeInBits();
                int channels = af.getChannels();
                this.captureNanosPerByte = 8.0E9 / (sampleRate * (double)sampleSizeInBits * (double)channels);
                af = (this.render == null ? this.capture : this.render).outFormat;
                sampleRate = af.getSampleRate();
                sampleSizeInBits = af.getSampleSizeInBits();
                channels = af.getChannels();
                this.renderBytesPerNano = sampleRate * (double)sampleSizeInBits * (double)channels / 8.0E9;
            }
            finally {
                if (renderIMediaBuffer != 0L) {
                    VoiceCaptureDSP.IMediaBuffer_Release(renderIMediaBuffer);
                }
            }
        }
        finally {
            if (captureIMediaBuffer != 0L) {
                VoiceCaptureDSP.IMediaBuffer_Release(captureIMediaBuffer);
            }
        }
    }

    private void initializeAECInSourceMode(long iPropertyStore, CaptureDeviceInfo2 captureDevice, CaptureDeviceInfo2 renderDevice) throws Exception {
        WASAPISystem audioSystem = ((DataSource)this.dataSource).audioSystem;
        int captureDeviceIndex = audioSystem.getIMMDeviceIndex(captureDevice.getLocator().getRemainder(), 1);
        if (captureDeviceIndex == -1) {
            throw new IllegalStateException("Acoustic echo cancellation (AEC) cannot be initialized without a microphone.");
        }
        MediaLocator renderLocator = renderDevice.getLocator();
        int renderDeviceIndex = audioSystem.getIMMDeviceIndex(renderLocator.getRemainder(), 0);
        if (renderDeviceIndex == -1) {
            throw new IllegalStateException("Acoustic echo cancellation (AEC) cannot be initialized without a speaker (line).");
        }
        int hresult = VoiceCaptureDSP.IPropertyStore_SetValue(iPropertyStore, VoiceCaptureDSP.MFPKEY_WMAAECMA_DEVICE_INDEXES, 0xFFFF & captureDeviceIndex | (0xFFFF & renderDeviceIndex) << 16);
        if (WASAPI.FAILED(hresult)) {
            throw new HResultException(hresult, "IPropertyStore_SetValue MFPKEY_WMAAECMA_DEVICE_INDEXES");
        }
        WASAPIRenderer renderer = new WASAPIRenderer();
        renderer.setLocator(renderLocator);
        Format[] rendererSupportedInputFormats = ((AbstractAudioRenderer)renderer).getSupportedInputFormats();
        if (rendererSupportedInputFormats != null && rendererSupportedInputFormats.length != 0) {
            ((AbstractRenderer)renderer).setInputFormat(rendererSupportedInputFormats[0]);
        }
        ((AbstractAudioRenderer)renderer).open();
        this.devicePeriod = 5L;
        this.renderDeviceIndex = renderDeviceIndex;
        this.renderer = renderer;
    }

    private void initializeCapture(MediaLocator locator, AudioFormat format) throws Exception {
        long hnsBufferDuration = this.aec ? -1L : 20L;
        AudioFormat captureFormat = this.findClosestMatchCaptureSupportedFormat(format);
        if (captureFormat == null) {
            throw new IllegalStateException("Failed to determine an AudioFormat with which to initialize IAudioClient for MediaLocator " + locator + " based on AudioFormat " + format);
        }
        BufferTransferHandler transferHandler = new BufferTransferHandler(){

            public void transferData(PushBufferStream stream) {
                WASAPIStream.this.transferCaptureData();
            }
        };
        this.capture = new AudioCaptureClient(((DataSource)this.dataSource).audioSystem, locator, AudioSystem.DataFlow.CAPTURE, 0, hnsBufferDuration, captureFormat, transferHandler);
        this.bufferSize = this.capture.bufferSize;
        this.devicePeriod = this.capture.devicePeriod;
    }

    private void initializeRender(MediaLocator locator, AudioFormat format) throws Exception {
        BufferTransferHandler transferHandler = new BufferTransferHandler(){

            public void transferData(PushBufferStream stream) {
                WASAPIStream.this.transferRenderData();
            }
        };
        this.render = new AudioCaptureClient(((DataSource)this.dataSource).audioSystem, locator, AudioSystem.DataFlow.PLAYBACK, 131072, 20L, format, transferHandler);
        this.replenishRender = true;
    }

    private void maybeCloseResampler() {
        Codec resampler = this.resampler;
        if (resampler != null) {
            this.resampler = null;
            this.resamplerBuffer = null;
            try {
                resampler.close();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error((Object)"Failed to close resampler.", t);
            }
        }
    }

    private void maybeOpenResampler() {
        AudioFormat inFormat = this.effectiveFormat;
        AudioFormat outFormat = this.format;
        if (inFormat.getSampleRate() == outFormat.getSampleRate() && inFormat.getSampleSizeInBits() == outFormat.getSampleSizeInBits()) {
            return;
        }
        Codec resampler = WASAPIRenderer.maybeOpenResampler(inFormat, outFormat);
        if (resampler == null) {
            throw new IllegalStateException("Failed to open a codec to resample [" + inFormat + "] into [" + outFormat + "].");
        }
        this.resampler = resampler;
    }

    private void popFromProcessed(int length) {
        this.processedLength = WASAPIRenderer.pop(this.processed, this.processedLength, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInput(int dwInputStreamIndex, int maxLength) {
        block38: {
            int dwFlags;
            AudioCaptureClient audioCaptureClient;
            int bufferMaxLength;
            PtrMediaBuffer oBuffer;
            switch (dwInputStreamIndex) {
                case 0: {
                    oBuffer = this.captureIMediaBuffer;
                    bufferMaxLength = this.captureBufferMaxLength;
                    audioCaptureClient = this.capture;
                    break;
                }
                case 1: {
                    oBuffer = this.renderIMediaBuffer;
                    bufferMaxLength = this.renderBufferMaxLength;
                    audioCaptureClient = this.render;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("dwInputStreamIndex");
                }
            }
            if (maxLength < 0 || maxLength > bufferMaxLength) {
                maxLength = bufferMaxLength;
            }
            long pBuffer = oBuffer.ptr;
            int hresult = 0;
            try {
                Object object = this.iMediaObjectLock;
                synchronized (object) {
                    if (this.iMediaObject != 0L) {
                        dwFlags = VoiceCaptureDSP.IMediaObject_GetInputStatus(this.iMediaObject, dwInputStreamIndex);
                    } else {
                        dwFlags = 0;
                        logger.error((Object)"iMediaObject is 0");
                    }
                }
            }
            catch (HResultException hre) {
                dwFlags = 0;
                hresult = hre.getHResult();
                logger.error((Object)"IMediaObject_GetInputStatus", (Throwable)hre);
            }
            if (!(dwFlags & true)) break block38;
            int toRead = -1;
            if (dwInputStreamIndex == 1) {
                if (audioCaptureClient == null) {
                    toRead = 0;
                } else if (this.replenishRender) {
                    int replenishThreshold = 3 * this.renderBufferMaxLength / 2;
                    if (audioCaptureClient.getAvailableLength() < replenishThreshold) {
                        toRead = 0;
                    } else {
                        this.replenishRender = false;
                    }
                }
            }
            if (toRead == -1) {
                try {
                    toRead = maxLength - VoiceCaptureDSP.IMediaBuffer_GetLength(pBuffer);
                }
                catch (HResultException hre) {
                    hresult = hre.getHResult();
                    toRead = 0;
                    logger.error((Object)"IMediaBuffer_GetLength", (Throwable)hre);
                }
            }
            if (toRead > 0) {
                try {
                    int read = audioCaptureClient.read(oBuffer, toRead);
                    if (dwInputStreamIndex == 1 && read == 0) {
                        this.replenishRender = true;
                    }
                }
                catch (IOException ioe) {
                    logger.error((Object)"Failed to read from IAudioCaptureClient.", (Throwable)ioe);
                }
            }
            if (dwInputStreamIndex == 1) {
                int length;
                try {
                    length = VoiceCaptureDSP.IMediaBuffer_GetLength(pBuffer);
                }
                catch (HResultException hre) {
                    hresult = hre.getHResult();
                    length = 0;
                    logger.error((Object)"IMediaBuffer_GetLength", (Throwable)hre);
                }
                int silence = maxLength - length;
                if (silence > 0) {
                    if (this.processInputBuffer == null || this.processInputBuffer.length < silence) {
                        this.processInputBuffer = new byte[silence];
                    }
                    Arrays.fill(this.processInputBuffer, 0, silence, (byte)0);
                    WASAPIStream.maybeMediaBufferPush(pBuffer, this.processInputBuffer, 0, silence);
                }
            }
            try {
                Object length = this.iMediaObjectLock;
                synchronized (length) {
                    if (this.iMediaObject != 0L) {
                        hresult = VoiceCaptureDSP.IMediaObject_ProcessInput(this.iMediaObject, dwInputStreamIndex, pBuffer, 0, 0L, 0L);
                    } else {
                        logger.error((Object)"iMediaObject is 0");
                    }
                }
            }
            catch (HResultException hre) {
                hresult = hre.getHResult();
                if (hresult == -2147220988) break block38;
                logger.error((Object)"IMediaObject_ProcessInput", (Throwable)hre);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutput() {
        int dwStatus = 0;
        do {
            try {
                Object object = this.iMediaObjectLock;
                synchronized (object) {
                    if (this.iMediaObject != 0L) {
                        VoiceCaptureDSP.IMediaObject_ProcessOutput(this.iMediaObject, 0, 1, this.dmoOutputDataBuffer);
                        dwStatus = VoiceCaptureDSP.DMO_OUTPUT_DATA_BUFFER_getDwStatus(this.dmoOutputDataBuffer);
                    } else {
                        dwStatus = 0;
                        logger.error((Object)"iMediaObject is 0");
                    }
                }
            }
            catch (HResultException hre) {
                dwStatus = 0;
                logger.error((Object)"IMediaObject_ProcessOutput", (Throwable)hre);
            }
            try {
                int read;
                int toRead = VoiceCaptureDSP.IMediaBuffer_GetLength(this.iMediaBuffer);
                if (toRead <= 0) continue;
                int toPop = toRead - (this.processed.length - this.processedLength);
                if (toPop > 0) {
                    this.popFromProcessed(toPop);
                }
                if ((read = VoiceCaptureDSP.MediaBuffer_pop(this.iMediaBuffer, this.processed, this.processedLength, toRead)) <= 0) continue;
                this.processedLength += read;
            }
            catch (HResultException hre) {
                logger.error((Object)"Failed to read from acoustic echo cancellation (AEC) output IMediaBuffer.", (Throwable)hre);
                break;
            }
        } while ((dwStatus & 0x1000000) == 0x1000000);
    }

    private synchronized void propertyChange(PropertyChangeEvent ev) throws Exception {
        boolean renderDeviceDidChange;
        String propertyName = ev.getPropertyName();
        if ("devices".equals(propertyName)) {
            renderDeviceDidChange = true;
        } else if ("playbackDevice".equals(propertyName)) {
            MediaLocator newRenderDevice;
            MediaLocator oldRenderDevice = this.renderDevice;
            WASAPISystem audioSystem = ((DataSource)this.dataSource).audioSystem;
            CaptureDeviceInfo2 newRenderDeviceInfo = audioSystem.getSelectedDevice(AudioSystem.DataFlow.PLAYBACK);
            MediaLocator mediaLocator = newRenderDevice = newRenderDeviceInfo == null ? null : newRenderDeviceInfo.getLocator();
            if (oldRenderDevice == null ? newRenderDevice == null : oldRenderDevice.equals((Object)newRenderDevice)) {
                int oldRenderDeviceIndex = this.renderDeviceIndex;
                int newRenderDeviceIndex = newRenderDevice == null ? -1 : audioSystem.getIMMDeviceIndex(newRenderDevice.getRemainder(), 0);
                renderDeviceDidChange = oldRenderDeviceIndex != newRenderDeviceIndex;
            } else {
                renderDeviceDidChange = true;
            }
        } else {
            renderDeviceDidChange = false;
        }
        if (renderDeviceDidChange) {
            boolean connected;
            this.waitWhileCaptureIsBusy();
            this.waitWhileRenderIsBusy();
            boolean bl = connected = this.capture != null || this.iMediaObject != 0L;
            if (connected) {
                boolean started = this.started;
                this.disconnect();
                this.connect();
                if (started) {
                    this.start();
                }
            }
        }
    }

    public void read(Buffer buffer) throws IOException {
        Codec resampler = this.resampler;
        if (resampler == null) {
            this.doRead(buffer);
        } else {
            Buffer resamplerBuffer = this.resamplerBuffer;
            this.doRead(resamplerBuffer);
            int process = resampler.process(resamplerBuffer, buffer);
            if (process == 1) {
                throw new IOException("Failed to resample from [" + this.effectiveFormat + "] into [" + this.format + "].");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferTransferHandler runInProcessThread() {
        boolean flush;
        int captureMaxLength = this.captureBufferMaxLength;
        do {
            if (this.sourceMode) {
                flush = false;
            } else {
                this.processInput(0, captureMaxLength);
                int captureLength = WASAPIStream.maybeIMediaBufferGetLength(this.captureIMediaBuffer);
                if (captureLength < captureMaxLength) {
                    flush = false;
                } else {
                    int renderMaxLength = this.computeRenderLength(this.computeCaptureDuration(captureLength));
                    this.processInput(1, renderMaxLength);
                    flush = true;
                }
            }
            this.processOutput();
            try {
                Object captureLength = this.iMediaObjectLock;
                synchronized (captureLength) {
                    if (this.iMediaObject != 0L) {
                        if (WASAPI.SUCCEEDED(VoiceCaptureDSP.IMediaObject_Flush(this.iMediaObject)) && flush) {
                            this.captureIMediaBuffer.SetLength(0);
                            this.renderIMediaBuffer.SetLength(0);
                        }
                    } else {
                        logger.error((Object)"iMediaObject is 0");
                    }
                }
            }
            catch (HResultException hre) {
                logger.error((Object)"IMediaBuffer_Flush", (Throwable)hre);
            }
            catch (IOException ioe) {
                logger.error((Object)"IMediaBuffer.SetLength", (Throwable)ioe);
            }
        } while (flush);
        BufferTransferHandler transferHandler = this.transferHandler;
        if (transferHandler != null && this.processedLength >= this.bufferMaxLength) {
            return transferHandler;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInProcessThread(Thread processThread) {
        try {
            WASAPISystem.CoInitializeEx();
            AbstractAudioRenderer.useAudioThreadPriority();
            while (true) {
                WASAPIStream transferHandler;
                WASAPIStream wASAPIStream = this;
                synchronized (wASAPIStream) {
                    boolean connected;
                    if (!processThread.equals(this.processThread)) {
                        break;
                    }
                    boolean bl = connected = this.capture != null || this.sourceMode;
                    if (!connected || !this.started) {
                        break;
                    }
                    this.waitWhileCaptureIsBusy();
                    this.waitWhileRenderIsBusy();
                    this.captureIsBusy = true;
                    this.renderIsBusy = true;
                }
                try {
                    transferHandler = this.runInProcessThread();
                }
                finally {
                    wASAPIStream = this;
                    synchronized (wASAPIStream) {
                        this.captureIsBusy = false;
                        this.renderIsBusy = false;
                        this.notifyAll();
                    }
                }
                if (transferHandler != null) {
                    try {
                        transferHandler.transferData(this);
                        continue;
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error((Object)"BufferTransferHandler.transferData", t);
                    }
                }
                this.yield();
            }
        }
        catch (HResultException e) {
            logger.error((Object)"COM init in stream processing thread failed", (Throwable)e);
        }
        finally {
            WASAPIStream wASAPIStream = this;
            synchronized (wASAPIStream) {
                if (processThread.equals(this.processThread)) {
                    this.processThread = null;
                    this.notifyAll();
                }
            }
        }
    }

    void setLocator(MediaLocator locator) throws IOException {
        if (this.locator != locator) {
            if (this.locator != null) {
                this.disconnect();
            }
            this.locator = locator;
            if (this.locator != null) {
                this.connect();
            }
        }
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.capture != null) {
            this.waitWhileCaptureIsBusy();
            this.capture.start();
        }
        if (this.render != null) {
            this.waitWhileRenderIsBusy();
            this.render.start();
        }
        this.started = true;
        if (this.aec && (this.capture != null || this.sourceMode) && this.processThread == null) {
            if (this.renderer != null) {
                this.renderer.start();
            }
            this.processThread = new Thread(WASAPIStream.class + ".processThread"){

                @Override
                public void run() {
                    WASAPIStream.this.runInProcessThread(this);
                }
            };
            this.processThread.setDaemon(true);
            this.processThread.start();
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        if (this.capture != null) {
            this.waitWhileCaptureIsBusy();
            this.capture.stop();
        }
        if (this.render != null) {
            this.waitWhileRenderIsBusy();
            this.render.stop();
            this.replenishRender = true;
        }
        this.started = false;
        this.waitWhileProcessThread();
        this.processedLength = 0;
        if (this.renderer != null) {
            this.renderer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferCaptureData() {
        if (this.aec) {
            WASAPIStream wASAPIStream = this;
            synchronized (wASAPIStream) {
                this.notifyAll();
            }
        } else {
            BufferTransferHandler transferHandler = this.transferHandler;
            if (transferHandler != null) {
                transferHandler.transferData((PushBufferStream)this);
            }
        }
    }

    private void transferRenderData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninitializeAEC() {
        Object object = this.iMediaObjectLock;
        synchronized (object) {
            if (this.iMediaObject != 0L) {
                VoiceCaptureDSP.IMediaObject_Release(this.iMediaObject);
                this.iMediaObject = 0L;
            }
        }
        if (this.dmoOutputDataBuffer != 0L) {
            WASAPI.CoTaskMemFree(this.dmoOutputDataBuffer);
            this.dmoOutputDataBuffer = 0L;
        }
        if (this.iMediaBuffer != 0L) {
            VoiceCaptureDSP.IMediaBuffer_Release(this.iMediaBuffer);
            this.iMediaBuffer = 0L;
        }
        if (this.renderIMediaBuffer != null) {
            this.renderIMediaBuffer.Release();
            this.renderIMediaBuffer = null;
        }
        if (this.captureIMediaBuffer != null) {
            this.captureIMediaBuffer.Release();
            this.captureIMediaBuffer = null;
        }
        Renderer renderer = this.renderer;
        this.renderer = null;
        if (renderer != null) {
            renderer.close();
        }
    }

    private void uninitializeCapture() {
        if (this.capture != null) {
            this.capture.close();
            this.capture = null;
        }
    }

    private void uninitializeRender() {
        if (this.render != null) {
            this.render.close();
            this.render = null;
        }
    }

    private synchronized void waitWhileCaptureIsBusy() {
        boolean interrupted = false;
        while (this.captureIsBusy) {
            try {
                this.wait(this.devicePeriod);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void waitWhileProcessThread() {
        while (this.processThread != null) {
            this.yield();
        }
    }

    private synchronized void waitWhileRenderIsBusy() {
        boolean interrupted = false;
        while (this.renderIsBusy) {
            try {
                this.wait(this.devicePeriod);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void yield() {
        boolean interrupted = false;
        try {
            this.wait(this.devicePeriod);
        }
        catch (InterruptedException ie) {
            interrupted = true;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

