/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import javax.media.Format;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.SourceStream;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.conference.AudioMixer;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.protocol.TranscodingDataSource;
import org.jitsi.utils.logging.Logger;

class InDataSourceDesc {
    private static final SourceStream[] EMPTY_STREAMS = new SourceStream[0];
    private static final Logger logger = Logger.getLogger(InDataSourceDesc.class);
    private boolean connected;
    private Thread connectThread;
    public final DataSource inDataSource;
    public final AudioMixingPushBufferDataSource outDataSource;
    private DataSource transcodingDataSource;

    public InDataSourceDesc(DataSource inDataSource, AudioMixingPushBufferDataSource outDataSource) {
        this.inDataSource = inDataSource;
        this.outDataSource = outDataSource;
    }

    synchronized void connect(final AudioMixer audioMixer) throws IOException {
        DataSource effectiveInDataSource;
        DataSource dataSource = effectiveInDataSource = this.transcodingDataSource == null ? this.inDataSource : this.transcodingDataSource;
        if (effectiveInDataSource instanceof TranscodingDataSource) {
            if (this.connectThread == null) {
                this.connectThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            audioMixer.connect(effectiveInDataSource, InDataSourceDesc.this.inDataSource);
                            InDataSourceDesc inDataSourceDesc = InDataSourceDesc.this;
                            synchronized (inDataSourceDesc) {
                                InDataSourceDesc.this.connected = true;
                            }
                            audioMixer.connected(InDataSourceDesc.this);
                        }
                        catch (IOException ioex) {
                            logger.error((Object)("Failed to connect to inDataSource " + MediaStreamImpl.toString(InDataSourceDesc.this.inDataSource)), (Throwable)ioex);
                        }
                        finally {
                            InDataSourceDesc inDataSourceDesc = InDataSourceDesc.this;
                            synchronized (inDataSourceDesc) {
                                if (InDataSourceDesc.this.connectThread == Thread.currentThread()) {
                                    InDataSourceDesc.this.connectThread = null;
                                }
                            }
                        }
                    }
                };
                this.connectThread.setDaemon(true);
                this.connectThread.start();
            }
        } else {
            audioMixer.connect(effectiveInDataSource, this.inDataSource);
            this.connected = true;
        }
    }

    synchronized boolean createTranscodingDataSource(Format outFormat) {
        if (this.transcodingDataSource == null) {
            this.setTranscodingDataSource(new TranscodingDataSource(this.inDataSource, outFormat));
            return true;
        }
        return false;
    }

    synchronized void disconnect() {
        if (this.connected) {
            this.getEffectiveInDataSource().disconnect();
            this.connected = false;
        }
    }

    public synchronized Object getControl(String controlType) {
        DataSource effectiveInDataSource = this.getEffectiveInDataSource();
        return effectiveInDataSource == null ? null : effectiveInDataSource.getControl(controlType);
    }

    public synchronized DataSource getEffectiveInDataSource() {
        return this.transcodingDataSource == null ? this.inDataSource : (this.connected ? this.transcodingDataSource : null);
    }

    public DataSource getInDataSource() {
        return this.inDataSource;
    }

    public synchronized SourceStream[] getStreams() {
        if (!this.connected) {
            return EMPTY_STREAMS;
        }
        DataSource inDataSource = this.getEffectiveInDataSource();
        if (inDataSource instanceof PushBufferDataSource) {
            return ((PushBufferDataSource)inDataSource).getStreams();
        }
        if (inDataSource instanceof PullBufferDataSource) {
            return ((PullBufferDataSource)inDataSource).getStreams();
        }
        if (inDataSource instanceof TranscodingDataSource) {
            return ((TranscodingDataSource)inDataSource).getStreams();
        }
        return null;
    }

    public TranscodingDataSource getTranscodingDataSource() {
        return (TranscodingDataSource)this.transcodingDataSource;
    }

    private synchronized void setTranscodingDataSource(DataSource transcodingDataSource) {
        this.transcodingDataSource = transcodingDataSource;
        this.connected = false;
    }

    synchronized void start() throws IOException {
        if (this.connected) {
            this.getEffectiveInDataSource().start();
        }
    }

    synchronized void stop() throws IOException {
        if (this.connected) {
            this.getEffectiveInDataSource().stop();
        }
    }
}

