/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerBuilder;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0018\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002J,\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010!\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010&\u001a\u00020%2\u0006\u0010\f\u001a\u00020'2\u0006\u0010(\u001a\u00020\bH\u0016J(\u0010&\u001a\u00020%2\u0006\u0010\f\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010+J\u0018\u0010,\u001a\u0004\u0018\u00010\u0011*\u00020-2\b\b\u0002\u0010.\u001a\u00020\u001dH\u0002J\f\u0010/\u001a\u00020\u001d*\u00020\u0011H\u0002J\f\u00100\u001a\u00020\u001d*\u00020\u0011H\u0002\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "checkReservedYield", "", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "expression", "Lcom/intellij/psi/PsiElement;", "checkTypesForReturnStatements", "function", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "actualReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "collectReturns", "", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "computeReturnType", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "functionTypeExpected", "", "computeReturnTypeBasedOnReturnExpressions", "typeOfBodyExpression", "computeUnsafeReturnType", "expectedReturnType", "createFunctionLiteralDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "data", "isDeclaration", "statementScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "createFunctionType", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "suspendFunction", "isBuiltinFunctionalType", "isSuspendFunctionType", "frontend"})
public final class FunctionsTypingVisitor
extends ExpressionTypingVisitor {
    @Override
    @NotNull
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext data) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return this.visitNamedFunction(function2, data, false, null);
    }

    @NotNull
    public final KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext context, boolean isDeclaration, @Nullable LexicalWritableScope statementScope) {
        KotlinTypeInfo kotlinTypeInfo;
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!isDeclaration) {
            if (!function2.getTypeParameters().isEmpty()) {
                context.trace.report(Errors.TYPE_PARAMETERS_NOT_ALLOWED.on((KtDeclaration)((PsiElement)function2)));
            }
            if (function2.getName() != null) {
                BindingTrace bindingTrace = context.trace;
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                bindingTrace.report(Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(psiElement));
            }
            for (KtParameter parameter2 : function2.getValueParameters()) {
                if (parameter2.hasDefaultValue()) {
                    context.trace.report(Errors.ANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE.on((KtParameter)((PsiElement)parameter2)));
                }
                KtParameter ktParameter = parameter2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                if (!ktParameter.isVarArg()) continue;
                context.trace.report(Errors.USELESS_VARARG_ON_PARAMETER.on((KtParameter)((PsiElement)parameter2)));
            }
        }
        SimpleFunctionDescriptor functionDescriptor = null;
        if (isDeclaration) {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
            functionDescriptor = functionDescriptorResolver.resolveFunctionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo);
            boolean bl = statementScope != null;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$22 = false;
                String $i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$22 = "statementScope must be not null for function: " + function2.getName() + " at location " + PsiDiagnosticUtils.atLocation(function2);
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$22));
            }
            LexicalWritableScope lexicalWritableScope = statementScope;
            if (lexicalWritableScope == null) {
                Intrinsics.throwNpe();
            }
            lexicalWritableScope.addFunctionDescriptor(functionDescriptor);
        } else {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
            KotlinType kotlinType2 = context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.expectedType");
            functionDescriptor = functionDescriptorResolver.resolveFunctionExpressionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo, kotlinType2);
        }
        ForceResolveUtil.forceResolveAllContents(functionDescriptor.getAnnotations());
        LexicalScope lexicalScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace, this.components.overloadChecker);
        Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"FunctionDescriptorUtil.g\u2026mponents.overloadChecker)");
        LexicalScope functionInnerScope = lexicalScope;
        if (!function2.hasDeclaredReturnType() && !function2.hasBlockBody()) {
            ForceResolveUtil.forceResolveAllContents(functionDescriptor.getReturnType());
        } else {
            this.components.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function2, functionDescriptor, context.dataFlowInfo, null, context.trace);
        }
        ValueParameterResolver valueParameterResolver = this.components.valueParameterResolver;
        List<KtParameter> list2 = function2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.valueParameters");
        List<ValueParameterDescriptor> list3 = functionDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"functionDescriptor.valueParameters");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        valueParameterResolver.resolveValueParameters(list2, list3, functionInnerScope, dataFlowInfo, bindingTrace);
        this.components.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(function2, functionDescriptor);
        IdentifierChecker identifierChecker = this.components.identifierChecker;
        KtDeclaration ktDeclaration = function2;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"context.trace");
        identifierChecker.checkDeclaration(ktDeclaration, bindingTrace2);
        DeclarationsCheckerBuilder declarationsCheckerBuilder = this.components.declarationsCheckerBuilder;
        BindingTrace bindingTrace3 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace3, (String)"context.trace");
        declarationsCheckerBuilder.withTrace(bindingTrace3).checkFunction(function2, functionDescriptor);
        if (isDeclaration) {
            kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(function2, context), context);
        } else {
            KotlinType kotlinType3 = context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"context.expectedType");
            KotlinType expectedType = kotlinType3;
            boolean functionalTypeExpected = this.isBuiltinFunctionalType(expectedType);
            KotlinType resultType = this.createFunctionType(functionDescriptor, false);
            if (this.components.languageVersionSettings.supportsFeature(LanguageFeature.NewInference) && functionalTypeExpected && !FunctionTypesKt.isSuspendFunctionType(expectedType)) {
                kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(resultType, context);
            } else {
                KotlinTypeInfo kotlinTypeInfo2 = this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, function2);
                kotlinTypeInfo = kotlinTypeInfo2;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinTypeInfo2, (String)"components.dataFlowAnaly\u2026tType, context, function)");
            }
        }
        return kotlinTypeInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType createFunctionType(@NotNull SimpleFunctionDescriptor $this$createFunctionType, boolean suspendFunction) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinBuiltIns, (String)"components.builtIns");
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$createFunctionType.getExtensionReceiverParameter();
        KotlinType kotlinType2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        List<ValueParameterDescriptor> list2 = $this$createFunctionType.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueParameters");
        Iterable iterable = list2;
        KotlinType kotlinType3 = kotlinType2;
        Annotations annotations3 = annotations2;
        KotlinBuiltIns kotlinBuiltIns2 = kotlinBuiltIns;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KotlinType kotlinType4;
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
            Intrinsics.checkExpressionValueIsNotNull((Object)v5.getType(), (String)"it.type");
            collection.add(kotlinType4);
        }
        collection = (List)destination$iv$iv;
        KotlinType kotlinType5 = $this$createFunctionType.getReturnType();
        if (kotlinType5 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType5, (String)"returnType ?: return null");
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns2, annotations3, kotlinType3, (List<? extends KotlinType>)collection, null, kotlinType5, suspendFunction);
    }

    @Override
    @Nullable
    public KotlinTypeInfo visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiElement psiElement = expression2;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        ReservedCheckingKt.checkReservedYieldBeforeLambda(psiElement, bindingTrace);
        if (!expression2.getFunctionLiteral().hasBody()) {
            return null;
        }
        KotlinType kotlinType2 = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.expectedType");
        KotlinType expectedType = kotlinType2;
        boolean functionTypeExpected = this.isBuiltinFunctionalType(expectedType);
        boolean suspendFunctionTypeExpected = this.isSuspendFunctionType(expectedType);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionLiteralDescriptor(expression2, context);
        List<KtParameter> list2 = expression2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"expression.valueParameters");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            IdentifierChecker identifierChecker = this.components.identifierChecker;
            KtParameter ktParameter = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"it");
            KtDeclaration ktDeclaration = ktParameter;
            BindingTrace bindingTrace2 = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"context.trace");
            identifierChecker.checkDeclaration(ktDeclaration, bindingTrace2);
            KtNamedDeclaration ktNamedDeclaration = it;
            BindingTrace bindingTrace3 = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace3, (String)"context.trace");
            DiagnosticSink diagnosticSink = bindingTrace3;
            LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
            Intrinsics.checkExpressionValueIsNotNull((Object)languageVersionSettings, (String)"components.languageVersionSettings");
            UnderscoreChecker.INSTANCE.checkNamed(ktNamedDeclaration, diagnosticSink, languageVersionSettings, true);
        }
        KotlinType safeReturnType = this.computeReturnType(expression2, context, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        KotlinType kotlinType3 = this.createFunctionType(functionDescriptor, suspendFunctionTypeExpected);
        if (kotlinType3 == null) {
            Intrinsics.throwNpe();
        }
        KotlinType resultType = kotlinType3;
        if (functionTypeExpected) {
            return TypeInfoFactoryKt.createTypeInfo(resultType, context);
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression2);
    }

    private final AnonymousFunctionDescriptor createFunctionLiteralDescriptor(KtLambdaExpression expression2, ExpressionTypingContext context) {
        KtFunctionLiteral ktFunctionLiteral = expression2.getFunctionLiteral();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"expression.functionLiteral");
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        AnnotationResolver annotationResolver = this.components.annotationResolver;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
        List<KtAnnotationEntry> list2 = KtPsiUtilKt.getAnnotationEntries(expression2);
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        Annotations annotations2 = annotationResolver.resolveAnnotationsWithArguments(lexicalScope, list2, bindingTrace);
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement(functionLiteral);
        KotlinType kotlinType2 = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.expectedType");
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(declarationDescriptor, annotations2, CallableMemberDescriptor.Kind.DECLARATION, sourceElement, this.isSuspendFunctionType(kotlinType2));
        FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
        DeclarationDescriptor declarationDescriptor2 = context.scope.getOwnerDescriptor();
        LexicalScope lexicalScope2 = context.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope2, (String)"context.scope");
        KtFunction ktFunction = functionLiteral;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"context.trace");
        KotlinType kotlinType3 = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"context.expectedType");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        functionDescriptorResolver.initializeFunctionDescriptorAndExplicitReturnType(declarationDescriptor2, lexicalScope2, ktFunction, simpleFunctionDescriptorImpl, bindingTrace2, kotlinType3, dataFlowInfo);
        for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
            ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context.trace, functionLiteral, functionDescriptor);
        return functionDescriptor;
    }

    private final boolean isBuiltinFunctionalType(@NotNull KotlinType $this$isBuiltinFunctionalType) {
        return !TypeUtils.noExpectedType($this$isBuiltinFunctionalType) && FunctionTypesKt.isBuiltinFunctionalType($this$isBuiltinFunctionalType);
    }

    private final boolean isSuspendFunctionType(@NotNull KotlinType $this$isSuspendFunctionType) {
        return !TypeUtils.noExpectedType($this$isSuspendFunctionType) && FunctionTypesKt.isSuspendFunctionType($this$isSuspendFunctionType);
    }

    private final KotlinType computeReturnType(KtLambdaExpression expression2, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        KotlinType kotlinType2;
        KotlinType kotlinType3;
        if (functionTypeExpected) {
            KotlinType kotlinType4 = context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"context.expectedType");
            kotlinType3 = FunctionTypesKt.getReturnTypeFromFunctionType(kotlinType4);
        } else {
            kotlinType3 = null;
        }
        KotlinType expectedReturnType = kotlinType3;
        KotlinType returnType2 = this.computeUnsafeReturnType(expression2, context, functionDescriptor, expectedReturnType);
        if (!expression2.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected) {
            KotlinType kotlinType5 = expectedReturnType;
            if (kotlinType5 == null) {
                Intrinsics.throwNpe();
            }
            if (!TypeUtils.noExpectedType(kotlinType5) && KotlinBuiltIns.isUnit(expectedReturnType)) {
                KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinBuiltIns, (String)"components.builtIns");
                SimpleType simpleType2 = kotlinBuiltIns.getUnitType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"components.builtIns.unitType");
                return simpleType2;
            }
        }
        if ((kotlinType2 = returnType2) == null) {
            SimpleType simpleType3 = TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"CANT_INFER_FUNCTION_PARAM_TYPE");
            kotlinType2 = simpleType3;
        }
        return kotlinType2;
    }

    private final KotlinType computeUnsafeReturnType(KtLambdaExpression expression2, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, KotlinType expectedReturnType) {
        KotlinType typeOfBodyExpression;
        KtFunctionLiteral functionLiteral;
        block3: {
            KtFunctionLiteral ktFunctionLiteral = expression2.getFunctionLiteral();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"expression.functionLiteral");
            functionLiteral = ktFunctionLiteral;
            KotlinType kotlinType2 = expectedReturnType;
            if (kotlinType2 == null) {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
                kotlinType2 = simpleType2;
            }
            KotlinType expectedType = kotlinType2;
            LexicalScope lexicalScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace, this.components.overloadChecker);
            Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"FunctionDescriptorUtil.g\u2026mponents.overloadChecker)");
            LexicalScope functionInnerScope = lexicalScope;
            Object Context2 = ((ExpressionTypingContext)context.replaceScope(functionInnerScope)).replaceExpectedType(expectedType);
            Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"context.replaceScope(fun\u2026xpectedType(expectedType)");
            ExpressionTypingContext newContext = (ExpressionTypingContext)Context2;
            context.trace.record(BindingContext.EXPECTED_RETURN_TYPE, functionLiteral, expectedType);
            KotlinResolutionCallbacksImpl.LambdaInfo newInferenceLambdaInfo = (KotlinResolutionCallbacksImpl.LambdaInfo)context.trace.get(BindingContext.NEW_INFERENCE_LAMBDA_INFO, expression2.getFunctionLiteral());
            if (newInferenceLambdaInfo == null && context.languageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
                Object Context3 = newContext.replaceContextDependency(ContextDependency.INDEPENDENT);
                Intrinsics.checkExpressionValueIsNotNull(Context3, (String)"newContext.replaceContex\u2026xtDependency.INDEPENDENT)");
                newContext = (ExpressionTypingContext)Context3;
            }
            ExpressionTypingServices expressionTypingServices = this.components.expressionTypingServices;
            KtBlockExpression ktBlockExpression = functionLiteral.getBodyExpression();
            if (ktBlockExpression == null) {
                Intrinsics.throwNpe();
            }
            KotlinTypeInfo kotlinTypeInfo = expressionTypingServices.getBlockReturnedType(ktBlockExpression, CoercionStrategy.COERCION_TO_UNIT, newContext);
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinTypeInfo, (String)"components.expressionTyp\u2026CION_TO_UNIT, newContext)");
            KotlinTypeInfo blockReturnedType = kotlinTypeInfo;
            typeOfBodyExpression = blockReturnedType.getType();
            KotlinResolutionCallbacksImpl.LambdaInfo lambdaInfo = newInferenceLambdaInfo;
            if (lambdaInfo == null) break block3;
            KotlinResolutionCallbacksImpl.LambdaInfo lambdaInfo2 = lambdaInfo;
            boolean bl = false;
            boolean bl2 = false;
            KotlinResolutionCallbacksImpl.LambdaInfo it = lambdaInfo2;
            boolean bl3 = false;
            it.getLastExpressionInfo().setDataFlowInfoAfter(blockReturnedType.getDataFlowInfo());
        }
        return this.computeReturnTypeBasedOnReturnExpressions(functionLiteral, context, typeOfBodyExpression);
    }

    private final KotlinType computeReturnTypeBasedOnReturnExpressions(KtFunctionLiteral functionLiteral, ExpressionTypingContext context, KotlinType typeOfBodyExpression) {
        boolean bl;
        ArrayList returnedExpressionTypes;
        block9: {
            KtExpression returnedExpression;
            returnedExpressionTypes = Lists.newArrayList();
            boolean hasEmptyReturn = false;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            Collection<KtReturnExpression> returnExpressions = this.collectReturns(functionLiteral, bindingTrace);
            for (KtReturnExpression returnExpression : returnExpressions) {
                returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null) {
                    hasEmptyReturn = true;
                    continue;
                }
                ArrayList arrayList = returnedExpressionTypes;
                Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"returnedExpressionTypes");
                CollectionsKt.addIfNotNull(arrayList, context.trace.getType(returnedExpression));
            }
            if (hasEmptyReturn) {
                for (KtReturnExpression returnExpression : returnExpressions) {
                    KotlinType type2;
                    returnedExpression = returnExpression.getReturnedExpression();
                    if (returnedExpression == null || (type2 = context.trace.getType(returnedExpression)) != null && KotlinBuiltIns.isUnit(type2)) continue;
                    BindingTrace bindingTrace2 = context.trace;
                    PsiElement psiElement = returnedExpression;
                    KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinBuiltIns, (String)"components.builtIns");
                    bindingTrace2.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)psiElement, kotlinBuiltIns.getUnitType()));
                }
                KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinBuiltIns, (String)"components.builtIns");
                return kotlinBuiltIns.getUnitType();
            }
            ArrayList arrayList = returnedExpressionTypes;
            Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"returnedExpressionTypes");
            CollectionsKt.addIfNotNull(arrayList, typeOfBodyExpression);
            if (returnedExpressionTypes.isEmpty()) {
                return null;
            }
            Iterable $this$any$iv = returnedExpressionTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    KotlinType kotlinType2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"it");
                    if (!TypeUtilsKt.contains(kotlinType2, (Function1<? super UnwrappedType, Boolean>)((Function1)computeReturnTypeBasedOnReturnExpressions.1.1.INSTANCE))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtReturnExpression> collectReturns(KtFunctionLiteral functionLiteral, BindingTrace trace) {
        void $this$filterTo$iv$iv;
        KtBlockExpression bodyExpression;
        ArrayList result2 = Lists.newArrayList();
        KtBlockExpression ktBlockExpression = bodyExpression = functionLiteral.getBodyExpression();
        if (ktBlockExpression != null) {
            Void cfr_ignored_0 = (Void)ktBlockExpression.accept((KtVisitor)new KtTreeVisitor<List<KtReturnExpression>>(){

                @Nullable
                public Void visitReturnExpression(@NotNull KtReturnExpression expression2, @NotNull List<KtReturnExpression> insideActualFunction) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    Intrinsics.checkParameterIsNotNull(insideActualFunction, (String)"insideActualFunction");
                    insideActualFunction.add(expression2);
                    return null;
                }
            }, result2);
        }
        ArrayList arrayList = result2;
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"result");
        Iterable $this$filter$iv = arrayList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement psiElement;
            KtReturnExpression it = (KtReturnExpression)element$iv$iv;
            boolean bl = false;
            if (it.getTargetLabel() != null) {
                KtSimpleNameExpression ktSimpleNameExpression;
                boolean bl2 = false;
                boolean bl3 = false;
                KtSimpleNameExpression it2 = ktSimpleNameExpression;
                boolean bl4 = false;
                psiElement = (PsiElement)trace.get(BindingContext.LABEL_TARGET, it2);
            } else {
                psiElement = null;
            }
            if (!Intrinsics.areEqual(psiElement, (Object)functionLiteral)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void checkTypesForReturnStatements(@NotNull KtDeclarationWithBody function2, @NotNull BindingTrace trace, @NotNull KotlinType actualReturnType) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)actualReturnType, (String)"actualReturnType");
        if (function2.hasBlockBody()) {
            return;
        }
        if (!(function2 instanceof KtNamedFunction && ((KtNamedFunction)function2).getTypeReference() == null || function2 instanceof KtPropertyAccessor && ((KtPropertyAccessor)function2).getReturnTypeReference() != null)) {
            return;
        }
        for (KtReturnExpression returnForCheck : this.collectReturns(function2, trace)) {
            KotlinType expressionType;
            KtExpression expression2 = returnForCheck.getReturnedExpression();
            if (expression2 == null) {
                if (TypeUtilsKt.isUnit(actualReturnType)) continue;
                trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnForCheck), actualReturnType));
                continue;
            }
            if (trace.getType(expression2) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionType, (String)"trace.getType(expression) ?: continue");
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, actualReturnType)) continue;
            trace.report(Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)expression2), expressionType, actualReturnType));
        }
    }

    private final List<KtReturnExpression> collectReturns(KtDeclarationWithBody function2, BindingTrace trace) {
        KtExpression ktExpression = function2.getBodyExpression();
        if (ktExpression == null) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"function.bodyExpression ?: return emptyList()");
        KtExpression bodyExpression = ktExpression;
        ArrayList returns = new ArrayList();
        bodyExpression.accept((KtVisitor)new KtTreeVisitor<Boolean>(trace, function2, returns){
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ KtDeclarationWithBody $function;
            final /* synthetic */ ArrayList $returns;

            @Nullable
            public Void visitReturnExpression(@NotNull KtReturnExpression expression2, boolean insideActualFunction) {
                PsiElement labelTarget;
                PsiElement psiElement;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
                if (ktSimpleNameExpression != null) {
                    KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtSimpleNameExpression it = ktSimpleNameExpression2;
                    boolean bl3 = false;
                    psiElement = (PsiElement)this.$trace.get(BindingContext.LABEL_TARGET, it);
                } else {
                    psiElement = labelTarget = null;
                }
                if (Intrinsics.areEqual(labelTarget, (Object)this.$function) || labelTarget == null && insideActualFunction) {
                    this.$returns.add(expression2);
                }
                return (Void)super.visitReturnExpression(expression2, insideActualFunction);
            }

            @Nullable
            public Void visitNamedFunction(@NotNull KtNamedFunction function2, boolean data) {
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                return (Void)super.visitNamedFunction(function2, false);
            }

            @Nullable
            public Void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor, boolean data) {
                Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
                return (Void)super.visitPropertyAccessor(accessor, false);
            }

            @Nullable
            public Void visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2, boolean data) {
                Intrinsics.checkParameterIsNotNull((Object)initializer2, (String)"initializer");
                return (Void)super.visitAnonymousInitializer(initializer2, false);
            }
            {
                this.$trace = $captured_local_variable$0;
                this.$function = $captured_local_variable$1;
                this.$returns = $captured_local_variable$2;
            }
        }, true);
        return returns;
    }

    public FunctionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        super(facade);
    }
}

