/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

final class JvmTypeFactoryImpl
implements JvmTypeFactory<JvmType> {
    public static final JvmTypeFactoryImpl INSTANCE;

    @Override
    @NotNull
    public JvmType boxType(@NotNull JvmType possiblyPrimitiveType) {
        JvmType jvmType;
        Intrinsics.checkParameterIsNotNull((Object)possiblyPrimitiveType, (String)"possiblyPrimitiveType");
        if (possiblyPrimitiveType instanceof JvmType.Primitive && ((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType() != null) {
            JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses(((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType().getWrapperFqName());
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byFqNameWit\u2026mitiveType.wrapperFqName)");
            String string = jvmClassName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JvmClassName.byFqNameWit\u2026apperFqName).internalName");
            jvmType = this.createObjectType(string);
        } else {
            jvmType = possiblyPrimitiveType;
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createFromString(@NotNull String representation) {
        JvmType jvmType;
        Object object;
        Object object2;
        char firstChar;
        block8: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)representation, (String)"representation");
            boolean bl2 = bl = representation.length() > 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "empty string as JvmType";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            firstChar = representation.charAt(0);
            for (Object element$iv : (Object[])JvmPrimitiveType.values()) {
                JvmPrimitiveType it = (JvmPrimitiveType)((Object)element$iv);
                if (!(it.getDesc().charAt(0) == firstChar)) continue;
                object2 = element$iv;
                break block8;
            }
            object2 = null;
        }
        JvmPrimitiveType jvmPrimitiveType = (JvmPrimitiveType)((Object)object2);
        if (jvmPrimitiveType != null) {
            object = jvmPrimitiveType;
            JvmPrimitiveType it = object;
            return new JvmType.Primitive(it);
        }
        switch (firstChar) {
            case 'V': {
                jvmType = new JvmType.Primitive(null);
                break;
            }
            case '[': {
                object = representation;
                int it = 1;
                JvmTypeFactoryImpl jvmTypeFactoryImpl = this;
                String string = ((String)object).substring(it);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                String string2 = string;
                JvmType jvmType2 = jvmTypeFactoryImpl.createFromString(string2);
                jvmType = new JvmType.Array(jvmType2);
                break;
            }
            default: {
                String string;
                boolean bl;
                boolean bl3 = bl = firstChar == 'L' && StringsKt.endsWith$default((CharSequence)representation, (char)';', (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Type that is not primitive nor array should be Object, but '" + representation + "' was found";
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                String string4 = representation;
                int n = 1;
                int n2 = representation.length() - 1;
                String string5 = string4.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string6 = string = string5;
                jvmType = new JvmType.Object(string6);
            }
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType.Object createObjectType(@NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
        return new JvmType.Object(internalName);
    }

    @Override
    @NotNull
    public String toString(@NotNull JvmType type2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        JvmType jvmType = type2;
        if (jvmType instanceof JvmType.Array) {
            object = "[" + this.toString(((JvmType.Array)type2).getElementType());
        } else if (jvmType instanceof JvmType.Primitive) {
            object = ((JvmType.Primitive)type2).getJvmPrimitiveType();
            if (object == null || (object = object.getDesc()) == null) {
                object = "V";
            }
        } else if (jvmType instanceof JvmType.Object) {
            object = "L" + ((JvmType.Object)type2).getInternalName() + ";";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Override
    @NotNull
    public JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }

    private JvmTypeFactoryImpl() {
    }

    static {
        JvmTypeFactoryImpl jvmTypeFactoryImpl;
        INSTANCE = jvmTypeFactoryImpl = new JvmTypeFactoryImpl();
    }
}

