/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import io.github.classgraph.ClassGraphException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandlerRegistry;
import nonapi.io.github.classgraph.classpath.ClassLoaderAndModuleFinder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.classpath.SystemJarFinder;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;

public class ClasspathFinder {
    private final ClasspathOrder classpathOrder;
    private final ClassLoaderAndModuleFinder classLoaderAndModuleFinder;

    private boolean addClassLoaderHandler(ScanSpec scanSpec, ClassLoader classLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry, Set<ClassLoader> foundClassLoaders, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerRegistryEntries, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrderOut, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> ignoredClassLoaderAndHandlerOrderOut, Set<ClassLoader> visited, LogNode log) {
        ClassLoaderHandler classLoaderHandler = classLoaderHandlerRegistryEntry.instantiate(log);
        if (classLoaderHandler != null) {
            ClassLoader embeddedClassLoader;
            if (log != null) {
                log.log("ClassLoader " + classLoader.getClass().getName() + " will be handled by " + classLoaderHandler);
            }
            if ((embeddedClassLoader = classLoaderHandler.getEmbeddedClassLoader(classLoader)) != null) {
                if (visited.add(embeddedClassLoader)) {
                    if (log != null) {
                        log.log("Delegating from " + classLoader.getClass().getName() + " to embedded ClassLoader " + embeddedClassLoader.getClass().getName());
                    }
                    return this.addClassLoaderHandler(scanSpec, embeddedClassLoader, classLoaderHandlerRegistryEntry, foundClassLoaders, allClassLoaderHandlerRegistryEntries, classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, visited, log);
                }
                if (log != null) {
                    log.log("Hit infinite loop when delegating from " + classLoader.getClass().getName() + " to embedded ClassLoader " + embeddedClassLoader.getClass().getName());
                }
                return false;
            }
            ClassLoaderHandler.DelegationOrder delegationOrder = classLoaderHandler.getDelegationOrder(classLoader);
            ClassLoader parent = classLoader.getParent();
            if (log != null && parent != null) {
                log.log(classLoader.getClass().getName() + " delegates to parent " + parent.getClass().getName() + " with order " + (Object)((Object)delegationOrder));
            }
            switch (delegationOrder) {
                case PARENT_FIRST: {
                    if (parent != null) {
                        this.findClassLoaderHandlerForClassLoaderAndParents(scanSpec, parent, foundClassLoaders, allClassLoaderHandlerRegistryEntries, scanSpec.ignoreParentClassLoaders ? ignoredClassLoaderAndHandlerOrderOut : classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, log);
                    }
                    classLoaderAndHandlerOrderOut.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>(classLoader, classLoaderHandler));
                    return true;
                }
                case PARENT_LAST: {
                    classLoaderAndHandlerOrderOut.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>(classLoader, classLoaderHandler));
                    if (parent != null) {
                        this.findClassLoaderHandlerForClassLoaderAndParents(scanSpec, parent, foundClassLoaders, allClassLoaderHandlerRegistryEntries, scanSpec.ignoreParentClassLoaders ? ignoredClassLoaderAndHandlerOrderOut : classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, log);
                    }
                    return true;
                }
            }
            throw new ClassGraphException("Unknown delegation order");
        }
        return false;
    }

    private void findClassLoaderHandlerForClassLoaderAndParents(ScanSpec scanSpec, ClassLoader classLoader, Set<ClassLoader> foundClassLoaders, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerRegistryEntries, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrderOut, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> ignoredClassLoaderAndHandlerOrderOut, LogNode log) {
        if (foundClassLoaders.add(classLoader)) {
            boolean foundMatch = false;
            for (Class<?> c = classLoader.getClass(); c != null; c = c.getSuperclass()) {
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : allClassLoaderHandlerRegistryEntries) {
                    for (String handledClassLoaderName : classLoaderHandlerRegistryEntry.handledClassLoaderNames) {
                        if (!handledClassLoaderName.equals(c.getName())) continue;
                        if (!this.addClassLoaderHandler(scanSpec, classLoader, classLoaderHandlerRegistryEntry, foundClassLoaders, allClassLoaderHandlerRegistryEntries, classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, new HashSet<ClassLoader>(), log)) break;
                        foundMatch = true;
                        break;
                    }
                    if (!foundMatch) continue;
                    break;
                }
                if (foundMatch) break;
            }
            if (!foundMatch) {
                if (log != null) {
                    log.log("Could not find a ClassLoaderHandler that can handle " + classLoader.getClass().getName() + " , trying " + ClassLoaderHandlerRegistry.FALLBACK_CLASS_LOADER_HANDLER.classLoaderHandlerClass.getName() + " instead. Please report this at: https://github.com/classgraph/classgraph/issues");
                }
                this.addClassLoaderHandler(scanSpec, classLoader, ClassLoaderHandlerRegistry.FALLBACK_CLASS_LOADER_HANDLER, foundClassLoaders, allClassLoaderHandlerRegistryEntries, classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, new HashSet<ClassLoader>(), log);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public ClasspathFinder(ScanSpec scanSpec, LogNode log) {
        ClassLoader defaultClassLoader;
        LogNode classpathFinderLog = log == null ? null : log.log("Finding classpath and modules");
        String jreRtJar = SystemJarFinder.getJreRtJarPath();
        boolean scanAllLibOrExtJars = !scanSpec.libOrExtJarWhiteBlackList.whitelistAndBlacklistAreEmpty();
        Set<String> libOrExtJars = SystemJarFinder.getJreLibOrExtJars();
        if (!(classpathFinderLog == null || jreRtJar == null && libOrExtJars.isEmpty())) {
            LogNode systemJarsLog = classpathFinderLog.log("System jars:");
            if (jreRtJar != null) {
                systemJarsLog.log((scanSpec.enableSystemJarsAndModules ? "" : "Scanning disabled for rt.jar: ") + jreRtJar);
            }
            for (String libOrExtJarPath : libOrExtJars) {
                systemJarsLog.log((scanAllLibOrExtJars || scanSpec.libOrExtJarWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(libOrExtJarPath) ? "" : "Scanning disabled for lib or ext jar: ") + libOrExtJarPath);
            }
        }
        this.classLoaderAndModuleFinder = new ClassLoaderAndModuleFinder(scanSpec, classpathFinderLog);
        this.classpathOrder = new ClasspathOrder(scanSpec);
        ClasspathOrder ignoredClasspathOrder = new ClasspathOrder(scanSpec);
        ClassLoader[] contextClassLoaders = this.classLoaderAndModuleFinder.getContextClassLoaders();
        ClassLoader classLoader = defaultClassLoader = contextClassLoaders != null && contextClassLoaders.length > 0 ? contextClassLoaders[0] : null;
        if (scanSpec.overrideClasspath != null) {
            if (scanSpec.overrideClassLoaders != null && classpathFinderLog != null) {
                classpathFinderLog.log("It is not possible to override both the classpath and the ClassLoaders -- ignoring the ClassLoader override");
            }
            LogNode overrideLog = classpathFinderLog == null ? null : classpathFinderLog.log("Overriding classpath with: " + scanSpec.overrideClasspath);
            this.classpathOrder.addClasspathEntries(scanSpec.overrideClasspath, defaultClassLoader, overrideLog);
            if (overrideLog != null) {
                overrideLog.log("WARNING: when the classpath is overridden, there is no guarantee that the classes found by classpath scanning will be the same as the classes loaded by the context classloader");
            }
        } else {
            String[] pathElements;
            LogNode classLoaderClasspathLog;
            ClassLoaderHandler classLoaderHandler;
            if (jreRtJar != null && scanSpec.enableSystemJarsAndModules) {
                this.classpathOrder.addSystemClasspathEntry(jreRtJar, defaultClassLoader);
            }
            for (String string : SystemJarFinder.getJreLibOrExtJars()) {
                if (!scanAllLibOrExtJars && !scanSpec.libOrExtJarWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(string)) continue;
                this.classpathOrder.addSystemClasspathEntry(string, defaultClassLoader);
            }
            if (classpathFinderLog != null) {
                LogNode classLoaderHandlerLog = classpathFinderLog.log("ClassLoaderHandlers:");
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : ClassLoaderHandlerRegistry.CLASS_LOADER_HANDLERS) {
                    classLoaderHandlerLog.log(classLoaderHandlerRegistryEntry.classLoaderHandlerClass.getName());
                }
            }
            ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrder = new ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>>();
            ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> arrayList = new ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>>();
            if (contextClassLoaders != null) {
                void var14_23;
                ClassLoader[] classLoaderArray = contextClassLoaders;
                int n = classLoaderArray.length;
                boolean bl = false;
                while (var14_23 < n) {
                    ClassLoader envClassLoader = classLoaderArray[var14_23];
                    this.findClassLoaderHandlerForClassLoaderAndParents(scanSpec, envClassLoader, new LinkedHashSet<ClassLoader>(), ClassLoaderHandlerRegistry.CLASS_LOADER_HANDLERS, classLoaderAndHandlerOrder, arrayList, classpathFinderLog);
                    ++var14_23;
                }
            }
            LogNode logNode = classpathFinderLog == null ? null : classpathFinderLog.log("Finding classpath elements in ClassLoaders");
            for (AbstractMap.SimpleEntry simpleEntry : classLoaderAndHandlerOrder) {
                ClassLoader classLoader2 = (ClassLoader)simpleEntry.getKey();
                classLoaderHandler = (ClassLoaderHandler)simpleEntry.getValue();
                classLoaderClasspathLog = logNode == null ? null : logNode.log("Finding classpath elements in ClassLoader " + classLoader2.getClass().getName());
                try {
                    classLoaderHandler.handle(scanSpec, classLoader2, this.classpathOrder, classLoaderClasspathLog);
                }
                catch (LinkageError | RuntimeException e) {
                    if (classLoaderClasspathLog == null) continue;
                    classLoaderClasspathLog.log("Exception in ClassLoaderHandler", e);
                }
            }
            for (AbstractMap.SimpleEntry simpleEntry : arrayList) {
                ClassLoader classLoader2 = (ClassLoader)simpleEntry.getKey();
                classLoaderHandler = (ClassLoaderHandler)simpleEntry.getValue();
                classLoaderClasspathLog = classpathFinderLog == null ? null : classpathFinderLog.log("Will not scan the following classpath elements from ignored ClassLoader " + classLoader2.getClass().getName());
                try {
                    classLoaderHandler.handle(scanSpec, classLoader2, ignoredClasspathOrder, classLoaderClasspathLog);
                }
                catch (LinkageError | RuntimeException e) {
                    if (classLoaderClasspathLog == null) continue;
                    classLoaderClasspathLog.log("Exception in ClassLoaderHandler", e);
                }
            }
            if (scanSpec.overrideClassLoaders == null && scanSpec.overrideClasspath == null && (pathElements = JarUtils.smartPathSplit(System.getProperty("java.class.path"))).length > 0) {
                LogNode logNode2 = classpathFinderLog == null ? null : classpathFinderLog.log("Getting classpath entries from java.class.path");
                for (String pathElement : pathElements) {
                    String pathElementResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, pathElement);
                    if (!ignoredClasspathOrder.getClasspathEntryUniqueResolvedPaths().contains(pathElementResolved)) {
                        this.classpathOrder.addClasspathEntry(pathElement, defaultClassLoader, logNode2);
                        continue;
                    }
                    if (logNode2 == null) continue;
                    logNode2.log("Found classpath element in java.class.path that will be ignored, since it is also found in an ignored parent classloader: " + pathElement);
                }
            }
        }
    }

    public ClasspathOrder getClasspathOrder() {
        return this.classpathOrder;
    }

    public ClassLoaderAndModuleFinder getClassLoaderAndModuleFinder() {
        return this.classLoaderAndModuleFinder;
    }
}

