/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.net.URL;
import java.net.URLClassLoader;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.utils.LogNode;

public class URLClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public String[] handledClassLoaders() {
        return new String[]{"java.net.URLClassLoader"};
    }

    @Override
    public ClassLoader getEmbeddedClassLoader(ClassLoader outerClassLoaderInstance) {
        return null;
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        URL[] urls = ((URLClassLoader)classLoader).getURLs();
        if (urls != null) {
            for (URL url : urls) {
                if (url == null) continue;
                classpathOrderOut.addClasspathEntry(url.toString(), classLoader, log);
            }
        }
    }
}

