/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNProperties13;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNXMLAdminArea
extends SVNAdminArea {
    public static final int WC_FORMAT = 4;
    private static final String THIS_DIR = "";
    private static final Set BOOLEAN_PROPERTIES = new HashSet();
    private File myLockFile = new File(this.getAdminDirectory(), "lock");
    private File myEntriesFile = new File(this.getAdminDirectory(), "entries");

    public SVNXMLAdminArea(File dir) {
        super(dir);
    }

    private void saveProperties(SVNLog log) throws SVNException {
        Map propsCache = this.getPropertiesStorage(false);
        if (propsCache == null || propsCache.isEmpty()) {
            return;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        for (String name : propsCache.keySet()) {
            SVNVersionedProperties props = (SVNVersionedProperties)propsCache.get(name);
            if (!props.isModified()) continue;
            String dstPath = this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work";
            dstPath = this.getAdminDirectory().getName() + "/" + dstPath;
            if (props.isEmpty()) {
                command.put("name", dstPath);
                log.addCommand("rm", command, false);
            } else {
                String tmpPath = "tmp/";
                tmpPath = tmpPath + (this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work");
                File tmpFile = this.getAdminFile(tmpPath);
                String srcPath = this.getAdminDirectory().getName() + "/" + tmpPath;
                SVNProperties tmpProps = new SVNProperties(tmpFile, srcPath);
                tmpProps.setProperties(props.asMap());
                command.put("name", srcPath);
                command.put("dest", dstPath);
                log.addCommand("mv", command, false);
                command.clear();
                command.put("name", dstPath);
                log.addCommand("readonly", command, false);
            }
            props.setModified(false);
            command.clear();
        }
    }

    private void saveBaseProperties(SVNLog log) throws SVNException {
        Map basePropsCache = this.getBasePropertiesStorage(false);
        if (basePropsCache == null || basePropsCache.isEmpty()) {
            return;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        for (String name : basePropsCache.keySet()) {
            SVNVersionedProperties props = (SVNVersionedProperties)basePropsCache.get(name);
            if (!props.isModified()) continue;
            String dstPath = this.getThisDirName().equals(name) ? "dir-prop-base" : "prop-base/" + name + ".svn-base";
            dstPath = this.getAdminDirectory().getName() + "/" + dstPath;
            if (props.isEmpty()) {
                command.put("name", dstPath);
                log.addCommand("rm", command, false);
            } else {
                String tmpPath = "tmp/";
                tmpPath = tmpPath + (this.getThisDirName().equals(name) ? "dir-prop-base" : "prop-base/" + name + ".svn-base");
                File tmpFile = this.getAdminFile(tmpPath);
                String srcPath = this.getAdminDirectory().getName() + "/" + tmpPath;
                SVNProperties tmpProps = new SVNProperties(tmpFile, srcPath);
                tmpProps.setProperties(props.asMap());
                command.put("name", srcPath);
                command.put("dest", dstPath);
                log.addCommand("mv", command, false);
                command.clear();
                command.put("name", dstPath);
                log.addCommand("readonly", command, false);
            }
            props.setModified(false);
            command.clear();
        }
    }

    public void saveWCProperties(boolean close) throws SVNException {
        Map wcPropsCache = this.getWCPropertiesStorage(false);
        if (wcPropsCache == null) {
            return;
        }
        for (String name : wcPropsCache.keySet()) {
            SVNVersionedProperties props = (SVNVersionedProperties)wcPropsCache.get(name);
            if (!props.isModified()) continue;
            String dstPath = this.getThisDirName().equals(name) ? "dir-wcprops" : "wcprops/" + name + ".svn-work";
            File dstFile = this.getAdminFile(dstPath);
            if (props.isEmpty()) {
                SVNFileUtil.deleteFile(dstFile);
            } else {
                String tmpPath = "tmp/";
                tmpPath = tmpPath + (this.getThisDirName().equals(name) ? "dir-wcprops" : "wcprops/" + name + ".svn-work");
                File tmpFile = this.getAdminFile(tmpPath);
                SVNProperties.setProperties(props.asMap(), dstFile, tmpFile, "END");
            }
            props.setModified(false);
        }
        if (close) {
            this.closeWCProperties();
        }
    }

    public SVNVersionedProperties getBaseProperties(String name) throws SVNException {
        Map basePropsCache = this.getBasePropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)basePropsCache.get(name);
        if (props != null) {
            return props;
        }
        Map baseProps = null;
        try {
            baseProps = this.readBaseProperties(name);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err);
        }
        props = new SVNProperties13(baseProps);
        basePropsCache.put(name, props);
        return props;
    }

    public SVNVersionedProperties getRevertProperties(String name) throws SVNException {
        Map revertPropsCache = this.getRevertPropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)revertPropsCache.get(name);
        if (props != null) {
            return props;
        }
        Map revertProps = null;
        try {
            revertProps = this.readRevertProperties(name);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err);
        }
        props = new SVNProperties13(revertProps);
        revertPropsCache.put(name, props);
        return props;
    }

    public SVNVersionedProperties getProperties(String name) throws SVNException {
        Map propsCache = this.getPropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)propsCache.get(name);
        if (props != null) {
            return props;
        }
        Map properties = null;
        try {
            properties = this.readProperties(name);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err);
        }
        props = new SVNProperties13(properties);
        propsCache.put(name, props);
        return props;
    }

    public SVNVersionedProperties getWCProperties(String name) throws SVNException {
        Map wcPropsCache = this.getWCPropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)wcPropsCache.get(name);
        if (props != null) {
            return props;
        }
        Map properties = null;
        try {
            properties = this.readWCProperties(name);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err);
        }
        props = new SVNProperties13(properties);
        wcPropsCache.put(name, props);
        return props;
    }

    private Map readProperties(String name) throws SVNException {
        File propertiesFile = this.getPropertiesFile(name, false);
        SVNProperties props = new SVNProperties(propertiesFile, null);
        return props.asMap();
    }

    private Map readBaseProperties(String name) throws SVNException {
        File propertiesFile = this.getBasePropertiesFile(name, false);
        SVNProperties props = new SVNProperties(propertiesFile, null);
        return props.asMap();
    }

    private Map readRevertProperties(String name) throws SVNException {
        File propertiesFile = this.getRevertPropertiesFile(name, false);
        SVNProperties props = new SVNProperties(propertiesFile, null);
        return props.asMap();
    }

    private Map readWCProperties(String name) throws SVNException {
        String path = this.getThisDirName().equals(name) ? "dir-wcprops" : "wcprops/" + name + ".svn-work";
        File propertiesFile = this.getAdminFile(path);
        SVNProperties props = new SVNProperties(propertiesFile, this.getAdminDirectory().getName() + "/" + path);
        return props.asMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEntries(boolean close) throws SVNException {
        block7: {
            if (this.myEntries == null) break block7;
            SVNEntry rootEntry = (SVNEntry)this.myEntries.get(this.getThisDirName());
            if (rootEntry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No default entry in directory ''{0}''", this.getRoot());
                SVNErrorManager.error(err);
            }
            String reposURL = rootEntry.getRepositoryRoot();
            String url = rootEntry.getURL();
            if (reposURL != null && !SVNPathUtil.isAncestor(reposURL, url)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Entry ''{0}'' has inconsistent repository root and url", this.getThisDirName());
                SVNErrorManager.error(err);
            }
            File tmpFile = new File(this.getAdminDirectory(), "tmp/entries");
            OutputStreamWriter os = null;
            try {
                os = new OutputStreamWriter(SVNFileUtil.openFileForWriting(tmpFile), "UTF-8");
                this.writeEntries(os);
            }
            catch (IOException e) {
                try {
                    SVNFileUtil.closeFile(os);
                    SVNFileUtil.deleteFile(tmpFile);
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write entries file ''{0}'': {1}", new Object[]{this.myEntriesFile, e.getLocalizedMessage()});
                    SVNErrorManager.error(err, e);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(os);
                    throw throwable;
                }
                SVNFileUtil.closeFile(os);
            }
            SVNFileUtil.closeFile(os);
            SVNFileUtil.rename(tmpFile, this.myEntriesFile);
            SVNFileUtil.setReadonly(this.myEntriesFile, true);
            if (close) {
                this.myEntries = null;
            }
        }
    }

    public void saveVersionedProperties(SVNLog log, boolean close) throws SVNException {
        this.saveProperties(log);
        this.saveBaseProperties(log);
        if (close) {
            this.myBaseProperties = null;
            this.myProperties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map fetchEntries() throws SVNException {
        if (!this.myEntriesFile.exists()) {
            return null;
        }
        entries = new HashMap<String, SVNEntry>();
        reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(this.myEntriesFile), "UTF-8"));
            entry = null;
lbl8:
            // 5 sources

            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("<entry")) {
                    entry = new HashMap<String, String>();
                    continue;
                }
                if (entry == null || line.indexOf(61) <= 0 || line.indexOf(34) <= 0 || line.indexOf(34) == line.lastIndexOf(34)) continue;
                name = line.substring(0, line.indexOf(61));
                value = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
                value = SVNEncodingUtil.xmlDecode(value);
                entry.put("svn:entry:" + name, value);
                if (line.charAt(line.length() - 1) != '>') continue;
                entryName = (String)entry.get("svn:entry:name");
                if (entryName != null) ** GOTO lbl-1000
                var8_9 = entries;
                ** GOTO lbl32
            }
            ** GOTO lbl55
        }
        catch (IOException e) {
            try {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", new Object[]{this.myEntriesFile, e.getLocalizedMessage()});
                SVNErrorManager.error(err, e);
            }
            catch (Throwable var11_12) {
                SVNFileUtil.closeFile(reader);
                throw var11_12;
            }
lbl32:
            // 1 sources

            SVNFileUtil.closeFile(reader);
            return var8_9;
lbl-1000:
            // 1 sources

            {
                entries.put(entryName, new SVNEntry(entry, this, entryName));
                if (!this.getThisDirName().equals(entryName) && (rootEntry = (SVNEntry)entries.get(this.getThisDirName())) != null) {
                    rootEntryAttrs = rootEntry.asMap();
                    if (entry.get("svn:entry:revision") == null) {
                        entry.put("svn:entry:revision", (String)rootEntryAttrs.get("svn:entry:revision"));
                    }
                    if (entry.get("svn:entry:url") == null) {
                        url = (String)rootEntryAttrs.get("svn:entry:url");
                        if (url != null) {
                            url = SVNPathUtil.append(url, SVNEncodingUtil.uriEncode(entryName));
                        }
                        entry.put("svn:entry:url", url);
                    }
                    if (entry.get("svn:entry:uuid") == null) {
                        entry.put("svn:entry:uuid", (String)rootEntryAttrs.get("svn:entry:uuid"));
                    }
                    if (entry.get("svn:entry:repos") == null && rootEntryAttrs.get("svn:entry:repos") != null) {
                        entry.put("svn:entry:repos", (String)rootEntryAttrs.get("svn:entry:repos"));
                    }
                }
                entry = null;
                ** GOTO lbl8
            }
lbl55:
            // 1 sources

            SVNFileUtil.closeFile(reader);
            return entries;
            SVNFileUtil.closeFile(reader);
            return entries;
        }
    }

    public String getThisDirName() {
        return THIS_DIR;
    }

    protected void writeEntries(Writer writer) throws IOException {
        SVNEntry rootEntry = (SVNEntry)this.myEntries.get(this.getThisDirName());
        Map rootEntryAttrs = rootEntry.asMap();
        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        writer.write("<wc-entries\n");
        writer.write("   xmlns=\"svn:\">\n");
        ArrayList entryNames = new ArrayList(this.myEntries.keySet());
        Collections.sort(entryNames);
        for (String name : entryNames) {
            SVNEntry entry = (SVNEntry)this.myEntries.get(name);
            Map entryAttrs = entry.asMap();
            writer.write("<entry");
            for (String propName : entryAttrs.keySet()) {
                Object expectedValue;
                Object value = entryAttrs.get(propName);
                if (!(value instanceof String)) continue;
                String propValue = (String)value;
                if (BOOLEAN_PROPERTIES.contains(propName) && !Boolean.TRUE.toString().equals(propValue) || !this.getThisDirName().equals(name) && (!"dir".equals(entryAttrs.get("svn:entry:kind")) ? propValue.equals(expectedValue = "svn:entry:url".equals(propName) ? SVNPathUtil.append((String)rootEntryAttrs.get(propName), SVNEncodingUtil.uriEncode(name)) : ("svn:entry:uuid".equals(propName) || "svn:entry:revision".equals(propName) ? rootEntryAttrs.get(propName) : ("svn:entry:repos".equals(propName) ? rootEntryAttrs.get(propName) : null))) : "svn:entry:uuid".equals(propName) || "svn:entry:revision".equals(propName) || "svn:entry:url".equals(propName) || "svn:entry:repos".equals(propName))) continue;
                if (propName == null || !propName.startsWith("svn:entry:")) {
                    SVNDebugLog.getDefaultLog().info("attempt to write invalid entry property: " + propName + "=" + propValue);
                    SVNDebugLog.getDefaultLog().info(new Exception());
                    continue;
                }
                propName = propName.substring("svn:entry:".length());
                propValue = SVNEncodingUtil.xmlEncodeAttr(propValue);
                writer.write("\n   ");
                writer.write(propName);
                writer.write("=\"");
                writer.write(propValue);
                writer.write("\"");
            }
            writer.write("/>\n");
            writer.flush();
        }
        writer.write("</wc-entries>\n");
        writer.flush();
    }

    public boolean hasPropModifications(String name) throws SVNException {
        SVNVersionedProperties m2;
        String realTimestamp;
        boolean propEmtpy;
        File baseFile;
        File propFile;
        if (this.getThisDirName().equals(name)) {
            propFile = this.getAdminFile("dir-props");
            baseFile = this.getAdminFile("dir-prop-base");
        } else {
            propFile = this.getAdminFile("props/" + name + ".svn-work");
            baseFile = this.getAdminFile("prop-base/" + name + ".svn-base");
        }
        SVNEntry entry = this.getEntry(name, true);
        long propLength = propFile.length();
        boolean bl = propEmtpy = propLength <= 4L;
        if (entry.isScheduledForReplacement()) {
            return !propEmtpy;
        }
        if (propEmtpy) {
            boolean baseEmtpy;
            boolean bl2 = baseEmtpy = baseFile.length() <= 4L;
            if (baseEmtpy) {
                return !propEmtpy;
            }
            return true;
        }
        if (propLength != baseFile.length()) {
            return true;
        }
        String fullRealTimestamp = realTimestamp = SVNTimeUtil.formatDate(new Date(propFile.lastModified()));
        realTimestamp = realTimestamp.substring(0, 23);
        String timeStamp = entry.getPropTime();
        if (timeStamp != null && realTimestamp.equals(timeStamp = timeStamp.substring(0, 23))) {
            return false;
        }
        SVNVersionedProperties m1 = this.getProperties(name);
        if (m1.equals(m2 = this.getBaseProperties(name))) {
            if (this.isLocked()) {
                entry.setPropTime(fullRealTimestamp);
                this.saveEntries(false);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTextModifications(String name, boolean forceComparison) throws SVNException {
        long tstamp;
        String textTime;
        long textTimeAsLong;
        SVNFileType fType = SVNFileType.getType(this.getFile(name));
        if (fType == SVNFileType.DIRECTORY || fType == SVNFileType.NONE) {
            return false;
        }
        SVNEntry entry = this.getEntry(name, true);
        if (entry.isDirectory()) {
            return false;
        }
        if (!forceComparison && (textTimeAsLong = SVNFileUtil.roundTimeStamp(SVNTimeUtil.parseDateAsLong(textTime = entry.getTextTime()))) == (tstamp = SVNFileUtil.roundTimeStamp(this.getFile(name).lastModified()))) {
            return false;
        }
        File baseFile = this.getBaseFile(name, false);
        if (!baseFile.isFile()) {
            return true;
        }
        File baseTmpFile = SVNFileUtil.createUniqueFile(this.getRoot(), SVNFileUtil.getBasePath(this.getBaseFile(name, true)), ".tmp");
        if (!baseTmpFile.getParentFile().exists()) {
            baseTmpFile.getParentFile().mkdirs();
        }
        File versionedFile = this.getFile(name);
        SVNTranslator.translate((SVNAdminArea)this, name, name, SVNFileUtil.getBasePath(baseTmpFile), false);
        boolean equals = true;
        try {
            String checksum;
            MessageDigest digest = forceComparison ? MessageDigest.getInstance("MD5") : null;
            equals = SVNFileUtil.compareFiles(baseFile, baseTmpFile, digest);
            if (forceComparison && !(checksum = SVNFileUtil.toHexDigest(digest)).equals(entry.getChecksum())) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch indicates corrupt text base: ''{0}''\n   expected: {1}\n     actual: {2}\n", new Object[]{baseFile, entry.getChecksum(), checksum});
                SVNErrorManager.error(err);
            }
        }
        catch (NoSuchAlgorithmException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {1}", e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            baseTmpFile.delete();
        }
        if (equals && this.isLocked()) {
            entry.setTextTime(SVNTimeUtil.formatDate(new Date(versionedFile.lastModified())));
            this.saveEntries(false);
        }
        return !equals;
    }

    public boolean hasProperties(String entryName) throws SVNException {
        File baseFile;
        File propFile;
        if (this.getThisDirName().equals(entryName)) {
            propFile = this.getAdminFile("dir-props");
            baseFile = this.getAdminFile("dir-prop-base");
        } else {
            propFile = this.getAdminFile("props/" + entryName + ".svn-work");
            baseFile = this.getAdminFile("prop-base/" + entryName + ".svn-base");
        }
        SVNProperties baseProps = new SVNProperties(baseFile, null);
        if (baseProps.isEmpty()) {
            SVNProperties props = new SVNProperties(propFile, null);
            return !props.isEmpty();
        }
        return true;
    }

    public boolean lock(boolean stealLock) throws SVNException {
        if (!this.isVersioned()) {
            return false;
        }
        if (this.myLockFile.isFile()) {
            if (stealLock) {
                this.setLocked(true);
                return true;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked; try performing ''cleanup''", this.getRoot());
            SVNErrorManager.error(err);
        }
        boolean created = false;
        try {
            created = this.myLockFile.createNewFile();
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}'': {1}", new Object[]{this.getRoot(), e.getLocalizedMessage()});
            SVNErrorManager.error(err, e);
        }
        if (!created) {
            if (this.myLockFile.isFile()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' is locked; try performing 'cleanup'", this.getRoot());
                SVNErrorManager.error(err);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}''", this.getRoot());
                SVNErrorManager.error(err);
            }
        }
        this.setLocked(true);
        return created;
    }

    boolean innerLock() throws SVNException {
        if (this.myLockFile.isFile()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked; try performing ''cleanup''", this.getRoot());
            SVNErrorManager.error(err);
        }
        boolean created = false;
        try {
            created = this.myLockFile.createNewFile();
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}'': {1}", new Object[]{this.getRoot(), e.getLocalizedMessage()});
            SVNErrorManager.error(err, e);
        }
        if (!created) {
            if (this.myLockFile.isFile()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' is locked; try performing 'cleanup'", this.getRoot());
                SVNErrorManager.error(err);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}''", this.getRoot());
                SVNErrorManager.error(err);
            }
        }
        return created;
    }

    public boolean unlock() throws SVNException {
        if (!this.myLockFile.exists()) {
            return true;
        }
        boolean killMe = this.getAdminFile("KILLME").exists();
        if (killMe) {
            return false;
        }
        File[] logs = SVNFileListUtil.listFiles(this.getAdminDirectory());
        for (int i = 0; logs != null && i < logs.length; ++i) {
            File log = logs[i];
            if (!"log".equals(log.getName()) && !log.getName().startsWith("log.")) continue;
            return false;
        }
        boolean deleted = this.myLockFile.delete();
        if (!deleted) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Failed to unlock working copy ''{0}''", this.getRoot());
            SVNErrorManager.error(err);
        }
        return deleted;
    }

    public SVNAdminArea upgradeFormat(SVNAdminArea adminArea) throws SVNException {
        return this;
    }

    public boolean isVersioned() {
        if (this.getAdminDirectory().isDirectory() && this.myEntriesFile.canRead()) {
            try {
                if (this.getEntry(this.getThisDirName(), false) != null) {
                    return true;
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return false;
    }

    public SVNAdminArea createVersionedDirectory(File dir, String url, String rootURL, String uuid, long revNumber, boolean createMyself) throws SVNException {
        dir = createMyself ? this.getRoot() : dir;
        dir.mkdirs();
        File adminDir = createMyself ? this.getAdminDirectory() : new File(dir, SVNFileUtil.getAdminDirectoryName());
        adminDir.mkdir();
        SVNFileUtil.setHidden(adminDir, true);
        File lockFile = createMyself ? this.myLockFile : new File(adminDir, "lock");
        SVNFileUtil.createEmptyFile(lockFile);
        SVNAdminUtil.createReadmeFile(adminDir);
        SVNFileUtil.createEmptyFile(createMyself ? this.getAdminFile("empty-file") : new File(adminDir, "empty-file"));
        File[] tmp = new File[]{createMyself ? this.getAdminFile("tmp") : new File(adminDir, "tmp"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "props") : new File(adminDir, "tmp" + File.separatorChar + "props"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "prop-base") : new File(adminDir, "tmp" + File.separatorChar + "prop-base"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "text-base") : new File(adminDir, "tmp" + File.separatorChar + "text-base"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "wcprops") : new File(adminDir, "tmp" + File.separatorChar + "wcprops"), createMyself ? this.getAdminFile("props") : new File(adminDir, "props"), createMyself ? this.getAdminFile("prop-base") : new File(adminDir, "prop-base"), createMyself ? this.getAdminFile("text-base") : new File(adminDir, "text-base"), createMyself ? this.getAdminFile("wcprops") : new File(adminDir, "wcprops")};
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i].mkdir();
        }
        SVNAdminUtil.createFormatFile(adminDir);
        SVNXMLAdminArea adminArea = createMyself ? this : new SVNXMLAdminArea(dir);
        adminArea.setLocked(true);
        SVNEntry rootEntry = adminArea.getEntry(((SVNAdminArea)adminArea).getThisDirName(), true);
        if (rootEntry == null) {
            rootEntry = adminArea.addEntry(((SVNAdminArea)adminArea).getThisDirName());
        }
        if (url != null) {
            rootEntry.setURL(url);
        }
        rootEntry.setRepositoryRoot(rootURL);
        rootEntry.setRevision(revNumber);
        rootEntry.setKind(SVNNodeKind.DIR);
        if (uuid != null) {
            rootEntry.setUUID(uuid);
        }
        if (revNumber > 0L) {
            rootEntry.setIncomplete(true);
        }
        ((SVNAdminArea)adminArea).saveEntries(false);
        SVNFileUtil.deleteFile(lockFile);
        return adminArea;
    }

    public boolean isLocked() {
        if (!this.myWasLocked) {
            return false;
        }
        return this.myLockFile.isFile();
    }

    protected int getFormatVersion() {
        return 4;
    }

    public void postUpgradeFormat(int format) throws SVNException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit(String fileName, long revisionNumber, boolean implicit, SVNErrorCode errorCode) throws SVNException {
        File tmpFile;
        SVNFileType fileType;
        SVNEntry entry = this.getEntry(fileName, true);
        if (entry == null || !this.getThisDirName().equals(fileName) && entry.getKind() != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(errorCode, "Log command for directory ''{0}'' is mislocated", this.getRoot());
            SVNErrorManager.error(err);
        }
        if (!implicit && entry.isScheduledForDeletion()) {
            if (this.getThisDirName().equals(fileName)) {
                entry.setRevision(revisionNumber);
                entry.setKind(SVNNodeKind.DIR);
                File killMe = this.getAdminFile("KILLME");
                if (killMe.getParentFile().isDirectory()) {
                    try {
                        killMe.createNewFile();
                    }
                    catch (IOException e) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create file ''{0}'': {1}", new Object[]{killMe, e.getLocalizedMessage()});
                        SVNErrorManager.error(err, e);
                    }
                }
            } else {
                this.removeFromRevisionControl(fileName, false, false);
                SVNEntry parentEntry = this.getEntry(this.getThisDirName(), true);
                if (revisionNumber > parentEntry.getRevision()) {
                    SVNEntry fileEntry = this.addEntry(fileName);
                    fileEntry.setKind(SVNNodeKind.FILE);
                    fileEntry.setDeleted(true);
                    fileEntry.setRevision(revisionNumber);
                }
            }
            return;
        }
        if (!implicit && entry.isScheduledForReplacement() && this.getThisDirName().equals(fileName)) {
            Iterator ents = this.entries(true);
            while (ents.hasNext()) {
                SVNEntry currentEntry = (SVNEntry)ents.next();
                if (!currentEntry.isScheduledForDeletion() || currentEntry.getKind() != SVNNodeKind.FILE && currentEntry.getKind() != SVNNodeKind.DIR) continue;
                this.removeFromRevisionControl(currentEntry.getName(), false, false);
            }
        }
        long textTime = 0L;
        if (!(implicit || this.getThisDirName().equals(fileName) || (fileType = SVNFileType.getType(tmpFile = this.getBaseFile(fileName, true))) != SVNFileType.FILE && fileType != SVNFileType.SYMLINK)) {
            boolean modified = false;
            File workingFile = this.getFile(fileName);
            File tmpFile2 = SVNFileUtil.createUniqueFile(tmpFile.getParentFile(), fileName, ".tmp");
            try {
                String tmpFile2Path = SVNFileUtil.getBasePath(tmpFile2);
                SVNTranslator.translate((SVNAdminArea)this, fileName, fileName, tmpFile2Path, false);
                modified = !SVNFileUtil.compareFiles(tmpFile, tmpFile2, null);
            }
            catch (SVNException svne) {
                SVNErrorMessage err = SVNErrorMessage.create(errorCode, "Error comparing ''{0}'' and ''{1}''", new Object[]{workingFile, tmpFile});
                SVNErrorManager.error(err, svne);
            }
            finally {
                tmpFile2.delete();
            }
            long l = textTime = modified ? tmpFile.lastModified() : workingFile.lastModified();
        }
        if (!implicit && entry.isScheduledForReplacement()) {
            SVNFileUtil.deleteFile(this.getBasePropertiesFile(fileName, false));
        }
        long propTime = 0L;
        boolean setReadWrite = false;
        boolean setNotExecutable = false;
        SVNVersionedProperties baseProps = this.getBaseProperties(fileName);
        SVNVersionedProperties wcProps = this.getProperties(fileName);
        File tmpPropsFile = this.getPropertiesFile(fileName, true);
        File wcPropsFile = this.getPropertiesFile(fileName, false);
        File basePropertiesFile = this.getBasePropertiesFile(fileName, false);
        SVNFileType tmpPropsType = SVNFileType.getType(tmpPropsFile);
        if (tmpPropsType == SVNFileType.FILE) {
            SVNProperties working = new SVNProperties(wcPropsFile, null);
            SVNProperties workingTmp = new SVNProperties(tmpPropsFile, null);
            Map pDiff = working.compareTo(workingTmp);
            boolean equals = pDiff == null || pDiff.isEmpty();
            long l = propTime = equals ? wcPropsFile.lastModified() : tmpPropsFile.lastModified();
            if (!this.getThisDirName().equals(fileName)) {
                SVNVersionedProperties propDiff = baseProps.compareTo(wcProps);
                setReadWrite = propDiff != null && propDiff.containsProperty("svn:needs-lock") && propDiff.getPropertyValue("svn:needs-lock") == null;
                setNotExecutable = propDiff != null && propDiff.containsProperty("svn:executable") && propDiff.getPropertyValue("svn:executable") == null;
            }
            try {
                if (!tmpPropsFile.exists() || tmpPropsFile.length() <= 4L) {
                    SVNFileUtil.deleteFile(basePropertiesFile);
                }
                SVNFileUtil.copyFile(tmpPropsFile, basePropertiesFile, true);
                SVNFileUtil.setReadonly(basePropertiesFile, true);
            }
            finally {
                SVNFileUtil.deleteFile(tmpPropsFile);
            }
        } else if (entry.getPropTime() == null && !wcProps.isEmpty()) {
            propTime = wcPropsFile.lastModified();
        }
        if (!this.getThisDirName().equals(fileName) && !implicit) {
            File tmpFile2 = this.getBaseFile(fileName, true);
            File baseFile = this.getBaseFile(fileName, false);
            File wcFile = this.getFile(fileName);
            File tmpFile22 = null;
            try {
                boolean needsExecutable;
                boolean special;
                tmpFile22 = SVNFileUtil.createUniqueFile(tmpFile2.getParentFile(), fileName, ".tmp");
                boolean overwritten = false;
                SVNFileType fileType2 = SVNFileType.getType(tmpFile2);
                boolean bl = special = this.getProperties(fileName).getPropertyValue("svn:special") != null;
                if (SVNFileUtil.isWindows || !special) {
                    if (fileType2 == SVNFileType.FILE) {
                        SVNTranslator.translate((SVNAdminArea)this, fileName, SVNFileUtil.getBasePath(tmpFile2), SVNFileUtil.getBasePath(tmpFile22), true);
                    } else {
                        SVNTranslator.translate((SVNAdminArea)this, fileName, fileName, SVNFileUtil.getBasePath(tmpFile22), true);
                    }
                    if (!SVNFileUtil.compareFiles(tmpFile22, wcFile, null)) {
                        SVNFileUtil.copyFile(tmpFile22, wcFile, true);
                        overwritten = true;
                    }
                }
                boolean needsReadonly = this.getProperties(fileName).getPropertyValue("svn:needs-lock") != null && entry.getLockToken() == null;
                boolean bl2 = needsExecutable = this.getProperties(fileName).getPropertyValue("svn:executable") != null;
                if (needsReadonly) {
                    SVNFileUtil.setReadonly(wcFile, true);
                    overwritten = true;
                }
                if (needsExecutable) {
                    SVNFileUtil.setExecutable(wcFile, true);
                    overwritten = true;
                }
                if (fileType2 == SVNFileType.FILE) {
                    SVNFileUtil.rename(tmpFile2, baseFile);
                }
                if (setReadWrite) {
                    SVNFileUtil.setReadonly(wcFile, false);
                    overwritten = true;
                }
                if (setNotExecutable) {
                    SVNFileUtil.setExecutable(wcFile, false);
                    overwritten = true;
                }
                if (overwritten) {
                    textTime = wcFile.lastModified();
                }
            }
            catch (SVNException svne) {
                SVNErrorMessage err = SVNErrorMessage.create(errorCode, "Error replacing text-base of ''{0}''", fileName);
                SVNErrorManager.error(err, svne);
            }
            finally {
                tmpFile22.delete();
                tmpFile2.delete();
            }
        }
        HashMap<String, String> entryAttrs = new HashMap<String, String>();
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:revision"), SVNProperty.toString(revisionNumber));
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:kind"), this.getThisDirName().equals(fileName) ? "dir" : "file");
        if (!implicit) {
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:schedule"), null);
        }
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copied"), SVNProperty.toString(false));
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:deleted"), SVNProperty.toString(false));
        if (textTime != 0L && !implicit) {
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:text-time"), SVNTimeUtil.formatDate(new Date(textTime)));
        }
        if (propTime != 0L && !implicit) {
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:prop-time"), SVNTimeUtil.formatDate(new Date(propTime)));
        }
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:conflict-new"), null);
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:conflict-old"), null);
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:conflict-wrk"), null);
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:prop-reject-file"), null);
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-rev"), null);
        entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-url"), null);
        try {
            this.modifyEntry(fileName, entryAttrs, false, true);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = SVNErrorMessage.create(errorCode, "Error modifying entry of ''{0}''", fileName);
            SVNErrorManager.error(err, svne);
        }
        if (!this.getThisDirName().equals(fileName)) {
            return;
        }
        File dirFile = this.getRoot();
        if (this.getWCAccess().isWCRoot(this.getRoot())) {
            return;
        }
        boolean unassociated = false;
        SVNAdminArea parentArea = null;
        try {
            parentArea = this.getWCAccess().retrieve(dirFile.getParentFile());
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                parentArea = this.getWCAccess().open(dirFile.getParentFile(), true, false, 0);
                unassociated = true;
            }
            throw svne;
        }
        SVNEntry entryInParent = parentArea.getEntry(dirFile.getName(), false);
        if (entryInParent != null) {
            entryAttrs.clear();
            if (!implicit) {
                entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:schedule"), null);
            }
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copied"), SVNProperty.toString(false));
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-rev"), null);
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-url"), null);
            entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:deleted"), SVNProperty.toString(false));
            try {
                parentArea.modifyEntry(entryInParent.getName(), entryAttrs, true, true);
            }
            catch (SVNException svne) {
                SVNErrorMessage err = SVNErrorMessage.create(errorCode, "Error modifying entry of ''{0}''", fileName);
                SVNErrorManager.error(err, svne);
            }
        }
        parentArea.saveEntries(false);
        if (unassociated) {
            this.getWCAccess().closeAdminArea(dirFile.getParentFile());
        }
    }

    protected boolean isEntryPropertyApplicable(String propName) {
        return propName != null && !"cachable-props".equals(propName) && !"present-props".equals(propName) && !"has-prop-mods".equals(propName) && !"has-props".equals(propName);
    }

    static {
        BOOLEAN_PROPERTIES.add("svn:entry:copied");
        BOOLEAN_PROPERTIES.add("svn:entry:deleted");
        BOOLEAN_PROPERTIES.add("svn:entry:absent");
        BOOLEAN_PROPERTIES.add("svn:entry:incomplete");
    }
}

