/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNEventFactory {
    public static SVNEvent createMergeEvent(SVNAdminAreaInfo info, String path, SVNEventAction action, SVNEventAction expectedAction, SVNStatusType cType, SVNStatusType pType, SVNNodeKind kind) {
        SVNEvent event = new SVNEvent(info.getTarget().getRoot(), info.getTarget().getFile(path), action, expectedAction, kind, -1L, null, cType, pType, null, null, null);
        event.setPath(path);
        return event;
    }

    public static SVNEvent createMergeEvent(SVNAdminAreaInfo info, File file, SVNEventAction action, SVNEventAction expectedAction, SVNStatusType cType, SVNStatusType pType, SVNNodeKind kind) {
        SVNEvent event = new SVNEvent(info.getTarget().getRoot(), file, action, expectedAction, kind, -1L, null, cType, pType, null, null, null);
        return event;
    }

    public static SVNEvent createMergeEvent(SVNAdminAreaInfo info, SVNAdminArea dir, String path, SVNEventAction action, SVNStatusType cType, SVNStatusType pType, SVNNodeKind kind) {
        SVNEvent event = new SVNEvent(info, dir, SVNPathUtil.tail(path), action, kind, -1L, null, cType, pType, null, null, null);
        event.setPath(path);
        return event;
    }

    public static SVNEvent createCommitEvent(File rootFile, File file, SVNEventAction action, SVNNodeKind kind, String mimeType) {
        return new SVNEvent(rootFile, file, action, kind, -1L, mimeType, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, null, null);
    }

    public static SVNEvent createCommitEvent(File rootFile, File file, SVNEventAction action, SVNNodeKind kind) {
        return new SVNEvent(rootFile, file, action, kind, -1L, null, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, null, null);
    }

    public static SVNEvent createSkipEvent(File rootFile, File file, SVNEventAction action, SVNEventAction expectedAction, SVNNodeKind kind) {
        return new SVNEvent(rootFile, file, action, expectedAction, kind, -1L, null, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, null, null);
    }

    public static SVNEvent createLockEvent(SVNAdminArea dir, String path, SVNEventAction action, SVNLock lock, SVNErrorMessage message) {
        SVNEvent event = new SVNEvent(null, dir, SVNPathUtil.tail(path), action, SVNNodeKind.FILE, -1L, null, null, null, null, lock, message);
        event.setPath(path);
        return event;
    }

    public static SVNEvent createAnnotateEvent(String path, long revision) {
        SVNEvent event = new SVNEvent(null, null, SVNPathUtil.tail(path), SVNEventAction.ANNOTATE, SVNNodeKind.NONE, revision, null, null, null, null, null, null);
        event.setPath(path);
        return event;
    }

    public static SVNEvent createAddedEvent(SVNAdminAreaInfo info, SVNAdminArea dir, SVNEntry entry) {
        String mimeType = null;
        try {
            mimeType = dir.getProperties(entry.getName()).getPropertyValue("svn:mime-type");
        }
        catch (SVNException e) {
            // empty catch block
        }
        return new SVNEvent(info, dir, entry.getName(), SVNEventAction.ADD, entry.getKind(), 0L, mimeType, null, null, null, null, null);
    }

    public static SVNEvent createAddedEvent(SVNAdminArea dir, String name, SVNNodeKind kind, String mimeType) {
        return new SVNEvent(null, dir, name, SVNEventAction.ADD, kind, 0L, mimeType, null, null, null, null, null);
    }

    public static SVNEvent createDeletedEvent(SVNAdminArea dir, String name) {
        return new SVNEvent(null, dir, name, SVNEventAction.DELETE, null, 0L, null, null, null, null, null, null);
    }

    public static SVNEvent createUpdateExternalEvent(SVNAdminAreaInfo info, String path) {
        SVNEvent event = new SVNEvent(info, null, null, SVNEventAction.UPDATE_EXTERNAL, SVNNodeKind.DIR, -1L, null, null, null, null, null, null);
        event.setPath(path);
        return event;
    }

    public static SVNEvent createStatusExternalEvent(SVNAdminAreaInfo info, String path) {
        SVNEvent event = new SVNEvent(info, null, null, SVNEventAction.STATUS_EXTERNAL, SVNNodeKind.DIR, -1L, null, null, null, null, null, null);
        event.setPath(path);
        return event;
    }

    public static SVNEvent createUpdateCompletedEvent(SVNAdminAreaInfo info, long revision) {
        return new SVNEvent(info, info != null ? info.getTarget() : null, "", SVNEventAction.UPDATE_COMPLETED, SVNNodeKind.NONE, revision, null, null, null, null, null, null);
    }

    public static SVNEvent createCommitCompletedEvent(SVNAdminAreaInfo info, long revision) {
        return new SVNEvent(info, null, "", SVNEventAction.COMMIT_COMPLETED, SVNNodeKind.NONE, revision, null, null, null, null, null, null);
    }

    public static SVNEvent createStatusCompletedEvent(SVNAdminAreaInfo info, long revision) {
        return new SVNEvent(info, info.getAnchor(), info.getTargetName(), SVNEventAction.STATUS_COMPLETED, SVNNodeKind.NONE, revision, null, null, null, null, null, null);
    }

    public static SVNEvent createUpdateModifiedEvent(SVNAdminAreaInfo info, SVNAdminArea adminArea, String name, SVNNodeKind kind, SVNEventAction action, String mimeType, SVNStatusType contents, SVNStatusType props, SVNStatusType lock) {
        return new SVNEvent(info, adminArea, name, action, kind, -1L, mimeType, contents, props, lock, null, null);
    }

    public static SVNEvent createUpdateAddEvent(SVNAdminAreaInfo info, SVNAdminArea adminArea, SVNNodeKind kind, SVNEntry entry) {
        return new SVNEvent(info, adminArea, entry.getName(), SVNEventAction.UPDATE_ADD, kind, entry.getRevision(), null, null, null, null, null, null);
    }

    public static SVNEvent createExportAddedEvent(File root, File file, SVNNodeKind kind) {
        return new SVNEvent(root, file, SVNEventAction.UPDATE_ADD, kind, -1L, null, null, null, null, null, null);
    }

    public static SVNEvent createUpdateDeleteEvent(SVNAdminAreaInfo info, SVNAdminArea adminArea, SVNNodeKind kind, String name) {
        return new SVNEvent(info, adminArea, name, SVNEventAction.UPDATE_DELETE, kind, -1L, null, null, null, null, null, null);
    }

    public static SVNEvent createRestoredEvent(SVNAdminAreaInfo info, SVNAdminArea adminArea, SVNEntry entry) {
        return new SVNEvent(info, adminArea, entry.getName(), SVNEventAction.RESTORE, entry.getKind(), entry.getRevision(), null, null, null, null, null, null);
    }

    public static SVNEvent createResolvedEvent(SVNAdminAreaInfo info, SVNAdminArea adminArea, SVNEntry entry) {
        return new SVNEvent(info, adminArea, entry.getName(), SVNEventAction.RESOLVED, entry.getKind(), entry.getRevision(), null, null, null, null, null, null);
    }

    public static SVNEvent createRevertedEvent(SVNAdminArea dir, SVNEntry entry) {
        return new SVNEvent(null, dir, entry.getName(), SVNEventAction.REVERT, entry.getKind(), entry.getRevision(), null, null, null, null, null, null);
    }

    public static SVNEvent createNotRevertedEvent(SVNAdminArea dir, SVNEntry entry) {
        return new SVNEvent(null, dir, entry.getName(), SVNEventAction.FAILED_REVERT, entry.getKind(), entry.getRevision(), null, null, null, null, null, null);
    }

    public static SVNEvent createUpdateDeleteEvent(SVNAdminAreaInfo info, SVNAdminArea adminArea, SVNEntry entry) {
        return new SVNEvent(info, adminArea, entry.getName(), SVNEventAction.UPDATE_DELETE, entry.getKind(), entry.getRevision(), null, null, null, null, null, null);
    }

    public static SVNEvent createUpgradeEvent(SVNAdminArea adminArea) {
        return new SVNEvent(null, adminArea.getRoot(), SVNEventAction.UPGRADE, SVNNodeKind.DIR, -1L, null, null, null, null, null, null);
    }
}

