/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;

class DAVResource {
    private String myWURL;
    private String myVURL;
    private String myURL;
    private String myPath;
    private ISVNWorkspaceMediator myMediator;
    private long myRevision;
    private boolean myIsCopy;
    private DAVConnection myConnection;
    private Map myProperties;
    private boolean myIsAdded;

    public DAVResource(ISVNWorkspaceMediator mediator, DAVConnection connection, String path, long revision) {
        this(mediator, connection, path, revision, false);
    }

    public DAVResource(ISVNWorkspaceMediator mediator, DAVConnection connection, String path, long revision, boolean isCopy) {
        this.myPath = path;
        this.myMediator = mediator;
        String locationPath = SVNEncodingUtil.uriEncode(connection.getLocation().getPath());
        this.myURL = SVNPathUtil.append(locationPath, path);
        this.myRevision = revision;
        this.myConnection = connection;
        this.myIsCopy = isCopy;
    }

    public void setAdded(boolean added) {
        this.myIsAdded = added;
    }

    public boolean isAdded() {
        return this.myIsAdded;
    }

    public boolean isCopy() {
        return this.myIsCopy;
    }

    public String getURL() {
        return this.myURL;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getVersionURL() {
        return this.myVURL;
    }

    public void fetchVersionURL(boolean force) throws SVNException {
        if (!force && this.getVersionURL() != null) {
            return;
        }
        if (!force && this.myMediator != null) {
            this.myVURL = this.myMediator.getWorkspaceProperty(SVNEncodingUtil.uriDecode(this.myPath), "svn:wc:ra_dav:version-url");
            if (this.myVURL != null) {
                return;
            }
        }
        String path = this.myURL;
        if (this.myRevision >= 0L) {
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, null, path, this.myRevision, false, false, null);
            path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
        }
        this.myVURL = DAVUtil.getPropertyValue(this.myConnection, path, null, DAVElement.CHECKED_IN);
    }

    public String getWorkingURL() {
        return this.myWURL;
    }

    public void dispose() {
        this.myProperties = null;
    }

    public void setWorkingURL(String location) {
        this.myWURL = location;
    }

    public void putProperty(String name, String value) {
        if (this.myProperties == null) {
            this.myProperties = new HashMap();
        }
        this.myProperties.put(name, value);
    }

    public Map getProperties() {
        return this.myProperties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.myURL);
        sb.append("][");
        sb.append(this.myVURL);
        sb.append("][");
        sb.append(this.myWURL);
        sb.append("][");
        sb.append(this.myPath);
        sb.append("]");
        return sb.toString();
    }
}

