/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.IOException;
import java.io.Reader;

public class BoundedReader
extends Reader {
    private final Reader target;
    int pos = 0;
    int readAheadLimit;

    public BoundedReader(Reader target, int readAheadLimit) throws IOException {
        this.target = target;
        target.mark(readAheadLimit);
        this.readAheadLimit = readAheadLimit;
    }

    @Override
    public void close() throws IOException {
        this.target.close();
    }

    @Override
    public void reset() throws IOException {
        this.pos = 0;
        this.target.reset();
    }

    @Override
    public void mark(int theReadAheadLimit) throws IOException {
        this.readAheadLimit = theReadAheadLimit;
        this.target.mark(theReadAheadLimit);
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.readAheadLimit) {
            return -1;
        }
        ++this.pos;
        return this.target.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            cbuf[off + i] = (char)c;
        }
        return len;
    }
}

