/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.logging;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DiagnosticContext
extends ConcurrentHashMap<String, Object> {
    public TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName) {
        return this.makeTimeSeriesPoint(timeSeriesName, Instant.now());
    }

    public TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName, long tsMs) {
        return this.makeTimeSeriesPoint(timeSeriesName, Instant.ofEpochMilli(tsMs));
    }

    public TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName, Instant instant) {
        return new TimeSeriesPoint(this).addField("series", timeSeriesName).addField("time", instant.getEpochSecond() + "." + instant.getNano());
    }

    public static class TimeSeriesPoint
    extends HashMap<String, Object> {
        TimeSeriesPoint(Map<String, Object> m) {
            super(m);
        }

        public TimeSeriesPoint addField(String key, Object value) {
            super.put(key, value);
            return this;
        }
    }
}

