/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/OverloadsAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend.java"})
public final class OverloadsAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block0: {
            AnnotationDescriptor annotationDescriptor;
            AnnotationDescriptor annotation2;
            KtAnnotationEntry annotationEntry;
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            AnnotationDescriptor annotationDescriptor2 = AnnotationUtilKt.findJvmOverloadsAnnotation(descriptor2);
            if (annotationDescriptor2 == null || (annotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2 = (annotationDescriptor = annotationDescriptor2))) == null) break block0;
            this.checkDeclaration(annotationEntry, descriptor2, context.getTrace());
        }
    }

    private final void checkDeclaration(KtAnnotationEntry annotationEntry, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder) {
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((CallableDescriptor)descriptor2).getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if ((classDescriptor != null ? classDescriptor.getKind() : null) == ClassKind.INTERFACE) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_INTERFACE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        } else if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).getModality() == Modality.ABSTRACT) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_ABSTRACT.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        } else if (DescriptorUtils.isLocal(descriptor2)) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_LOCAL.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        } else if (!((CallableDescriptor)descriptor2).getVisibility().isPublicAPI() && Intrinsics.areEqual((Object)((CallableDescriptor)descriptor2).getVisibility(), (Object)Visibilities.INTERNAL) ^ true) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_PRIVATE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        } else {
            boolean bl;
            block14: {
                List<ValueParameterDescriptor> list2 = ((CallableDescriptor)descriptor2).getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
                Iterable $receiver$iv = list2;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                        if (!it.declaresDefaultValue()) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
            }
            if (bl) {
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_WITHOUT_DEFAULT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            }
        }
    }
}

