/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.StringUtils;
import org.jitsi.utils.logging.Logger;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.RTPLevelRelayType;
import org.jitsi.xmpp.extensions.colibri.SimulcastMode;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleUtils;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.Jid;

public class ColibriBuilder {
    private static final Logger logger = Logger.getLogger(ColibriBuilder.class);
    private final ColibriConferenceIQ conferenceState;
    private RequestType requestType = RequestType.UNDEFINED;
    private ColibriConferenceIQ request;
    private boolean hasAnyChannelsToExpire = false;
    private Integer channelLastN;
    private SimulcastMode simulcastMode;
    private Integer audioPacketDelay;
    private RTPLevelRelayType rtpLevelRelayType;

    private static void copyTransport(ContentPacketExtension content, ColibriConferenceIQ.ChannelCommon channel) {
        IceUdpTransportPacketExtension transport = content.getFirstChildOfType(IceUdpTransportPacketExtension.class);
        channel.setTransport(IceUdpTransportPacketExtension.cloneTransportAndCandidates(transport, true));
    }

    private static boolean copyDescription(ContentPacketExtension content, ColibriConferenceIQ.Channel channel) {
        RtpDescriptionPacketExtension description = content.getFirstChildOfType(RtpDescriptionPacketExtension.class);
        if (description != null) {
            return ColibriBuilder.copyDescription(description, channel);
        }
        return false;
    }

    private static boolean copyDescription(RtpDescriptionPacketExtension description, ColibriConferenceIQ.Channel channel) {
        boolean added = false;
        for (PayloadTypePacketExtension payloadType : description.getPayloadTypes()) {
            channel.addPayloadType(PayloadTypePacketExtension.clone(payloadType));
            added = true;
        }
        for (RTPHdrExtPacketExtension rtpHdrExt : description.getExtmapList()) {
            channel.addRtpHeaderExtension(RTPHdrExtPacketExtension.clone(rtpHdrExt));
            added = true;
        }
        return added;
    }

    private static void addSources(ColibriConferenceIQ.Channel channel, List<SourcePacketExtension> sources) {
        for (SourcePacketExtension source : sources) {
            channel.addSource(source.copy());
        }
        if (channel.getSources() == null || channel.getSources().isEmpty()) {
            SourcePacketExtension emptySource = new SourcePacketExtension();
            emptySource.setSSRC(-1L);
            channel.addSource(emptySource);
        }
    }

    private static boolean addSourceGroups(ColibriConferenceIQ.Channel channel, List<SourceGroupPacketExtension> sourceGroups, boolean video) {
        boolean hasAnyChanges = false;
        if (sourceGroups.isEmpty() && video) {
            hasAnyChanges = true;
            channel.addSourceGroup(SourceGroupPacketExtension.createSimulcastGroup());
        }
        for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
            hasAnyChanges = true;
            channel.addSourceGroup(sourceGroup);
        }
        return hasAnyChanges;
    }

    public ColibriBuilder(ColibriConferenceIQ conferenceState) {
        this.conferenceState = Objects.requireNonNull(conferenceState, "conferenceState");
        this.reset();
    }

    public void reset() {
        this.requestType = RequestType.UNDEFINED;
        this.request = new ColibriConferenceIQ();
        this.request.setID(this.conferenceState.getID());
        this.request.setName(this.conferenceState.getName());
        this.request.setGID(this.conferenceState.getGID());
        this.request.setType(IQ.Type.set);
    }

    public boolean addAllocateChannelsReq(boolean useBundle, String endpointId, String statsId, boolean peerIsInitiator, List<ContentPacketExtension> contents) {
        return this.addAllocateChannelsReq(useBundle, endpointId, statsId, peerIsInitiator, contents, null, null, null);
    }

    public boolean addAllocateChannelsReq(boolean useBundle, String endpointId, String statsId, boolean peerIsInitiator, List<ContentPacketExtension> contents, Map<String, List<SourcePacketExtension>> sourceMap, Map<String, List<SourceGroupPacketExtension>> sourceGroupMap, List<String> octoRelayIds) {
        Objects.requireNonNull(contents, "contents");
        this.assertRequestType(RequestType.ALLOCATE_CHANNELS);
        boolean hasAnyChanges = false;
        for (ContentPacketExtension content : contents) {
            MediaType mediaType = JingleUtils.getMediaType(content);
            String contentName = mediaType.toString();
            ColibriConferenceIQ.Content requestContent = this.request.getOrCreateContent(contentName);
            ColibriConferenceIQ.ChannelCommon requestChannel = mediaType == MediaType.DATA ? new ColibriConferenceIQ.SctpConnection() : (octoRelayIds != null ? new ColibriConferenceIQ.OctoChannel() : new ColibriConferenceIQ.Channel());
            if (endpointId != null) {
                requestChannel.setEndpoint(endpointId);
            }
            requestChannel.setInitiator(peerIsInitiator);
            if (useBundle && endpointId != null) {
                requestChannel.setChannelBundleId(endpointId);
            }
            if (requestChannel instanceof ColibriConferenceIQ.Channel) {
                ColibriConferenceIQ.Channel requestRtpChannel = (ColibriConferenceIQ.Channel)requestChannel;
                ColibriBuilder.copyDescription(content, requestRtpChannel);
                requestRtpChannel.setLastN(this.channelLastN);
                requestRtpChannel.setSimulcastMode(this.simulcastMode);
                if (MediaType.AUDIO.equals((Object)mediaType)) {
                    requestRtpChannel.setPacketDelay(this.audioPacketDelay);
                    requestRtpChannel.setRTPLevelRelayType(this.rtpLevelRelayType);
                }
                if (sourceMap != null && sourceMap.get(contentName) != null) {
                    ColibriBuilder.addSources(requestRtpChannel, sourceMap.get(contentName));
                }
                if (sourceGroupMap != null && sourceGroupMap.get(contentName) != null) {
                    ColibriBuilder.addSourceGroups(requestRtpChannel, sourceGroupMap.get(contentName), MediaType.VIDEO.equals((Object)mediaType));
                }
            }
            if (requestChannel instanceof ColibriConferenceIQ.OctoChannel) {
                ((ColibriConferenceIQ.OctoChannel)requestChannel).setRelays(octoRelayIds);
            }
            if (!useBundle) {
                ColibriBuilder.copyTransport(content, requestChannel);
            }
            if (requestChannel instanceof ColibriConferenceIQ.Channel) {
                requestContent.addChannel((ColibriConferenceIQ.Channel)requestChannel);
            } else {
                requestContent.addSctpConnection((ColibriConferenceIQ.SctpConnection)requestChannel);
            }
            hasAnyChanges = true;
        }
        if (useBundle && endpointId != null && contents.size() >= 1) {
            ColibriConferenceIQ.ChannelBundle bundle = new ColibriConferenceIQ.ChannelBundle(endpointId);
            ContentPacketExtension firstContent = contents.get(0);
            IceUdpTransportPacketExtension transport = firstContent.getFirstChildOfType(IceUdpTransportPacketExtension.class);
            if (transport != null) {
                hasAnyChanges = true;
                bundle.setTransport(IceUdpTransportPacketExtension.cloneTransportAndCandidates(transport, true));
            }
            this.request.addChannelBundle(bundle);
        } else if (useBundle && endpointId == null) {
            logger.error((Object)"Bundle requested, but no endpointId provided.");
        }
        if (endpointId != null) {
            ColibriConferenceIQ.Endpoint endpoint = new ColibriConferenceIQ.Endpoint(endpointId, statsId, null);
            this.request.addEndpoint(endpoint);
        }
        return hasAnyChanges;
    }

    public boolean addBundleTransportUpdateReq(IceUdpTransportPacketExtension transport, String channelBundleId) throws IllegalArgumentException {
        Objects.requireNonNull(transport, "transport");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            logger.warn((Object)"Not adding a transport bundle, not initialized");
            return false;
        }
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        ColibriConferenceIQ.ChannelBundle channelBundleRequest = new ColibriConferenceIQ.ChannelBundle(channelBundleId);
        channelBundleRequest.setTransport(IceUdpTransportPacketExtension.cloneTransportAndCandidates(transport, true));
        this.request.addChannelBundle(channelBundleRequest);
        return true;
    }

    public boolean addExpireChannelsReq(ColibriConferenceIQ channelInfo) {
        ColibriConferenceIQ.Content stateContent;
        Objects.requireNonNull(channelInfo, "channelInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        this.assertRequestType(RequestType.EXPIRE_CHANNELS);
        for (ColibriConferenceIQ.Content expiredContent : channelInfo.getContents()) {
            stateContent = this.conferenceState.getContent(expiredContent.getName());
            if (stateContent == null) continue;
            ColibriConferenceIQ.Content requestContent = this.request.getOrCreateContent(stateContent.getName());
            for (ColibriConferenceIQ.Channel expiredChannel : expiredContent.getChannels()) {
                ColibriConferenceIQ.Channel stateChannel = stateContent.getChannel(expiredChannel.getID());
                if (stateChannel == null) continue;
                ColibriConferenceIQ.Channel requestChannel = new ColibriConferenceIQ.Channel();
                requestChannel.setExpire(0);
                requestChannel.setID(stateChannel.getID());
                requestContent.addChannel(requestChannel);
                this.hasAnyChannelsToExpire = true;
            }
            for (ColibriConferenceIQ.SctpConnection expiredConn : expiredContent.getSctpConnections()) {
                ColibriConferenceIQ.SctpConnection stateConn = stateContent.getSctpConnection(expiredConn.getID());
                if (stateConn == null) continue;
                ColibriConferenceIQ.SctpConnection requestConn = new ColibriConferenceIQ.SctpConnection();
                requestConn.setID(stateConn.getID());
                requestConn.setExpire(0);
                requestConn.setEndpoint(stateConn.getEndpoint());
                requestContent.addSctpConnection(requestConn);
                this.hasAnyChannelsToExpire = true;
            }
        }
        for (ColibriConferenceIQ.Content requestContent : this.request.getContents()) {
            stateContent = this.conferenceState.getContent(requestContent.getName());
            for (ColibriConferenceIQ.Channel requestChannel : requestContent.getChannels()) {
                ColibriConferenceIQ.Channel stateChannel = stateContent.getChannel(requestChannel.getID());
                stateContent.removeChannel(stateChannel);
            }
            for (ColibriConferenceIQ.SctpConnection requestConn : requestContent.getSctpConnections()) {
                ColibriConferenceIQ.SctpConnection stateConn = stateContent.getSctpConnection(requestConn.getID());
                stateContent.removeSctpConnection(stateConn);
            }
        }
        return this.hasAnyChannelsToExpire;
    }

    public boolean addRtpDescription(RtpDescriptionPacketExtension description, String contentName, ColibriConferenceIQ.Channel channel) {
        Objects.requireNonNull(description, "description");
        Objects.requireNonNull(contentName, "contentName");
        Objects.requireNonNull(channel, "channel");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            logger.warn((Object)"Not adding description to a channel, not initialized");
            return false;
        }
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        ColibriConferenceIQ.Channel requestChannel = this.getRequestChannel(contentName, channel);
        return ColibriBuilder.copyDescription(description, requestChannel);
    }

    public boolean addSourceInfo(Map<String, List<SourcePacketExtension>> sourceMap, ColibriConferenceIQ localChannelsInfo) {
        Objects.requireNonNull(sourceMap, "sourceMap");
        Objects.requireNonNull(localChannelsInfo, "localChannelsInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        boolean hasAnyChanges = false;
        for (String contentName : sourceMap.keySet()) {
            ColibriConferenceIQ.Channel channel = this.getChannel(localChannelsInfo, contentName);
            if (channel == null) continue;
            hasAnyChanges = true;
            ColibriConferenceIQ.Channel requestChannel = this.getRequestChannel(contentName, channel);
            ColibriBuilder.addSources(requestChannel, sourceMap.get(contentName));
        }
        return hasAnyChanges;
    }

    public boolean addOctoRelays(List<String> octoRelays, ColibriConferenceIQ localChannelsInfo) {
        Objects.requireNonNull(octoRelays, "octoRelays");
        Objects.requireNonNull(localChannelsInfo, "localChannelsInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        boolean hasAnyChanges = false;
        for (ColibriConferenceIQ.Content content : this.conferenceState.getContents()) {
            String contentName = content.getName();
            ColibriConferenceIQ.Channel channel = this.getChannel(localChannelsInfo, contentName);
            if (channel == null || !(channel instanceof ColibriConferenceIQ.OctoChannel)) continue;
            ColibriConferenceIQ.OctoChannel requestChannel = this.getRequestChannel(contentName, (ColibriConferenceIQ.OctoChannel)channel);
            requestChannel.setRelays(octoRelays);
            hasAnyChanges = true;
        }
        return hasAnyChanges;
    }

    public boolean addSourceGroupsInfo(Map<String, List<SourceGroupPacketExtension>> sourceGroupMap, ColibriConferenceIQ localChannelsInfo) {
        Objects.requireNonNull(sourceGroupMap, "sourceGroupMap");
        Objects.requireNonNull(localChannelsInfo, "localChannelsInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        boolean hasAnyChanges = false;
        for (String contentName : sourceGroupMap.keySet()) {
            ColibriConferenceIQ.Channel channel = this.getChannel(localChannelsInfo, contentName);
            if (channel == null) continue;
            ColibriConferenceIQ.Channel requestChannel = this.getRequestChannel(contentName, channel);
            hasAnyChanges |= ColibriBuilder.addSourceGroups(requestChannel, sourceGroupMap.get(contentName), "video".equalsIgnoreCase(contentName));
        }
        return hasAnyChanges;
    }

    public boolean addTransportUpdateReq(Map<String, IceUdpTransportPacketExtension> transportMap, ColibriConferenceIQ localChannelsInfo) {
        Objects.requireNonNull(transportMap, "transportMap");
        Objects.requireNonNull(localChannelsInfo, "localChannelsInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        boolean hasAnyChanges = false;
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        for (Map.Entry<String, IceUdpTransportPacketExtension> e : transportMap.entrySet()) {
            String contentName = e.getKey();
            ColibriConferenceIQ.ChannelCommon channel = this.getChannelCommon(localChannelsInfo, contentName);
            if (channel == null) continue;
            IceUdpTransportPacketExtension transport = IceUdpTransportPacketExtension.cloneTransportAndCandidates(e.getValue(), true);
            ColibriConferenceIQ.ChannelCommon requestChannel = channel instanceof ColibriConferenceIQ.Channel ? new ColibriConferenceIQ.Channel() : new ColibriConferenceIQ.SctpConnection();
            requestChannel.setID(channel.getID());
            requestChannel.setEndpoint(channel.getEndpoint());
            requestChannel.setTransport(transport);
            this.request.getOrCreateContent(contentName).addChannelCommon(requestChannel);
            hasAnyChanges = true;
        }
        return hasAnyChanges;
    }

    public boolean addDirectionUpdateReq(Map<String, ?> mediaDirectionMap, ColibriConferenceIQ localChannelsInfo) {
        Objects.requireNonNull(mediaDirectionMap, "mediaDirectionMap");
        Objects.requireNonNull(localChannelsInfo, "localChannelsInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        boolean hasAnyChanges = false;
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        for (String contentName : mediaDirectionMap.keySet()) {
            ColibriConferenceIQ.Content content = localChannelsInfo.getContent(contentName);
            if (content == null) continue;
            for (ColibriConferenceIQ.Channel channel : content.getChannels()) {
                ColibriConferenceIQ.Channel requestChannel = this.getRequestChannel(contentName, channel);
                Object directionValue = mediaDirectionMap.get(contentName);
                requestChannel.setDirection(directionValue != null ? directionValue.toString() : null);
                hasAnyChanges = true;
            }
        }
        return hasAnyChanges;
    }

    private ColibriConferenceIQ.ChannelCommon getChannelCommon(ColibriConferenceIQ colibriConferenceIQ, String contentName) {
        ColibriConferenceIQ.Content content = colibriConferenceIQ.getContent(contentName);
        if (content == null) {
            return null;
        }
        if (content.getChannelCount() > 0) {
            return content.getChannel(0);
        }
        if (content.getSctpConnections().size() > 0) {
            return content.getSctpConnections().get(0);
        }
        return null;
    }

    private ColibriConferenceIQ.Channel getChannel(ColibriConferenceIQ localChannelsInfo, String contentName) {
        ColibriConferenceIQ.ChannelCommon channel = this.getChannelCommon(localChannelsInfo, contentName);
        return channel instanceof ColibriConferenceIQ.Channel ? (ColibriConferenceIQ.Channel)channel : null;
    }

    public ColibriConferenceIQ getRequest(Jid videobridge) {
        Objects.requireNonNull(videobridge);
        this.request.setTo(videobridge);
        if (this.requestType == RequestType.EXPIRE_CHANNELS) {
            if (!this.hasAnyChannelsToExpire) {
                return null;
            }
            this.hasAnyChannelsToExpire = false;
        }
        return this.request;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    private void assertRequestType(RequestType currentReqType) {
        if (this.requestType == RequestType.UNDEFINED) {
            this.requestType = currentReqType;
        }
        if (this.requestType != currentReqType) {
            throw new IllegalStateException("Request type already set to " + (Object)((Object)this.requestType) + ", can not change to " + (Object)((Object)currentReqType));
        }
    }

    public boolean hasAnyChannelsToExpire() {
        return this.hasAnyChannelsToExpire;
    }

    public Integer getChannelLastN() {
        return this.channelLastN;
    }

    public void setChannelLastN(Integer channelLastN) {
        this.channelLastN = channelLastN;
    }

    public Integer getAudioPacketDelay() {
        return this.audioPacketDelay;
    }

    public void setAudioPacketDelay(Integer audioPacketDelay) {
        this.audioPacketDelay = audioPacketDelay;
    }

    public void setSimulcastMode(SimulcastMode simulcastMode) {
        this.simulcastMode = simulcastMode;
    }

    private <T extends ColibriConferenceIQ.ChannelCommon> T getRequestChannel(String contentName, T channel) {
        ColibriConferenceIQ.Content requestContent = this.request.getOrCreateContent(contentName);
        ColibriConferenceIQ.ChannelCommon requestChannel = requestContent.getChannel(channel.getID());
        if (requestChannel == null) {
            requestChannel = requestContent.getSctpConnection(channel.getID());
        }
        if (requestChannel == null) {
            requestChannel = channel instanceof ColibriConferenceIQ.SctpConnection ? new ColibriConferenceIQ.SctpConnection() : (channel instanceof ColibriConferenceIQ.OctoChannel ? new ColibriConferenceIQ.OctoChannel() : new ColibriConferenceIQ.Channel());
            requestChannel.setID(channel.getID());
            requestContent.addChannelCommon(requestChannel);
        }
        try {
            return (T)requestChannel;
        }
        catch (ClassCastException cce) {
            throw new IllegalStateException("Channel type mismatch: requested " + channel.getClass().getSimpleName() + ", found a channel of class " + requestChannel.getClass().getSimpleName());
        }
    }

    public void setRTPLevelRelayType(RTPLevelRelayType rtpLevelRelayType) {
        this.rtpLevelRelayType = rtpLevelRelayType;
    }

    public void setRTPLevelRelayType(String rtpLevelRelayType) {
        this.setRTPLevelRelayType(RTPLevelRelayType.parseRTPLevelRelayType(rtpLevelRelayType));
    }

    public static enum RequestType {
        ALLOCATE_CHANNELS,
        CHANNEL_INFO_UPDATE,
        EXPIRE_CHANNELS,
        UNDEFINED;

    }
}

