/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionClosedListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ExceptionCallback;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.packet.Ping;
import org.jxmpp.jid.Jid;

public final class PingManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(PingManager.class.getName());
    private static final Map<XMPPConnection, PingManager> INSTANCES = new WeakHashMap<XMPPConnection, PingManager>();
    private static int defaultPingInterval;
    private final Set<PingFailedListener> pingFailedListeners = new CopyOnWriteArraySet<PingFailedListener>();
    private int pingInterval = defaultPingInterval;
    private ScheduledFuture<?> nextAutomaticPing;
    private final Runnable pingServerRunnable = new Runnable(){

        @Override
        public void run() {
            LOGGER.fine("ServerPingTask run()");
            PingManager.this.pingServerIfNecessary();
        }
    };

    public static synchronized PingManager getInstanceFor(XMPPConnection connection) {
        PingManager pingManager = INSTANCES.get(connection);
        if (pingManager == null) {
            pingManager = new PingManager(connection);
            INSTANCES.put(connection, pingManager);
        }
        return pingManager;
    }

    public static void setDefaultPingInterval(int interval) {
        defaultPingInterval = interval;
    }

    private PingManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        sdm.addFeature("urn:xmpp:ping");
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("ping", "urn:xmpp:ping", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                Ping ping = (Ping)iqRequest;
                return ping.getPong();
            }
        });
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionClosedListener(){

            public void authenticated(XMPPConnection connection, boolean resumed) {
                PingManager.this.maybeSchedulePingServerTask();
            }

            public void connectionTerminated() {
                PingManager.this.maybeStopPingServerTask();
            }
        });
        this.maybeSchedulePingServerTask();
    }

    private boolean isValidErrorPong(Jid destinationJid, XMPPException.XMPPErrorException xmppErrorException) {
        if (destinationJid.equals((CharSequence)this.connection().getServiceName())) {
            return true;
        }
        XMPPError xmppError = xmppErrorException.getXMPPError();
        XMPPError.Type type = xmppError.getType();
        XMPPError.Condition condition = xmppError.getCondition();
        return type == XMPPError.Type.CANCEL && condition == XMPPError.Condition.feature_not_implemented;
    }

    public SmackFuture<Boolean> pingAsync(Jid jid) {
        return this.pingAsync(jid, this.connection().getReplyTimeout());
    }

    public SmackFuture<Boolean> pingAsync(final Jid jid, long pongTimeout) {
        SmackFuture.InternalSmackFuture<Boolean> future = new SmackFuture.InternalSmackFuture<Boolean>(){

            public void handleStanza(Stanza packet) throws SmackException.NotConnectedException, InterruptedException {
                this.setResult(true);
            }

            public boolean isNonFatalException(Exception exception) {
                XMPPException.XMPPErrorException xmppErrorException;
                if (exception instanceof XMPPException.XMPPErrorException && PingManager.this.isValidErrorPong(jid, xmppErrorException = (XMPPException.XMPPErrorException)exception)) {
                    this.setResult(true);
                    return true;
                }
                return false;
            }
        };
        Ping ping = new Ping(jid);
        try {
            XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
            connection.sendIqWithResponseCallback((IQ)ping, (StanzaListener)future, (ExceptionCallback)future, pongTimeout);
        }
        catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException e) {
            future.processException((Exception)e);
        }
        return future;
    }

    public boolean ping(Jid jid, long pingTimeout) throws SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException {
        XMPPConnection connection = this.connection();
        if (!connection.isAuthenticated()) {
            throw new SmackException.NotConnectedException();
        }
        Ping ping = new Ping(jid);
        try {
            connection.createStanzaCollectorAndSend((IQ)ping).nextResultOrThrow(pingTimeout);
        }
        catch (XMPPException.XMPPErrorException e) {
            return this.isValidErrorPong(jid, e);
        }
        return true;
    }

    public boolean ping(Jid jid) throws SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException {
        return this.ping(jid, this.connection().getReplyTimeout());
    }

    public boolean isPingSupported(Jid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "urn:xmpp:ping");
    }

    public boolean pingMyServer() throws SmackException.NotConnectedException, InterruptedException {
        return this.pingMyServer(true);
    }

    public boolean pingMyServer(boolean notifyListeners) throws SmackException.NotConnectedException, InterruptedException {
        return this.pingMyServer(notifyListeners, this.connection().getReplyTimeout());
    }

    public boolean pingMyServer(boolean notifyListeners, long pingTimeout) throws SmackException.NotConnectedException, InterruptedException {
        boolean res;
        try {
            res = this.ping((Jid)this.connection().getXMPPServiceDomain(), pingTimeout);
        }
        catch (SmackException.NoResponseException e) {
            res = false;
        }
        if (!res && notifyListeners) {
            for (PingFailedListener l : this.pingFailedListeners) {
                l.pingFailed();
            }
        }
        return res;
    }

    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
        this.maybeSchedulePingServerTask();
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public void registerPingFailedListener(PingFailedListener listener) {
        this.pingFailedListeners.add(listener);
    }

    public void unregisterPingFailedListener(PingFailedListener listener) {
        this.pingFailedListeners.remove(listener);
    }

    private void maybeSchedulePingServerTask() {
        this.maybeSchedulePingServerTask(0);
    }

    private synchronized void maybeSchedulePingServerTask(int delta) {
        this.maybeStopPingServerTask();
        if (this.pingInterval > 0) {
            int nextPingIn = this.pingInterval - delta;
            LOGGER.fine("Scheduling ServerPingTask in " + nextPingIn + " seconds (pingInterval=" + this.pingInterval + ", delta=" + delta + ")");
            this.nextAutomaticPing = PingManager.schedule((Runnable)this.pingServerRunnable, (long)nextPingIn, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private void maybeStopPingServerTask() {
        if (this.nextAutomaticPing != null) {
            this.nextAutomaticPing.cancel(true);
            this.nextAutomaticPing = null;
        }
    }

    public synchronized void pingServerIfNecessary() {
        long now;
        int deltaInSeconds;
        int DELTA = 1000;
        int TRIES = 3;
        XMPPConnection connection = this.connection();
        if (connection == null) {
            return;
        }
        if (this.pingInterval <= 0) {
            return;
        }
        long lastStanzaReceived = connection.getLastStanzaReceived();
        if (lastStanzaReceived > 0L && (deltaInSeconds = (int)(((now = System.currentTimeMillis()) - lastStanzaReceived) / 1000L)) < this.pingInterval) {
            this.maybeSchedulePingServerTask(deltaInSeconds);
            return;
        }
        if (connection.isAuthenticated()) {
            boolean res = false;
            for (int i = 0; i < 3; ++i) {
                if (i != 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                try {
                    res = this.pingMyServer(false);
                }
                catch (InterruptedException | SmackException e) {
                    LOGGER.log(Level.WARNING, "Exception while pinging server of " + connection, e);
                    res = false;
                }
                if (res) break;
            }
            if (!res) {
                for (PingFailedListener l : this.pingFailedListeners) {
                    l.pingFailed();
                }
            } else {
                this.maybeSchedulePingServerTask();
            }
        } else {
            LOGGER.warning("XMPPConnection was not authenticated");
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                PingManager.getInstanceFor(connection);
            }
        });
        defaultPingInterval = 1800;
    }
}

