/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.TargetPlatformRegistryLoader;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.preferences.SourceCodeLocationsPreferenceNode;
import org.eclipse.pde.internal.ui.preferences.TargetEnvironmentPreferenceNode;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferenceNode;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PluginImportWizardFirstPage
extends WizardPage {
    private static String SETTINGS_IMPORTTYPE = "importType";
    private static String SETTINGS_DOOTHER = "doother";
    private static String SETTINGS_DROPLOCATION = "droplocation";
    private static String SETTINGS_SCAN_ALL = "scanAll";
    private Button runtimeLocationButton;
    private Button browseButton;
    private Label otherLocationLabel;
    private Combo dropLocation;
    private Button changeButton;
    private Button importButton;
    private Button scanButton;
    private Button binaryButton;
    private Button binaryWithLinksButton;
    private Button sourceButton;
    public static String TARGET_PLATFORM = "targetPlatform";
    private IPluginModelBase[] models = new IPluginModelBase[0];

    public PluginImportWizardFirstPage(String name) {
        super(name);
        this.setTitle(PDEPlugin.getResourceString("ImportWizard.FirstPage.title"));
        this.setMessage(PDEPlugin.getResourceString("ImportWizard.FirstPage.desc"));
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        this.createDirectoryGroup(container);
        this.createImportChoicesGroup(container);
        this.createImportOptionsGroup(container);
        Dialog.applyDialogFont((Control)container);
        this.initialize();
        this.setControl((Control)container);
    }

    private void createImportChoicesGroup(Composite container) {
        Group importChoices = new Group(container, 0);
        importChoices.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.importGroup"));
        importChoices.setLayout((Layout)new GridLayout());
        importChoices.setLayoutData((Object)new GridData(768));
        this.scanButton = new Button((Composite)importChoices, 16);
        this.scanButton.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.scanAll"));
        this.importButton = new Button((Composite)importChoices, 16);
        this.importButton.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.importPrereqs"));
    }

    private void createImportOptionsGroup(Composite container) {
        Group options = new Group(container, 0);
        options.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.importAs"));
        options.setLayout((Layout)new GridLayout());
        options.setLayoutData((Object)new GridData(768));
        this.binaryButton = new Button((Composite)options, 16);
        this.binaryButton.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.binary"));
        this.binaryWithLinksButton = new Button((Composite)options, 16);
        this.binaryWithLinksButton.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.binaryLinks"));
        this.sourceButton = new Button((Composite)options, 16);
        this.sourceButton.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.source"));
    }

    private void initialize() {
        IDialogSettings settings = this.getDialogSettings();
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < 6; ++i) {
            String curr = settings.get(SETTINGS_DROPLOCATION + String.valueOf(i));
            if (curr == null || items.contains(curr)) continue;
            items.add(curr);
        }
        this.dropLocation.setItems(items.toArray(new String[items.size()]));
        if (settings.getBoolean(SETTINGS_DOOTHER)) {
            this.runtimeLocationButton.setSelection(false);
            this.changeButton.setEnabled(false);
            this.dropLocation.setText(items.get(0).toString());
        } else {
            this.runtimeLocationButton.setSelection(true);
            this.otherLocationLabel.setEnabled(false);
            this.dropLocation.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.dropLocation.setText(this.getTargetHome());
        }
        int importType = ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("description.disableLinking") ? 1 : 2;
        try {
            importType = settings.getInt(SETTINGS_IMPORTTYPE);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (importType == 1) {
            this.binaryButton.setSelection(true);
        } else if (importType == 2) {
            this.binaryWithLinksButton.setSelection(true);
        } else {
            this.sourceButton.setSelection(true);
        }
        boolean scan = true;
        if (settings.get(SETTINGS_SCAN_ALL) != null) {
            scan = settings.getBoolean(SETTINGS_SCAN_ALL);
        }
        this.scanButton.setSelection(scan);
        this.importButton.setSelection(!scan);
    }

    private void createDirectoryGroup(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.importFrom"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.runtimeLocationButton = new Button((Composite)composite, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.runtimeLocationButton.setLayoutData((Object)gd);
        this.runtimeLocationButton.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.target"));
        this.runtimeLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = PluginImportWizardFirstPage.this.runtimeLocationButton.getSelection();
                if (selected) {
                    PluginImportWizardFirstPage.this.dropLocation.setText(PluginImportWizardFirstPage.this.getTargetHome());
                }
                PluginImportWizardFirstPage.this.otherLocationLabel.setEnabled(!selected);
                PluginImportWizardFirstPage.this.dropLocation.setEnabled(!selected);
                PluginImportWizardFirstPage.this.browseButton.setEnabled(!selected);
                PluginImportWizardFirstPage.this.changeButton.setEnabled(selected);
                PluginImportWizardFirstPage.this.validateDropLocation();
            }
        });
        this.changeButton = new Button((Composite)composite, 8);
        this.changeButton.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.goToTarget"));
        this.changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.handleChangeTargetPlatform();
            }
        });
        this.changeButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.changeButton);
        this.otherLocationLabel = new Label((Composite)composite, 0);
        this.otherLocationLabel.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.otherFolder"));
        this.dropLocation = new Combo((Composite)composite, 4);
        this.dropLocation.setLayoutData((Object)new GridData(768));
        this.dropLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PluginImportWizardFirstPage.this.validateDropLocation();
            }
        });
        this.browseButton = new Button((Composite)composite, 8);
        this.browseButton.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = PluginImportWizardFirstPage.this.chooseDropLocation();
                if (chosen != null) {
                    PluginImportWizardFirstPage.this.dropLocation.setText(chosen.toOSString());
                }
            }
        });
        this.browseButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.browseButton);
        Label label = new Label((Composite)composite, 0);
        label.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.source.label"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Button sourceLocations = new Button((Composite)composite, 8);
        sourceLocations.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.codeLocations"));
        sourceLocations.setLayoutData((Object)new GridData(128));
        sourceLocations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.handleSourceLocations();
            }
        });
        SWTUtil.setButtonDimensionHint(sourceLocations);
        sourceLocations.setLayoutData((Object)new GridData(256));
        label = new Label((Composite)composite, 64);
        label.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.variables"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Button envButton = new Button((Composite)composite, 8);
        envButton.setText(PDEPlugin.getResourceString("ImportWizard.FirstPage.env"));
        envButton.setLayoutData((Object)new GridData(896));
        envButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.handleEnvChange();
            }
        });
        SWTUtil.setButtonDimensionHint(envButton);
        envButton.setLayoutData((Object)new GridData(256));
    }

    private IPath chooseDropLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.dropLocation.getText());
        dialog.setText(PDEPlugin.getResourceString("ImportWizard.messages.folder.title"));
        dialog.setMessage(PDEPlugin.getResourceString("ImportWizard.messages.folder.message"));
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    private void handleChangeTargetPlatform() {
        TargetPlatformPreferenceNode targetNode = new TargetPlatformPreferenceNode();
        if (this.showPreferencePage(targetNode)) {
            this.dropLocation.setText(ExternalModelManager.getEclipseHome().toOSString());
        }
    }

    private void handleSourceLocations() {
        SourceCodeLocationsPreferenceNode sourceNode = new SourceCodeLocationsPreferenceNode();
        this.showPreferencePage(sourceNode);
    }

    private void handleEnvChange() {
        TargetEnvironmentPreferenceNode targetNode = new TargetEnvironmentPreferenceNode();
        this.showPreferencePage(targetNode);
    }

    private boolean showPreferencePage(final IPreferenceNode targetNode) {
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot(targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        final boolean[] result = new boolean[]{false};
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                dialog.setMessage(targetNode.getLabelText());
                if (dialog.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    private String getTargetHome() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        return preferences.getString("platform_path");
    }

    public boolean getScanAllPlugins() {
        return this.scanButton.getSelection();
    }

    public int getImportType() {
        if (this.binaryButton.getSelection()) {
            return 1;
        }
        if (this.binaryWithLinksButton.getSelection()) {
            return 2;
        }
        return 3;
    }

    public String getDropLocation() {
        return this.runtimeLocationButton.getSelection() ? TARGET_PLATFORM : this.dropLocation.getText().trim();
    }

    public void storeSettings() {
        boolean other;
        IDialogSettings settings = this.getDialogSettings();
        boolean bl = other = !this.runtimeLocationButton.getSelection();
        if (this.dropLocation.getText().length() > 0 && other) {
            settings.put(SETTINGS_DROPLOCATION + String.valueOf(0), this.dropLocation.getText().trim());
            String[] items = this.dropLocation.getItems();
            int nEntries = Math.min(items.length, 5);
            for (int i = 0; i < nEntries; ++i) {
                settings.put(SETTINGS_DROPLOCATION + String.valueOf(i + 1), items[i]);
            }
        }
        settings.put(SETTINGS_DOOTHER, other);
        settings.put(SETTINGS_IMPORTTYPE, this.getImportType());
        settings.put(SETTINGS_SCAN_ALL, this.getScanAllPlugins());
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    private void validateDropLocation() {
        if (!this.runtimeLocationButton.getSelection()) {
            Path curr = new Path(this.dropLocation.getText());
            if (curr.segmentCount() == 0 && curr.getDevice() == null) {
                this.setErrorMessage(PDEPlugin.getResourceString("ImportWizard.errors.locationMissing"));
                this.setPageComplete(false);
                return;
            }
            if (!Path.ROOT.isValidPath(this.dropLocation.getText())) {
                this.setErrorMessage(PDEPlugin.getResourceString("ImportWizard.errors.buildFolderInvalid"));
                this.setPageComplete(false);
                return;
            }
            if (!curr.toFile().isDirectory()) {
                this.setErrorMessage(PDEPlugin.getResourceString("ImportWizard.errors.buildFolderMissing"));
                this.setPageComplete(false);
                return;
            }
            if (!curr.equals(new Path(this.getTargetHome()))) {
                this.setErrorMessage(null);
                this.setMessage(PDEPlugin.getResourceString("ImportWizard.FirstPage.warning"), 2);
                this.setPageComplete(true);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.setMessage(PDEPlugin.getResourceString("ImportWizard.FirstPage.desc"));
    }

    private void resolveTargetPlatform() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                PluginImportWizardFirstPage.access$1102(PluginImportWizardFirstPage.this, PDECore.getDefault().getExternalModelManager().getAllModels());
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (Throwable e) {
            PDEPlugin.logException(e);
        }
    }

    private void resolveArbitraryLocation(final String location) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                File[] files = new File[]{new File(location), new File(location, "plugins")};
                URL[] urls = PluginPathFinder.scanLocations((File[])files);
                PluginImportWizardFirstPage.access$1102(PluginImportWizardFirstPage.this, TargetPlatformRegistryLoader.loadModels((URL[])urls, (boolean)false, (IProgressMonitor)monitor));
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (Throwable e) {
            PDEPlugin.logException(e);
        }
    }

    public IPluginModelBase[] getModels() {
        String dropLocation = this.getDropLocation();
        if (dropLocation.equals(TARGET_PLATFORM)) {
            this.resolveTargetPlatform();
        } else {
            this.resolveArbitraryLocation(dropLocation);
        }
        return this.models;
    }

    static /* synthetic */ IPluginModelBase[] access$1102(PluginImportWizardFirstPage x0, IPluginModelBase[] x1) {
        x0.models = x1;
        return x1;
    }
}

