/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryField;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ClassFileInfo;
import org.eclipse.jdt.internal.core.CompletionRequestorWrapper;
import org.eclipse.jdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.Initializer;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;

public class BinaryType
extends BinaryMember
implements IType,
SuffixConstants {
    private static final IField[] NO_FIELDS = new IField[0];
    private static final IMethod[] NO_METHODS = new IMethod[0];
    private static final IType[] NO_TYPES = new IType[0];
    private static final IInitializer[] NO_INITIALIZERS = new IInitializer[0];
    private static final String[] NO_STRINGS = new String[0];

    protected BinaryType(JavaElement parent, String name) {
        super(parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
    }

    protected void closing(Object info) throws JavaModelException {
        ClassFileInfo cfi = this.getClassFileInfo();
        cfi.removeBinaryChildren();
    }

    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, ICompletionRequestor requestor) throws JavaModelException {
        this.codeComplete(snippet, insertion, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic, requestor, DefaultWorkingCopyOwner.PRIMARY);
    }

    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, ICompletionRequestor requestor, WorkingCopyOwner owner) throws JavaModelException {
        CompletionEngine engine;
        if (requestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        JavaProject project = (JavaProject)this.getJavaProject();
        SearchableEnvironment environment = (SearchableEnvironment)project.newSearchableNameEnvironment(owner);
        CompletionRequestorWrapper requestorWrapper = new CompletionRequestorWrapper(requestor, environment.nameLookup);
        requestorWrapper.completionEngine = engine = new CompletionEngine(environment, requestorWrapper, project.getOptions(true), project);
        String source = this.getClassFile().getSource();
        if (source != null && insertion > -1 && insertion < source.length()) {
            char[] prefix = CharOperation.concat(source.substring(0, insertion).toCharArray(), new char[]{'{'});
            char[] suffix = CharOperation.concat(new char[]{'}'}, source.substring(insertion).toCharArray());
            char[] fakeSource = CharOperation.concat(prefix, snippet, suffix);
            BasicCompilationUnit cu = new BasicCompilationUnit(fakeSource, (char[][])null, this.getElementName(), project);
            engine.complete(cu, prefix.length + position, prefix.length);
        } else {
            engine.complete(this, snippet, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic);
        }
    }

    public IField createField(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public IInitializer createInitializer(String contents, IJavaElement sibling, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public IMethod createMethod(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public IType createType(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinaryType)) {
            return false;
        }
        return super.equals(o);
    }

    public IMethod[] findMethods(IMethod method) {
        try {
            return this.findMethods(method, this.getMethods());
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJavaElement[] getChildren() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        ClassFileInfo cfi = this.getClassFileInfo();
        if (cfi.binaryChildren == null) {
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            boolean hadTemporaryCache = manager.hasTemporaryCache();
            try {
                Object info = manager.getInfo(this);
                HashMap newElements = manager.getTemporaryCache();
                cfi.readBinaryChildren(newElements, (IBinaryType)info);
                if (!hadTemporaryCache) {
                    manager.putInfos(this, newElements);
                }
            }
            finally {
                if (!hadTemporaryCache) {
                    manager.resetTemporaryCache();
                }
            }
        }
        return cfi.binaryChildren;
    }

    protected ClassFileInfo getClassFileInfo() throws JavaModelException {
        ClassFile cf = (ClassFile)this.parent;
        return (ClassFileInfo)cf.getElementInfo();
    }

    public IType getDeclaringType() {
        IClassFile classFile = this.getClassFile();
        if (classFile.isOpen()) {
            try {
                char[] enclosingTypeName = ((IBinaryType)this.getElementInfo()).getEnclosingTypeName();
                if (enclosingTypeName == null) {
                    return null;
                }
                enclosingTypeName = ClassFile.unqualifiedName(enclosingTypeName);
                if (classFile.getElementName().length() > enclosingTypeName.length + 1 && Character.isDigit(classFile.getElementName().charAt(enclosingTypeName.length + 1))) {
                    return null;
                }
                return this.getPackageFragment().getClassFile(new String(enclosingTypeName) + ".class").getType();
            }
            catch (JavaModelException npe) {
                return null;
            }
        }
        String classFileName = classFile.getElementName();
        int lastDollar = -1;
        int length = classFileName.length();
        for (int i = 0; i < length; ++i) {
            char c = classFileName.charAt(i);
            if (Character.isDigit(c) && lastDollar == i - 1) {
                return null;
            }
            if (c != '$') continue;
            lastDollar = i;
        }
        if (lastDollar == -1) {
            return null;
        }
        String enclosingName = classFileName.substring(0, lastDollar);
        String enclosingClassFileName = enclosingName + ".class";
        return new BinaryType((JavaElement)((Object)this.getPackageFragment().getClassFile(enclosingClassFileName)), enclosingName.substring(enclosingName.lastIndexOf(36) + 1));
    }

    public int getElementType() {
        return 7;
    }

    public IField getField(String fieldName) {
        return new BinaryField(this, fieldName);
    }

    public IField[] getFields() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(8);
        int size = list.size();
        if (size == 0) {
            return NO_FIELDS;
        }
        IField[] array = new IField[size];
        list.toArray(array);
        return array;
    }

    public int getFlags() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.getModifiers();
    }

    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName('$');
    }

    public String getFullyQualifiedName(char enclosingTypeSeparator) {
        String packageName = this.getPackageFragment().getElementName();
        if (packageName.equals("")) {
            return this.getTypeQualifiedName(enclosingTypeSeparator);
        }
        return packageName + '.' + this.getTypeQualifiedName(enclosingTypeSeparator);
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '^': {
                String fieldName = memento.nextToken();
                JavaElement field = (JavaElement)((Object)this.getField(fieldName));
                return field.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '|': {
                String count = memento.nextToken();
                JavaElement initializer = (JavaElement)((Object)this.getInitializer(Integer.parseInt(count)));
                return initializer.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '~': {
                String selector = memento.nextToken();
                ArrayList<String> params = new ArrayList<String>();
                block14: while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    switch (token.charAt(0)) {
                        case '[': {
                            break block14;
                        }
                        case '~': {
                            String param = memento.nextToken();
                            StringBuffer buffer = new StringBuffer();
                            while ('[' == param.charAt(0)) {
                                buffer.append('[');
                                param = memento.nextToken();
                            }
                            params.add(buffer.toString() + param);
                            continue block14;
                        }
                    }
                }
                String[] parameters = new String[params.size()];
                params.toArray(parameters);
                JavaElement method = (JavaElement)((Object)this.getMethod(selector, parameters));
                if (token != null) {
                    switch (token.charAt(0)) {
                        case '@': 
                        case '[': {
                            return method.getHandleFromMemento(token, memento, workingCopyOwner);
                        }
                    }
                    return method;
                }
                return method;
            }
            case '[': {
                String typeName;
                if (memento.hasMoreTokens()) {
                    typeName = memento.nextToken();
                    char firstChar = typeName.charAt(0);
                    if (firstChar == '^' || firstChar == '|' || firstChar == '~' || firstChar == '[' || firstChar == '!') {
                        token = typeName;
                        typeName = "";
                    } else {
                        token = null;
                    }
                } else {
                    typeName = "";
                    token = null;
                }
                JavaElement type = (JavaElement)((Object)this.getType(typeName));
                if (token == null) {
                    return type.getHandleFromMemento(memento, workingCopyOwner);
                }
                return type.getHandleFromMemento(token, memento, workingCopyOwner);
            }
        }
        return null;
    }

    public IInitializer getInitializer(int count) {
        return new Initializer((JavaElement)this, count);
    }

    public IInitializer[] getInitializers() {
        return NO_INITIALIZERS;
    }

    public IMethod getMethod(String selector, String[] parameterTypeSignatures) {
        return new BinaryMethod(this, selector, parameterTypeSignatures);
    }

    public IMethod[] getMethods() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(9);
        int size = list.size();
        if (size == 0) {
            return NO_METHODS;
        }
        IMethod[] array = new IMethod[size];
        list.toArray(array);
        return array;
    }

    public IPackageFragment getPackageFragment() {
        for (IJavaElement parentElement = this.parent; parentElement != null; parentElement = parentElement.getParent()) {
            if (parentElement.getElementType() != 4) continue;
            return (IPackageFragment)parentElement;
        }
        Assert.isTrue(false);
        return null;
    }

    public String getSuperclassTypeSignature() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        char[] superclassName = info.getSuperclassName();
        if (superclassName == null) {
            return null;
        }
        return new String(Signature.createTypeSignature(ClassFile.translatedName(superclassName), true));
    }

    public String getSuperclassName() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        char[] superclassName = info.getSuperclassName();
        if (superclassName == null) {
            return null;
        }
        return new String(ClassFile.translatedName(superclassName));
    }

    public String[] getSuperInterfaceNames() throws JavaModelException {
        int length;
        IBinaryType info = (IBinaryType)this.getElementInfo();
        char[][] names = info.getInterfaceNames();
        if (names == null || (length = names.length) == 0) {
            return NO_STRINGS;
        }
        names = ClassFile.translatedNames(names);
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = new String(names[i]);
        }
        return strings;
    }

    public String[] getSuperInterfaceTypeSignatures() throws JavaModelException {
        int length;
        IBinaryType info = (IBinaryType)this.getElementInfo();
        char[][] names = info.getInterfaceNames();
        if (names == null || (length = names.length) == 0) {
            return NO_STRINGS;
        }
        names = ClassFile.translatedNames(names);
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = new String(Signature.createTypeSignature(names[i], true));
        }
        return strings;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        return new String[0];
    }

    public IType getType(String typeName) {
        IClassFile classFile = this.getPackageFragment().getClassFile(this.getTypeQualifiedName() + "$" + typeName + ".class");
        return new BinaryType((JavaElement)((Object)classFile), typeName);
    }

    public String getTypeQualifiedName() {
        return this.getTypeQualifiedName('$');
    }

    public String getTypeQualifiedName(char enclosingTypeSeparator) {
        IType declaringType = this.getDeclaringType();
        if (declaringType == null) {
            String classFileName = this.getClassFile().getElementName();
            if (classFileName.indexOf(36) == -1) {
                return this.name;
            }
            return classFileName.substring(0, classFileName.lastIndexOf(46));
        }
        return declaringType.getTypeQualifiedName(enclosingTypeSeparator) + enclosingTypeSeparator + this.name;
    }

    public IType[] getTypes() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(7);
        int size = list.size();
        if (size == 0) {
            return NO_TYPES;
        }
        IType[] array = new IType[size];
        list.toArray(array);
        return array;
    }

    public boolean isAnonymous() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.isAnonymous();
    }

    public boolean isClass() throws JavaModelException {
        return !this.isInterface();
    }

    public boolean isEnum() throws JavaModelException {
        return false;
    }

    public boolean isInterface() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.isInterface();
    }

    public boolean isAnnotation() throws JavaModelException {
        return false;
    }

    public boolean isLocal() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.isLocal();
    }

    public boolean isMember() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.isMember();
    }

    public ITypeHierarchy loadTypeHierachy(InputStream input, IProgressMonitor monitor) throws JavaModelException {
        return this.loadTypeHierachy(input, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy loadTypeHierachy(InputStream input, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        return TypeHierarchy.load(this, input, owner);
    }

    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        return this.newSupertypeHierarchy(DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy newSupertypeHierarchy(ICompilationUnit[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), false);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newSupertypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] copies;
        if (workingCopies == null) {
            copies = null;
        } else {
            int length = workingCopies.length;
            copies = new ICompilationUnit[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        }
        return this.newSupertypeHierarchy(copies, monitor);
    }

    public ITypeHierarchy newSupertypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), false);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        return this.newTypeHierarchy(project, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(IJavaProject project, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        if (project == null) {
            throw new IllegalArgumentException(Util.bind("hierarchy.nullProject"));
        }
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        ICompilationUnit[] projectWCs = null;
        if (workingCopies != null) {
            int length = workingCopies.length;
            projectWCs = new ICompilationUnit[length];
            int index = 0;
            for (int i = 0; i < length; ++i) {
                ICompilationUnit wc = workingCopies[i];
                if (!project.equals(wc.getJavaProject())) continue;
                projectWCs[index++] = wc;
            }
            if (index != length) {
                ICompilationUnit[] iCompilationUnitArray = projectWCs;
                projectWCs = new ICompilationUnit[index];
                System.arraycopy(iCompilationUnitArray, 0, projectWCs, 0, index);
            }
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, projectWCs, project, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        return this.newTypeHierarchy((IWorkingCopy[])null, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(ICompilationUnit[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] copies;
        if (workingCopies == null) {
            copies = null;
        } else {
            int length = workingCopies.length;
            copies = new ICompilationUnit[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        }
        return this.newTypeHierarchy(copies, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public String[][] resolveType(String typeName) {
        return null;
    }

    public String[][] resolveType(String typeName, WorkingCopyOwner owner) {
        return null;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                if (this.isInterface()) {
                    buffer.append("interface ");
                } else {
                    buffer.append("class ");
                }
                this.toStringName(buffer);
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

