/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;

public class SearchResults
implements ISearchHitCollector {
    private ArrayList scopes;
    private int maxHits;
    private String locale;
    protected SearchHit[] searchHits = new SearchHit[0];
    static /* synthetic */ Class class$org$eclipse$help$IToc;

    public SearchResults(WorkingSet[] workingSets, int maxHits, String locale) {
        this.maxHits = maxHits;
        this.locale = locale;
        this.scopes = this.getScopes(workingSets);
    }

    public void addHits(Hits hits, String highlightTerms) {
        String urlEncodedWords = URLCoder.encode((String)highlightTerms);
        ArrayList<SearchHit> searchHitList = new ArrayList<SearchHit>();
        float scoreScale = 1.0f;
        boolean scoreScaleSet = false;
        for (int h = 0; h < hits.length() && h < this.maxHits; ++h) {
            ITopic t;
            float score;
            Document doc;
            try {
                doc = hits.doc(h);
                score = hits.score(h);
            }
            catch (IOException ioe) {
                continue;
            }
            String href = doc.get("name");
            IToc toc = null;
            AdaptableHelpResource scope = null;
            if (this.scopes == null) {
                toc = this.getTocForTopic(href, this.locale);
            } else {
                scope = this.getScopeForTopic(href);
                if (scope == null) continue;
                toc = scope instanceof AdaptableToc ? (IToc)scope.getAdapter(class$org$eclipse$help$IToc == null ? SearchResults.class$("org.eclipse.help.IToc") : class$org$eclipse$help$IToc) : (IToc)scope.getParent().getAdapter(class$org$eclipse$help$IToc == null ? SearchResults.class$("org.eclipse.help.IToc") : class$org$eclipse$help$IToc);
            }
            if (!scoreScaleSet) {
                if (score > 0.0f) {
                    scoreScale = 0.99f / score;
                    score = 1.0f;
                }
                scoreScaleSet = true;
            } else {
                score = score * scoreScale + 0.01f;
            }
            String label = doc.get("raw_title");
            if ("".equals(label) && toc != null && (t = scope != null ? scope.getTopic(href) : toc.getTopic(href)) != null) {
                label = t.getLabel();
            }
            if (label == null || "".equals(label)) {
                label = href;
            }
            href = href + "?resultof=" + urlEncodedWords;
            searchHitList.add(new SearchHit(href, label, score, toc));
        }
        this.searchHits = searchHitList.toArray(new SearchHit[searchHitList.size()]);
    }

    private AdaptableHelpResource getScopeForTopic(String href) {
        for (int i = 0; i < this.scopes.size(); ++i) {
            AdaptableHelpResource scope = (AdaptableHelpResource)this.scopes.get(i);
            if (scope.getTopic(href) == null) continue;
            return scope;
        }
        return null;
    }

    private IToc getTocForTopic(String href, String locale) {
        ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        for (int i = 0; i < tocs.length; ++i) {
            ITopic topic = tocs[i].getTopic(href);
            if (topic == null) continue;
            return tocs[i];
        }
        return null;
    }

    public SearchHit[] getSearchHits() {
        return this.searchHits;
    }

    private ArrayList getScopes(WorkingSet[] wSets) {
        if (wSets == null) {
            return null;
        }
        this.scopes = new ArrayList(wSets.length);
        for (int w = 0; w < wSets.length; ++w) {
            AdaptableHelpResource[] elements = wSets[w].getElements();
            for (int i = 0; i < elements.length; ++i) {
                this.scopes.add(elements[i]);
            }
        }
        return this.scopes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

