/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.appserver;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.appserver.AppserverPlugin;
import org.eclipse.help.internal.appserver.AppserverResources;
import org.eclipse.help.internal.appserver.IWebappServer;
import org.eclipse.help.internal.appserver.PluginClassLoaderWrapper;
import org.osgi.framework.Bundle;

public class WebappManager {
    private static boolean applicationsStarted = false;

    private WebappManager() {
    }

    public static void start(String webappName, String pluginId, IPath path) throws CoreException {
        IPath webappPath = WebappManager.getWebappPath(pluginId, path);
        IWebappServer server = AppserverPlugin.getDefault().getAppServer();
        applicationsStarted = true;
        server.start(webappName, webappPath, new PluginClassLoaderWrapper(pluginId));
    }

    public static void stop(String webappName) throws CoreException {
        if (!applicationsStarted) {
            return;
        }
        AppserverPlugin.getDefault().getAppServer().stop(webappName);
    }

    public static int getPort() {
        try {
            return AppserverPlugin.getDefault().getAppServer().getPort();
        }
        catch (CoreException e) {
            return 0;
        }
    }

    public static String getHost() {
        try {
            return AppserverPlugin.getDefault().getAppServer().getHost();
        }
        catch (CoreException e) {
            return null;
        }
    }

    private static IPath getWebappPath(String pluginId, IPath path) throws CoreException {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.help.appserver", 0, AppserverResources.getString("Appserver.cannotFindPlugin", pluginId), null));
        }
        URL webappURL = Platform.find((Bundle)bundle, (IPath)path);
        if (webappURL == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.help.appserver", 0, AppserverResources.getString("Appserver.cannotFindPath", pluginId, path.toOSString()), null));
        }
        try {
            String webappLocation = Platform.asLocalURL((URL)Platform.resolve((URL)webappURL)).getFile();
            return new Path(webappLocation);
        }
        catch (IOException ioe) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.help.appserver", 0, AppserverResources.getString("Appserver.cannotResolvePath", pluginId, path.toOSString()), (Throwable)ioe));
        }
    }
}

