/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.code.PromoteTempToFieldRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.PromoteTempWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConvertLocalToFieldAction
extends SelectionDispatchAction {
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.getString("ConvertLocalToField.title");
    private final CompilationUnitEditor fEditor;

    public ConvertLocalToFieldAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.getString("ConvertLocalToField.label"));
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.promote_temp_to_field_action");
    }

    private static PromoteTempToFieldRefactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) {
        return PromoteTempToFieldRefactoring.create(cunit, selection.getOffset(), selection.getLength(), JavaPreferencesSettings.getCodeGenerationSettings());
    }

    private static RefactoringWizard createWizard(PromoteTempToFieldRefactoring refactoring) {
        return new PromoteTempWizard(refactoring);
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(ITextSelection selection) {
        return this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null;
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof ILocalVariable && PromoteTempToFieldRefactoring.isAvailable((ILocalVariable)elements[0]);
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            PromoteTempToFieldRefactoring refactoring = ConvertLocalToFieldAction.createRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection);
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, ConvertLocalToFieldAction.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }
}

