/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class WorkingSetMenuContributionItem
extends ContributionItem {
    private int fId;
    private IWorkingSet fWorkingSet;
    private WorkingSetFilterActionGroup fActionGroup;
    private Image fImage;
    static /* synthetic */ Class class$org$eclipse$jdt$internal$ui$workingsets$WorkingSetMenuContributionItem;

    public WorkingSetMenuContributionItem(int id, WorkingSetFilterActionGroup actionGroup, IWorkingSet workingSet) {
        super(WorkingSetMenuContributionItem.getId(id));
        Assert.isNotNull((Object)((Object)actionGroup));
        Assert.isNotNull((Object)workingSet);
        this.fId = id;
        this.fActionGroup = actionGroup;
        this.fWorkingSet = workingSet;
    }

    public void fill(Menu menu, int index) {
        MenuItem mi = new MenuItem(menu, 16, index);
        mi.setText("&" + this.fId + " " + this.fWorkingSet.getName());
        if (this.fImage == null) {
            this.fImage = this.fWorkingSet.getImage().createImage();
        }
        mi.setImage(this.fImage);
        mi.setSelection(this.fWorkingSet.equals(this.fActionGroup.getWorkingSet()));
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
                WorkingSetMenuContributionItem.this.fActionGroup.setWorkingSet(WorkingSetMenuContributionItem.this.fWorkingSet, true);
                manager.addRecentWorkingSet(WorkingSetMenuContributionItem.this.fWorkingSet);
            }
        });
    }

    public void dispose() {
        if (this.fImage != null && !this.fImage.isDisposed()) {
            this.fImage.dispose();
        }
        this.fImage = null;
        super.dispose();
    }

    public boolean isDynamic() {
        return true;
    }

    static String getId(int id) {
        return (class$org$eclipse$jdt$internal$ui$workingsets$WorkingSetMenuContributionItem == null ? (class$org$eclipse$jdt$internal$ui$workingsets$WorkingSetMenuContributionItem = WorkingSetMenuContributionItem.class$("org.eclipse.jdt.internal.ui.workingsets.WorkingSetMenuContributionItem")) : class$org$eclipse$jdt$internal$ui$workingsets$WorkingSetMenuContributionItem).getName() + "." + id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

