/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class CheckoutProjectOperation
extends CheckoutOperation {
    private String targetLocation;

    public CheckoutProjectOperation(IWorkbenchPart part, ICVSRemoteFolder[] remoteFolders, String targetLocation) {
        super(part, remoteFolders);
        this.targetLocation = targetLocation;
    }

    protected void createAndOpenProject(IProject project, IProgressMonitor monitor) throws CVSException {
        try {
            monitor.beginTask(null, 5);
            IProjectDescription desc = this.getDescriptionFor(project);
            if (project.exists()) {
                if (desc != null) {
                    project.move(desc, true, Policy.subMonitorFor(monitor, 3));
                }
            } else if (desc == null) {
                project.create(Policy.subMonitorFor(monitor, 3));
            } else {
                project.create(desc, Policy.subMonitorFor(monitor, 3));
            }
            if (!project.isOpen()) {
                project.open(Policy.subMonitorFor(monitor, 2));
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
        finally {
            monitor.done();
        }
    }

    protected IProjectDescription getDescriptionFor(IProject project) {
        if (this.targetLocation == null) {
            return null;
        }
        String projectName = project.getName();
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        description.setLocation(this.getTargetLocationFor(project));
        return description;
    }

    protected IPath getTargetLocationFor(IProject project) {
        if (this.targetLocation == null) {
            return null;
        }
        return new Path(this.targetLocation);
    }

    protected String getRemoteModuleName(ICVSRemoteFolder resource) {
        String moduleName = resource.isDefinedModule() ? resource.getName() : resource.getRepositoryRelativePath();
        return moduleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus checkout(final ICVSRemoteFolder resource, IProject project, IProgressMonitor pm) throws CVSException {
        ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        ICVSRepositoryLocation repository = resource.getRepository();
        final Session session = new Session(repository, root);
        pm.beginTask(null, 100);
        Policy.checkCanceled(pm);
        session.open(Policy.subMonitorFor(pm, 5), false);
        try {
            IProject[] targetProjects;
            if (project == null && resource.getName().equals(".")) {
                String name = new Path(resource.getRepository().getRootDirectory()).lastSegment();
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            }
            if ((targetProjects = this.determineProjects(session, resource, project, Policy.subMonitorFor(pm, 5))) == null) {
                IStatus iStatus = this.getLastError();
                return iStatus;
            }
            if (targetProjects.length == 0) {
                IStatus iStatus = OK;
                return iStatus;
            }
            final boolean sendModuleName = project != null;
            final IStatus[] result = new IStatus[]{null};
            ISchedulingRule schedulingRule = this.getSchedulingRule(targetProjects);
            if (schedulingRule instanceof IResource && ((IResource)schedulingRule).getType() == 8) {
                try {
                    Platform.getJobManager().beginRule(schedulingRule, pm);
                    result[0] = this.performCheckout(session, resource, targetProjects, sendModuleName, Policy.subMonitorFor(pm, 90));
                }
                finally {
                    Platform.getJobManager().endRule(schedulingRule);
                }
            } else {
                EclipseSynchronizer.getInstance().run(schedulingRule, new ICVSRunnable(){

                    public void run(IProgressMonitor monitor) throws CVSException {
                        result[0] = CheckoutProjectOperation.this.performCheckout(session, resource, targetProjects, sendModuleName, monitor);
                    }
                }, Policy.subMonitorFor(pm, 90));
            }
            IStatus iStatus = result[0];
            return iStatus;
        }
        catch (CVSException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            session.close();
            pm.done();
        }
    }

    private ISchedulingRule getSchedulingRule(IProject[] projects) {
        if (projects.length == 1) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)projects[0]);
        }
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        for (int i = 0; i < projects.length; ++i) {
            ISchedulingRule modifyRule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)projects[i]);
            if (modifyRule instanceof IResource && ((IResource)modifyRule).getType() == 8) {
                return modifyRule;
            }
            rules.add(modifyRule);
        }
        return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IStatus performCheckout(Session session, ICVSRemoteFolder resource, IProject[] targetProjects, boolean sendModuleName, IProgressMonitor pm) throws CVSException {
        String taskName = targetProjects.length == 1 ? Policy.bind("CheckoutProjectOperation.8", resource.getName(), targetProjects[0].getName()) : Policy.bind("CheckoutProjectOperation.9", resource.getName(), String.valueOf(targetProjects.length));
        pm.beginTask(taskName, 100);
        pm.setTaskName(taskName);
        Policy.checkCanceled(pm);
        try {
            IStatus result;
            if (this.performScrubProjects() && !(result = this.scrubProjects(resource, targetProjects, Policy.subMonitorFor(pm, 9))).isOK()) {
                IStatus iStatus = result;
                return iStatus;
            }
            IProject project = null;
            if (targetProjects.length == 1) {
                String path;
                if (sendModuleName) {
                    project = targetProjects[0];
                } else if (targetProjects[0].getName().equals(resource.getName()) && !(path = resource.getRepositoryRelativePath()).equals("CVSROOT/Emptydir") && new Path(path).segmentCount() > 1) {
                    project = targetProjects[0];
                }
            }
            try {
                CVSTag tag;
                ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
                if (project != null) {
                    localOptions.add(Checkout.makeDirectoryNameOption((String)project.getName()));
                }
                if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
                    localOptions.add(Checkout.PRUNE_EMPTY_DIRECTORIES);
                }
                if ((tag = resource.getTag()) == null) {
                    tag = CVSTag.DEFAULT;
                }
                localOptions.add(Update.makeTagOption((CVSTag)tag));
                IStatus status = Command.CHECKOUT.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new String[]{this.getRemoteModuleName(resource)}, null, Policy.subMonitorFor(pm, 90));
                if (status.getCode() == -10) {
                    IStatus iStatus = status;
                    return iStatus;
                }
            }
            finally {
                this.refreshProjects(targetProjects, Policy.subMonitorFor(pm, 1));
            }
            IStatus iStatus = OK;
            return iStatus;
        }
        finally {
            pm.done();
        }
    }

    private IProject[] determineProjects(Session session, ICVSRemoteFolder remoteFolder, IProject project, IProgressMonitor pm) throws CVSException {
        HashSet<IProject> targetProjectSet = new HashSet<IProject>();
        String moduleName = this.getRemoteModuleName(remoteFolder);
        if (project == null) {
            Policy.checkCanceled(pm);
            IStatus status = Request.EXPAND_MODULES.execute(session, new String[]{moduleName}, pm);
            if (status.getCode() == -10) {
                this.collectStatus(status);
                return null;
            }
            String[] expansions = session.getModuleExpansions();
            if (expansions.length == 1 && expansions[0].equals(moduleName)) {
                String lastSegment = new Path(expansions[0]).lastSegment();
                targetProjectSet.add(ResourcesPlugin.getWorkspace().getRoot().getProject(lastSegment));
            } else {
                for (int j = 0; j < expansions.length; ++j) {
                    targetProjectSet.add(ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(expansions[j]).segment(0)));
                }
            }
        } else {
            targetProjectSet.add(project);
        }
        IProject[] targetProjects = targetProjectSet.toArray(new IProject[targetProjectSet.size()]);
        return targetProjects;
    }

    protected boolean performScrubProjects() {
        return true;
    }

    private IStatus scrubProjects(ICVSRemoteFolder remoteFolder, IProject[] projects, IProgressMonitor monitor) throws CVSException {
        IProject project;
        int i;
        if (projects == null) {
            monitor.done();
            return OK;
        }
        if (projects.length > 1) {
            this.setInvolvesMultipleResources(true);
        }
        for (i = 0; i < projects.length; ++i) {
            project = projects[i];
            Policy.checkCanceled(monitor);
            if (!this.needsPromptForOverwrite(project) || this.promptToOverwrite(remoteFolder, project)) continue;
            return new CVSStatus(1, 8, Policy.bind("CheckoutProjectOperation.0", remoteFolder.getRepositoryRelativePath()));
        }
        monitor.beginTask(null, projects.length * 100);
        for (i = 0; i < projects.length; ++i) {
            project = projects[i];
            this.createAndOpenProject(project, Policy.subMonitorFor(monitor, 10));
            this.scrubProject(project, Policy.subMonitorFor(monitor, 90));
        }
        monitor.done();
        return OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrubProject(IProject project, IProgressMonitor monitor) throws CVSException {
        try {
            if (RepositoryProvider.getProvider((IProject)project) != null) {
                RepositoryProvider.unmap((IProject)project);
            }
            IResource[] children = project.members(2);
            Policy.checkCanceled(monitor);
            monitor.beginTask(null, 100 + children.length * 100);
            monitor.subTask(Policy.bind("CheckoutOperation.scrubbingProject", project.getName()));
            try {
                for (int j = 0; j < children.length; ++j) {
                    if (children[j].getName().equals(".project")) continue;
                    children[j].delete(true, Policy.subMonitorFor(monitor, 100));
                }
                EclipseSynchronizer.getInstance().flush((IContainer)project, true, Policy.subMonitorFor(monitor, 100));
            }
            finally {
                monitor.done();
            }
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
    }

    protected boolean needsPromptForOverwrite(IProject project) {
        File localLocation;
        IProjectDescription desc = this.getDescriptionFor(project);
        if (desc != null && (localLocation = desc.getLocation().toFile()).exists()) {
            return true;
        }
        if (project.exists()) {
            return true;
        }
        localLocation = this.getFileLocation(project);
        return localLocation.exists();
    }

    protected File getFileLocation(IProject project) {
        return new File(project.getParent().getLocation().toFile(), project.getName());
    }

    private boolean promptToOverwrite(ICVSRemoteFolder remoteFolder, IProject project) {
        if (project.exists() && !this.promptToOverwrite(Policy.bind("CheckoutOperation.confirmOverwrite"), Policy.bind("CheckoutOperation.thisResourceExists", project.getName(), this.getRemoteModuleName(remoteFolder)))) {
            return false;
        }
        IPath path = this.getTargetLocationFor(project);
        File localLocation = null;
        if (path == null) {
            try {
                if (!project.exists() || !project.isOpen() || project.getDescription().getLocation() != null) {
                    localLocation = this.getFileLocation(project);
                }
            }
            catch (CoreException e) {
                CVSUIPlugin.log(e);
            }
        } else {
            localLocation = path.toFile();
        }
        if (localLocation != null && localLocation.exists()) {
            try {
                return this.promptToOverwrite(Policy.bind("CheckoutOperation.confirmOverwrite"), Policy.bind("CheckoutOperation.thisExternalFileExists", localLocation.getCanonicalPath(), this.getRemoteModuleName(remoteFolder)));
            }
            catch (IOException e) {
                CVSUIPlugin.log((CoreException)((Object)CVSException.wrapException((Exception)e)));
            }
        }
        return true;
    }

    protected String getOverwritePromptMessage(ICVSRemoteFolder remoteFolder, IProject project) {
        if (project.exists()) {
            return Policy.bind("CheckoutOperation.thisResourceExists", project.getName(), this.getRemoteModuleName(remoteFolder));
        }
        return Policy.bind("CheckoutOperation.thisExternalFileExists", project.getName(), this.getRemoteModuleName(remoteFolder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshProjects(IProject[] projects, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, projects.length * 100);
        try {
            for (int i = 0; i < projects.length; ++i) {
                IProject project = projects[i];
                try {
                    monitor.subTask(Policy.bind("CheckoutOperation.refreshingProject", project.getName()));
                    ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
                    if (folder.isCVSFolder()) {
                        RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
                    }
                }
                catch (TeamException e) {
                    throw CVSException.wrapException((CoreException)((Object)e));
                }
                CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                if (provider == null) continue;
                provider.setWatchEditEnabled(CVSProviderPlugin.getPlugin().isWatchEditEnabled());
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getTaskName() {
        ICVSRemoteFolder[] remoteFolders = this.getRemoteFolders();
        if (remoteFolders.length == 1) {
            return Policy.bind("CheckoutSingleProjectOperation.taskname", remoteFolders[0].getName());
        }
        return Policy.bind("CheckoutMultipleProjectsOperation.taskName", new Integer(remoteFolders.length).toString());
    }
}

