/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.util.Stack;
import java.util.Vector;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.PluginParent;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionsParser
extends DefaultHandler {
    private Vector fExtensions;
    private Vector fExtensionPoints = new Vector();
    private Stack fOpenElements;
    private Locator fLocator;
    private boolean fIsLegacy = true;
    private ISharedPluginModel fModel;

    public ExtensionsParser(ISharedPluginModel model) {
        this.fExtensions = new Vector();
        this.fModel = model;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if ("eclipse".equals(target)) {
            this.fIsLegacy = false;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.fOpenElements == null) {
            if (qName.equals("plugin") || qName.equals("fragment")) {
                this.fOpenElements = new Stack();
            }
        } else if (this.fOpenElements.size() == 0) {
            if (qName.equals("extension")) {
                this.createExtension(attributes);
            } else if (qName.equals("extension-point")) {
                this.createExtensionPoint(attributes);
            }
        } else {
            this.createElement(qName, attributes);
        }
    }

    private void createExtension(Attributes attributes) {
        PluginExtension extension = new PluginExtension();
        if (extension.load(attributes, this.fLocator.getLineNumber())) {
            extension.setModel(this.fModel);
            extension.setInTheModel(true);
            this.fExtensions.add(extension);
            String point = extension.getPoint();
            if ("org.eclipse.pde.core.source".equals(point) || "org.eclipse.core.runtime.products".equals(point)) {
                this.fOpenElements.push(extension);
            }
        }
    }

    private void createExtensionPoint(Attributes attributes) {
        PluginExtensionPoint extPoint = new PluginExtensionPoint();
        if (extPoint.load(attributes, this.fLocator.getLineNumber())) {
            extPoint.setModel(this.fModel);
            extPoint.setInTheModel(true);
            this.fExtensionPoints.add(extPoint);
        }
    }

    private void createElement(String tagName, Attributes attributes) {
        PluginElement element = new PluginElement();
        PluginParent parent = (PluginParent)this.fOpenElements.peek();
        element.setParent(parent);
        element.setInTheModel(true);
        element.setModel(this.fModel);
        element.load(tagName, attributes);
        parent.appendChild(element);
        this.fOpenElements.push(element);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.fOpenElements != null && !this.fOpenElements.isEmpty()) {
            this.fOpenElements.pop();
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public boolean isLegacy() {
        return this.fIsLegacy;
    }

    public Vector getExtensions() {
        return this.fExtensions;
    }

    public Vector getExtensionPoints() {
        return this.fExtensionPoints;
    }
}

