/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.layout.CellData;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.internal.layout.CellLayoutUtil;

class GridInfo {
    private int cols = 0;
    private int rows = 0;
    private int[] gridInfo;
    int[] controlRow;
    int[] controlCol;
    private CellData[] cellData;
    Control[] controls;

    GridInfo() {
    }

    public void initGrid(Control[] newControls, CellLayout layout) {
        int idx;
        this.cols = layout.getColumns();
        this.controls = newControls;
        int area = 0;
        int totalWidth = 0;
        this.controlRow = new int[this.controls.length];
        this.controlCol = new int[this.controls.length];
        this.cellData = new CellData[this.controls.length];
        for (idx = 0; idx < this.controls.length; ++idx) {
            CellData next;
            if (this.controls[idx] == null) continue;
            this.cellData[idx] = next = CellLayoutUtil.getData(this.controls[idx]);
            area += next.horizontalSpan * next.verticalSpan;
            totalWidth += next.horizontalSpan;
        }
        if (this.cols == 0) {
            this.cols = totalWidth;
        }
        this.rows = area / this.cols;
        if (area % this.cols > 0) {
            ++this.rows;
        }
        area = this.rows * this.cols;
        this.gridInfo = new int[area];
        for (idx = 0; idx < area; ++idx) {
            this.gridInfo[idx] = -1;
        }
        int infoIdx = 0;
        for (int idx2 = 0; idx2 < this.controls.length; ++idx2) {
            CellData data = this.cellData[idx2];
            while (this.gridInfo[infoIdx] >= 0) {
                ++infoIdx;
            }
            this.controlRow[idx2] = infoIdx / this.cols;
            this.controlCol[idx2] = infoIdx % this.cols;
            for (int rowIdx = 0; rowIdx < data.verticalSpan; ++rowIdx) {
                for (int colIdx = 0; colIdx < data.horizontalSpan; ++colIdx) {
                    this.gridInfo[infoIdx + rowIdx * this.cols + colIdx] = idx2;
                }
            }
            infoIdx += data.horizontalSpan;
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getStartPos(int control, boolean row) {
        if (row) {
            return this.controlRow[control];
        }
        return this.controlCol[control];
    }

    public int getNumRows(boolean isRow) {
        if (isRow) {
            return this.rows;
        }
        return this.cols;
    }

    public void getRow(int[] result, int rowId, boolean horizontal) {
        if (horizontal) {
            int prev = -1;
            for (int colIdx = 0; colIdx < this.cols; ++colIdx) {
                int next = this.gridInfo[this.cols * rowId + colIdx];
                result[colIdx] = prev == next ? -1 : next;
                prev = next;
            }
        } else {
            int prev = -1;
            for (int rowIdx = 0; rowIdx < this.rows; ++rowIdx) {
                int next = this.gridInfo[this.cols * rowIdx + rowId];
                result[rowIdx] = prev == next ? -1 : next;
                prev = next;
            }
        }
    }

    public CellData getCellData(int controlId) {
        return this.cellData[controlId];
    }

    public int getCols() {
        return this.cols;
    }
}

