/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IActionDelegateWithEvent;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.BundleUtility;

public abstract class PluginAction
extends Action
implements ISelectionListener,
ISelectionChangedListener,
INullSelectionListener,
IPluginContribution {
    private IActionDelegate delegate;
    private SelectionEnabler enabler;
    private ISelection selection;
    private IConfigurationElement configElement;
    private String pluginId;
    private String runAttribute = "class";
    private static int actionCount = 0;
    boolean isAdaptableAction = false;
    boolean adaptableNotChecked = true;

    public PluginAction(IConfigurationElement actionElement, String id, int style) {
        super(null, style);
        this.configElement = actionElement;
        if (id != null) {
            this.setId(id);
        } else {
            this.setId("PluginAction." + Integer.toString(actionCount));
            ++actionCount;
        }
        String defId = actionElement.getAttribute("definitionId");
        this.setActionDefinitionId(defId);
        this.pluginId = this.configElement.getDeclaringExtension().getNamespace();
        if (this.configElement.getAttribute("enablesFor") != null) {
            this.enabler = new SelectionEnabler(this.configElement);
        } else {
            IConfigurationElement[] kids = this.configElement.getChildren("enablement");
            if (kids.length > 0) {
                this.enabler = new SelectionEnabler(this.configElement);
            }
        }
        this.selectionChanged((ISelection)new StructuredSelection());
    }

    protected final void createDelegate() {
        if (this.delegate == null && this.runAttribute != null) {
            try {
                Object obj = WorkbenchPlugin.createExtension(this.configElement, this.runAttribute);
                this.delegate = this.validateDelegate(obj);
                this.initDelegate();
                this.refreshEnablement();
            }
            catch (Throwable e) {
                this.runAttribute = null;
                IStatus status = null;
                status = e instanceof CoreException ? ((CoreException)e).getStatus() : StatusUtil.newStatus(4, "Internal plug-in action delegate error on creation.", e);
                String id = this.configElement.getAttribute("id");
                WorkbenchPlugin.log("Could not create action delegate for id: " + id, status);
                return;
            }
        }
    }

    protected IActionDelegate validateDelegate(Object obj) throws WorkbenchException {
        if (obj instanceof IActionDelegate) {
            return (IActionDelegate)obj;
        }
        throw new WorkbenchException("Action must implement IActionDelegate");
    }

    protected void initDelegate() {
        if (this.delegate instanceof IActionDelegate2) {
            ((IActionDelegate2)this.delegate).init((IAction)this);
        }
    }

    protected IActionDelegate getDelegate() {
        return this.delegate;
    }

    protected boolean isOkToCreateDelegate() {
        String bundleId = this.configElement.getDeclaringExtension().getNamespace();
        return BundleUtility.isActivated(bundleId);
    }

    private boolean hasAdaptableType() {
        if (this.adaptableNotChecked) {
            Object parentConfig = this.configElement.getParent();
            String typeName = null;
            if (parentConfig != null && parentConfig instanceof IConfigurationElement) {
                typeName = ((IConfigurationElement)parentConfig).getAttribute("objectClass");
            }
            if (typeName == null) {
                this.adaptableNotChecked = false;
                return false;
            }
            Class resourceClass = LegacyResourceSupport.getResourceClass();
            if (resourceClass == null) {
                this.isAdaptableAction = false;
                this.adaptableNotChecked = false;
                return false;
            }
            if (typeName.equals(resourceClass.getName())) {
                this.isAdaptableAction = true;
                this.adaptableNotChecked = false;
                return this.isAdaptableAction;
            }
            Class<?>[] children = resourceClass.getDeclaredClasses();
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].getName().equals(typeName)) continue;
                this.isAdaptableAction = true;
                this.adaptableNotChecked = false;
                return this.isAdaptableAction;
            }
            this.adaptableNotChecked = false;
        }
        return this.isAdaptableAction;
    }

    protected void refreshEnablement() {
        if (this.enabler != null) {
            this.setEnabled(this.enabler.isEnabledForSelection(this.selection));
        }
        if (this.delegate != null) {
            this.delegate.selectionChanged((IAction)this, this.selection);
        }
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        if (this.delegate == null) {
            this.createDelegate();
            if (this.delegate == null) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)WorkbenchMessages.getString("Information"), (String)WorkbenchMessages.getString("PluginAction.operationNotAvailableMessage"));
                return;
            }
            if (!this.isEnabled()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)WorkbenchMessages.getString("Information"), (String)WorkbenchMessages.getString("PluginAction.disabledMessage"));
                return;
            }
        }
        if (event != null) {
            if (this.delegate instanceof IActionDelegate2) {
                ((IActionDelegate2)this.delegate).runWithEvent((IAction)this, event);
                return;
            }
            if (this.delegate instanceof IActionDelegateWithEvent) {
                ((IActionDelegateWithEvent)((Object)this.delegate)).runWithEvent((IAction)this, event);
                return;
            }
        }
        this.delegate.run((IAction)this);
    }

    public void selectionChanged(ISelection newSelection) {
        this.selection = newSelection;
        if (this.selection == null) {
            this.selection = StructuredSelection.EMPTY;
        }
        if (this.hasAdaptableType()) {
            this.selection = this.getResourceAdapters(this.selection);
        }
        if (this.delegate == null && this.isOkToCreateDelegate()) {
            this.createDelegate();
        } else {
            this.refreshEnablement();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        this.selectionChanged(sel);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        this.selectionChanged(sel);
    }

    private ISelection getResourceAdapters(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            ArrayList<Object> adaptables = new ArrayList<Object>();
            Object[] elements = ((IStructuredSelection)sel).toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object adaptedValue;
                Class resourceClass;
                Object originalValue = elements[i];
                if (!(originalValue instanceof IAdaptable) || (resourceClass = LegacyResourceSupport.getResourceClass()) == null || (adaptedValue = ((IAdaptable)originalValue).getAdapter(resourceClass)) == null) continue;
                adaptables.add(adaptedValue);
            }
            return new StructuredSelection(adaptables);
        }
        return sel;
    }

    public String getOverrideActionId() {
        return null;
    }

    protected IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

