/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IMatchRules;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureEntry;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.FeaturePropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FeatureChildPropertySource
extends FeaturePropertySource {
    protected Vector descriptors;
    public static final String KEY_ID = "FeatureEditor.ChildProp.id";
    public static final String KEY_VERSION = "FeatureEditor.ChildProp.version";
    public static final String KEY_OPTIONAL = "FeatureEditor.ChildProp.optional";
    public static final String KEY_MATCH = "FeatureEditor.ChildProp.match";
    public static final String KEY_NAME = "FeatureEditor.ChildProp.name";
    public static final String KEY_SEARCH_LOCATION = "FeatureEditor.ChildProp.search-location";
    private static final String P_ID = "id";
    private static final String P_VERSION = "version";
    private static final String P_OPTIONAL = "optional";
    private static final String P_MATCH = "match";
    private static final String P_NAME = "name";
    private static final String P_SEARCH_LOCATION = "search-location";
    private static final String P_OS = "os";
    private static final String P_WS = "ws";
    private static final String P_ARCH = "arch";

    public FeatureChildPropertySource(IFeatureChild child) {
        super((IFeatureObject)child);
    }

    protected void createPropertyDescriptors() {
        this.descriptors = new Vector();
        PropertyDescriptor desc = this.createTextPropertyDescriptor(P_ID, PDEPlugin.getResourceString(KEY_ID));
        this.descriptors.addElement(desc);
        desc = this.createTextPropertyDescriptor(P_VERSION, PDEPlugin.getResourceString(KEY_VERSION));
        this.descriptors.addElement(desc);
        desc = this.createTextPropertyDescriptor(P_NAME, PDEPlugin.getResourceString(KEY_NAME));
        this.descriptors.addElement(desc);
        desc = this.createChoicePropertyDescriptor(P_MATCH, PDEPlugin.getResourceString(KEY_MATCH), IMatchRules.RULE_NAME_TABLE);
        this.descriptors.addElement(desc);
        desc = this.createChoicePropertyDescriptor(P_OPTIONAL, PDEPlugin.getResourceString(KEY_OPTIONAL), new String[]{"false", "true"});
        this.descriptors.addElement(desc);
        desc = this.createChoicePropertyDescriptor(P_SEARCH_LOCATION, PDEPlugin.getResourceString(KEY_SEARCH_LOCATION), new String[]{"root", "self", "both"});
        this.descriptors.addElement(desc);
    }

    public IFeatureChild getChild() {
        return (IFeatureChild)this.object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.createPropertyDescriptors();
        }
        return this.toDescriptorArray(this.descriptors);
    }

    public Object getPropertyValue(Object name) {
        if (name.equals(P_ID)) {
            return this.getNonzeroValue(this.getChild().getId());
        }
        if (name.equals(P_VERSION)) {
            return this.getNonzeroValue(this.getChild().getVersion());
        }
        if (name.equals(P_OPTIONAL)) {
            return this.getChild().isOptional() ? new Integer(1) : new Integer(0);
        }
        if (name.equals(P_NAME)) {
            return this.getChild().getName();
        }
        if (name.equals(P_SEARCH_LOCATION)) {
            int loc = this.getChild().getSearchLocation();
            return new Integer(loc);
        }
        if (name.equals(P_MATCH)) {
            return new Integer(this.getChild().getMatch());
        }
        if (name.equals(P_OS)) {
            return this.getChild().getOS();
        }
        if (name.equals(P_WS)) {
            return this.getChild().getWS();
        }
        if (name.equals(P_ARCH)) {
            return this.getChild().getArch();
        }
        return null;
    }

    private String getNonzeroValue(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    public void setElement(IFeatureEntry entry) {
        this.object = entry;
    }

    public void setPropertyValue(Object name, Object value) {
        String svalue = value.toString();
        String realValue = svalue == null | svalue.length() == 0 ? null : svalue;
        try {
            if (name.equals(P_ID)) {
                this.getChild().setId(realValue);
            } else if (name.equals(P_VERSION)) {
                this.getChild().setVersion(realValue);
            } else if (name.equals(P_NAME)) {
                this.getChild().setName(realValue);
            } else if (name.equals(P_OPTIONAL)) {
                Integer index = (Integer)value;
                this.getChild().setOptional(index == 1);
            } else if (name.equals(P_MATCH)) {
                Integer index = (Integer)value;
                this.getChild().setMatch(index.intValue());
            } else if (name.equals(P_SEARCH_LOCATION)) {
                Integer index = (Integer)value;
                this.getChild().setSearchLocation(index.intValue());
            } else if (name.equals(P_OS)) {
                this.getChild().setOS(realValue);
            } else if (name.equals(P_WS)) {
                this.getChild().setWS(realValue);
            } else if (name.equals(P_ARCH)) {
                this.getChild().setArch(realValue);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }
}

