/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ForStatement
extends Statement {
    public Statement[] initializations;
    public Expression condition;
    public Statement[] increments;
    public Statement action;
    public boolean neededScope;
    public BlockScope scope;
    private Label breakLabel;
    private Label continueLabel;
    int preCondInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForStatement(Statement[] initializations, Expression condition, Statement[] increments, Statement action, boolean neededScope, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.initializations = initializations;
        this.condition = condition;
        this.increments = increments;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
        this.neededScope = neededScope;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        LoopingFlowContext loopingContext;
        FlowInfo actionInfo;
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        if (this.initializations != null) {
            int count = this.initializations.length;
            for (int i = 0; i < count; ++i) {
                flowInfo = this.initializations[i].analyseCode(this.scope, flowContext, flowInfo);
            }
        }
        this.preCondInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        Constant cst = this.condition == null ? null : this.condition.constant;
        boolean isConditionTrue = cst == null || cst != NotAConstant && cst.booleanValue();
        boolean isConditionFalse = cst != null && cst != NotAConstant && !cst.booleanValue();
        cst = this.condition == null ? null : this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst == null || cst != NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != null && cst != NotAConstant && !cst.booleanValue();
        LoopingFlowContext condLoopContext = null;
        if (this.condition != null && !isConditionTrue) {
            condLoopContext = new LoopingFlowContext(flowContext, this, null, null, this.scope);
            flowInfo = this.condition.analyseCode(this.scope, condLoopContext, flowInfo);
        }
        if (this.action == null || this.action.isEmptyBlock() && currentScope.environment().options.complianceLevel <= 0x2F0000L) {
            if (condLoopContext != null) {
                condLoopContext.complainOnFinalAssignmentsInLoop(this.scope, flowInfo);
            }
            if (isConditionTrue) {
                return FlowInfo.DEAD_END;
            }
            if (isConditionFalse) {
                this.continueLabel = null;
            }
            actionInfo = flowInfo.initsWhenTrue().copy();
            loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, this.scope);
        } else {
            loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, this.scope);
            FlowInfo initsWhenTrue = flowInfo.initsWhenTrue();
            this.condIfTrueInitStateIndex = currentScope.methodScope().recordInitializationStates(initsWhenTrue);
            if (isConditionFalse) {
                actionInfo = FlowInfo.DEAD_END;
            } else {
                actionInfo = initsWhenTrue.copy();
                if (isConditionOptimizedFalse) {
                    actionInfo.setReachMode(1);
                }
            }
            if (!this.action.complainIfUnreachable(actionInfo, this.scope, false)) {
                actionInfo = this.action.analyseCode(this.scope, loopingContext, actionInfo);
            }
            if (!actionInfo.isReachable() && !loopingContext.initsOnContinue.isReachable()) {
                this.continueLabel = null;
            } else {
                if (condLoopContext != null) {
                    condLoopContext.complainOnFinalAssignmentsInLoop(this.scope, flowInfo);
                }
                actionInfo = actionInfo.mergedWith(loopingContext.initsOnContinue.unconditionalInits());
                loopingContext.complainOnFinalAssignmentsInLoop(this.scope, actionInfo);
            }
        }
        if (this.continueLabel != null && this.increments != null) {
            LoopingFlowContext loopContext = new LoopingFlowContext(flowContext, this, null, null, this.scope);
            int count = this.increments.length;
            for (int i = 0; i < count; ++i) {
                actionInfo = this.increments[i].analyseCode(this.scope, loopContext, actionInfo);
            }
            loopContext.complainOnFinalAssignmentsInLoop(this.scope, actionInfo);
        }
        FlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches(loopingContext.initsOnBreak, isConditionOptimizedTrue, flowInfo.initsWhenFalse(), isConditionOptimizedFalse, !isConditionTrue);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.initializations != null) {
            int max = this.initializations.length;
            for (int i = 0; i < max; ++i) {
                this.initializations[i].generateCode(this.scope, codeStream);
            }
        }
        Label actionLabel = new Label(codeStream);
        Label conditionLabel = new Label(codeStream);
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel != null) {
            this.continueLabel.initialize(codeStream);
        }
        if (this.condition != null && this.condition.constant == NotAConstant && (this.action != null && !this.action.isEmptyBlock() || this.increments != null)) {
            int jumpPC = codeStream.position;
            codeStream.goto_(conditionLabel);
            codeStream.recordPositionsFrom(jumpPC, this.condition.sourceStart);
        }
        actionLabel.place();
        if (this.action != null) {
            if (this.condIfTrueInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(currentScope, this.condIfTrueInitStateIndex);
            }
            this.action.generateCode(this.scope, codeStream);
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            if (this.increments != null) {
                int max = this.increments.length;
                for (int i = 0; i < max; ++i) {
                    this.increments[i].generateCode(this.scope, codeStream);
                }
            }
        }
        if (this.preCondInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preCondInitStateIndex);
        }
        conditionLabel.place();
        if (this.condition != null && this.condition.constant == NotAConstant) {
            this.condition.generateOptimizedBoolean(this.scope, codeStream, actionLabel, null, true);
        } else if (this.continueLabel != null) {
            codeStream.goto_(actionLabel);
        }
        this.breakLabel.place();
        if (this.neededScope) {
            codeStream.exitUserScope(this.scope);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        int i;
        ForStatement.printIndent(tab, output).append("for (");
        if (this.initializations != null) {
            for (i = 0; i < this.initializations.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                this.initializations[i].print(0, output);
            }
        }
        output.append("; ");
        if (this.condition != null) {
            this.condition.printExpression(0, output);
        }
        output.append("; ");
        if (this.increments != null) {
            for (i = 0; i < this.increments.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                this.increments[i].print(0, output);
            }
        }
        output.append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(tab + 1, output);
        }
        return output.append(';');
    }

    public void resolve(BlockScope upperScope) {
        int i;
        int length;
        BlockScope blockScope = this.scope = this.neededScope ? new BlockScope(upperScope) : upperScope;
        if (this.initializations != null) {
            length = this.initializations.length;
            for (i = 0; i < length; ++i) {
                this.initializations[i].resolve(this.scope);
            }
        }
        if (this.condition != null) {
            TypeBinding type = this.condition.resolveTypeExpecting(this.scope, BaseTypes.BooleanBinding);
            this.condition.implicitWidening(type, type);
        }
        if (this.increments != null) {
            length = this.increments.length;
            for (i = 0; i < length; ++i) {
                this.increments[i].resolve(this.scope);
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            int i;
            if (this.initializations != null) {
                int initializationsLength = this.initializations.length;
                for (i = 0; i < initializationsLength; ++i) {
                    this.initializations[i].traverse(visitor, this.scope);
                }
            }
            if (this.condition != null) {
                this.condition.traverse(visitor, this.scope);
            }
            if (this.increments != null) {
                int incrementsLength = this.increments.length;
                for (i = 0; i < incrementsLength; ++i) {
                    this.increments[i].traverse(visitor, this.scope);
                }
            }
            if (this.action != null) {
                this.action.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

