/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.views.markers.internal.Messages;

class SortUtil {
    SortUtil() {
    }

    public static Collection getFirst(Collection elements, Comparator c, int k, IProgressMonitor mon) {
        ArrayList result = new ArrayList(elements.size());
        mon.beginTask(Messages.getString("SortUtil.finding_first"), 1000);
        SortUtil.getFirst(result, elements, c, k, mon, 1000);
        mon.done();
        return result;
    }

    private static void getFirst(Collection result, Collection elements, Comparator c, int k, IProgressMonitor mon, int totalWork) {
        if (mon.isCanceled()) {
            return;
        }
        if (elements.size() <= k) {
            result.addAll(elements);
            mon.worked(totalWork);
            return;
        }
        Object pivot = elements instanceof ArrayList ? ((ArrayList)elements).get(elements.size() / 2) : elements.iterator().next();
        ArrayList more = new ArrayList(elements.size());
        ArrayList less = new ArrayList(elements.size());
        ArrayList equal = new ArrayList();
        SortUtil.partitionHelper(less, more, equal, elements, c, pivot, mon, totalWork / 2);
        if (less.size() >= k) {
            SortUtil.getFirst(result, less, c, k, mon, totalWork / 2);
        } else if (less.size() + equal.size() >= k) {
            result.addAll(less);
            Iterator iter = equal.iterator();
            for (int count = k - less.size(); iter.hasNext() && count > 0; --count) {
                Object next = iter.next();
                result.add(next);
            }
            mon.worked(totalWork / 2);
        } else if (less.size() + equal.size() + more.size() >= k) {
            result.addAll(less);
            result.addAll(equal);
            SortUtil.getFirst(result, more, c, k - less.size() - equal.size(), mon, totalWork / 2);
        }
    }

    private static void partitionHelper(Collection less, Collection more, Collection equal, Collection input, Comparator c, Object toTest, IProgressMonitor mon, int totalWork) {
        int workRemaining = totalWork;
        int counter = 0;
        int totalItems = input.size();
        Iterator iter = input.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            int compareResult = c.compare(next, toTest);
            if (compareResult < 0) {
                less.add(next);
            } else if (compareResult > 0) {
                more.add(next);
            } else {
                equal.add(next);
            }
            if (++counter <= 100) continue;
            if (mon.isCanceled()) {
                return;
            }
            int nextWorked = counter * workRemaining / totalItems;
            mon.worked(nextWorked);
            workRemaining -= nextWorked;
            totalItems -= counter;
            counter = 0;
        }
        mon.worked(workRemaining);
    }

    public static void partition(Collection less, Collection more, Collection equal, Collection input, Comparator c, Object toTest, IProgressMonitor mon) {
        mon.beginTask(Messages.getString("SortUtil.partitioning"), input.size());
        if (toTest == null || c == null) {
            int counter = 0;
            Iterator iter = input.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (++counter >= 20) {
                    mon.worked(counter);
                    counter = 0;
                    if (mon.isCanceled()) {
                        return;
                    }
                }
                more.add(next);
            }
            mon.worked(counter);
        } else {
            SortUtil.partitionHelper(less, more, equal, input, c, toTest, mon, input.size());
        }
        mon.done();
    }

    public static List removeFirst(Collection collection, int numToRemove) {
        int toRemove = Math.min(collection.size(), numToRemove);
        ArrayList removed = new ArrayList(toRemove);
        Iterator iter = collection.iterator();
        for (int idx = 0; idx < toRemove; ++idx) {
            removed.add(iter.next());
            iter.remove();
        }
        return removed;
    }

    public static Object findGreatest(Collection toSearch, Comparator c) {
        if (toSearch instanceof SortedSet && ((Object)((SortedSet)toSearch).comparator()).equals(c)) {
            return ((SortedSet)toSearch).last();
        }
        Object result = null;
        Iterator iter = toSearch.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (result != null && c.compare(result, next) <= 0) continue;
            result = next;
        }
        return result;
    }
}

