/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.BuildSetAction;
import org.eclipse.ui.internal.ide.dialogs.CleanDialog;

public class BuildCleanAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow window;

    public BuildCleanAction(IWorkbenchWindow window) {
        super(IDEWorkbenchMessages.getString("Workbench.buildClean"));
        this.setActionDefinitionId("org.eclipse.ui.project.cleanAction");
        this.window = window;
    }

    public void dispose() {
    }

    public void run() {
        ISelection selection = this.window.getSelectionService().getSelection();
        IProject[] selected = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            selected = BuildSetAction.extractProjects(((IStructuredSelection)selection).toArray());
        } else {
            IEditorInput input;
            IWorkbenchPart part = this.window.getPartService().getActivePart();
            if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
                selected = new IProject[]{((IFileEditorInput)input).getFile().getProject()};
            }
        }
        if (selected == null) {
            selected = new IProject[]{};
        }
        new CleanDialog(this.window, selected).open();
    }
}

