/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyResourceAction;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class MoveResourceAction
extends CopyResourceAction {
    public static final String ID = "org.eclipse.ui.MoveResourceAction";
    protected List destinations;

    public MoveResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.getString("MoveResourceAction.text"));
        this.setToolTipText(IDEWorkbenchMessages.getString("MoveResourceAction.toolTip"));
        this.setId(ID);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.move_resource_action_context");
    }

    protected CopyFilesAndFoldersOperation createOperation() {
        return new MoveFilesAndFoldersOperation(this.getShell());
    }

    protected List getDestinations() {
        return this.destinations;
    }

    protected IResource[] getResources(List resourceList) {
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), IDEWorkbenchMessages.getString("MoveResourceAction.title"), IDEWorkbenchMessages.getString("MoveResourceAction.checkMoveMessage"));
        return checker.checkReadOnlyResources(super.getResources(resourceList));
    }

    protected void runOperation(IResource[] resources, IContainer destination) {
        this.destinations = new ArrayList();
        IResource[] copiedResources = this.operation.copyResources(resources, destination);
        for (int i = 0; i < copiedResources.length; ++i) {
            this.destinations.add(destination.getFullPath().append(copiedResources[i].getName()));
        }
    }
}

