/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator.branding;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.internal.configurator.Messages;
import org.osgi.framework.Bundle;

public class IniFileReader {
    private static final String PID = "org.eclipse.update.configurator";
    private static final Status OK_STATUS = new Status(0, "org.eclipse.update.configurator", 0, "", null);
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final String NLS_TAG = "$nl$";
    private String featureId;
    private String pluginId;
    private String iniFilename;
    private String propertiesFilename;
    private String mappingsFilename;
    private Properties ini = null;
    private PropertyResourceBundle properties = null;
    private String[] mappings = null;
    private Bundle bundle;

    public IniFileReader(String featureId, String pluginId, String iniFilename, String propertiesFilename, String mappingsFilename) {
        if (featureId == null || pluginId == null || iniFilename == null) {
            throw new IllegalArgumentException();
        }
        this.featureId = featureId;
        this.pluginId = pluginId;
        this.iniFilename = iniFilename;
        this.propertiesFilename = propertiesFilename;
        this.mappingsFilename = mappingsFilename;
    }

    public IStatus load() {
        if (this.ini != null) {
            return OK_STATUS;
        }
        this.bundle = Platform.getBundle((String)this.pluginId);
        if (this.bundle == null || this.bundle.getState() == 1 || this.bundle.getState() == 2) {
            this.bundle = null;
            String message = Messages.getString("IniFileReader.MissingDesc", this.featureId);
            return new Status(4, PID, 0, message, null);
        }
        URL iniURL = null;
        IOException ioe = null;
        try {
            iniURL = Platform.find((Bundle)this.bundle, (IPath)new Path(NLS_TAG).append(this.iniFilename));
            if (iniURL != null) {
                iniURL = Platform.resolve((URL)iniURL);
            }
        }
        catch (IOException e) {
            ioe = e;
        }
        if (iniURL == null) {
            String message = Messages.getString("IniFileReader.OpenINIError", this.iniFilename);
            return new Status(4, PID, 0, message, (Throwable)ioe);
        }
        URL propertiesURL = null;
        if (this.propertiesFilename != null & this.propertiesFilename.length() > 0) {
            try {
                propertiesURL = Platform.find((Bundle)this.bundle, (IPath)new Path(NLS_TAG).append(this.propertiesFilename));
                if (propertiesURL != null) {
                    propertiesURL = Platform.resolve((URL)propertiesURL);
                }
            }
            catch (IOException e) {
                String message = Messages.getString("IniFileReader.OpenPropError", this.propertiesFilename);
                return new Status(4, PID, 0, message, (Throwable)e);
            }
        }
        URL mappingsURL = null;
        if (this.mappingsFilename != null && this.mappingsFilename.length() > 0) {
            try {
                mappingsURL = Platform.find((Bundle)this.bundle, (IPath)new Path(NLS_TAG).append(this.mappingsFilename));
                if (mappingsURL != null) {
                    mappingsURL = Platform.resolve((URL)mappingsURL);
                }
            }
            catch (IOException e) {
                String message = Messages.getString("IniFileReader.OpenMapError", this.mappingsFilename);
                return new Status(4, PID, 0, message, (Throwable)e);
            }
        }
        return this.load(iniURL, propertiesURL, mappingsURL);
    }

    public String getString(String key, boolean doNls, Hashtable runtimeMappings) {
        if (this.ini == null) {
            return null;
        }
        String value = this.ini.getProperty(key);
        if (value != null && doNls) {
            return this.getResourceString(value, runtimeMappings);
        }
        return value;
    }

    public URL getURL(String key) {
        if (this.ini == null) {
            return null;
        }
        URL url = null;
        String fileName = this.ini.getProperty(key);
        if (fileName != null) {
            if (this.bundle == null) {
                return null;
            }
            url = Platform.find((Bundle)this.bundle, (IPath)new Path(fileName));
        }
        return url;
    }

    public URL[] getURLs(String key) {
        if (this.ini == null || this.bundle == null) {
            return null;
        }
        String value = this.ini.getProperty(key);
        if (value == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(value, ",");
        ArrayList<URL> array = new ArrayList<URL>(10);
        while (tokens.hasMoreTokens()) {
            String str = tokens.nextToken().trim();
            array.add(Platform.find((Bundle)this.bundle, (IPath)new Path(str)));
        }
        URL[] urls = new URL[array.size()];
        array.toArray(urls);
        return urls;
    }

    public String getFeaturePluginLabel() {
        if (this.bundle == null) {
            return null;
        }
        return (String)this.bundle.getHeaders().get("Bundle-Name");
    }

    public String getProviderName() {
        if (this.bundle == null) {
            return null;
        }
        return (String)this.bundle.getHeaders().get("Bundle-Vendor");
    }

    public String getResourceString(String value, Hashtable runtimeMappings) {
        String dflt;
        if (value == null) {
            return null;
        }
        String s = value.trim();
        if (!s.startsWith(KEY_PREFIX)) {
            return s;
        }
        if (s.startsWith(KEY_DOUBLE_PREFIX)) {
            return s.substring(1);
        }
        int ix = s.indexOf(" ");
        String key = ix == -1 ? s : s.substring(0, ix);
        String string = dflt = ix == -1 ? s : s.substring(ix + 1);
        if (this.properties == null) {
            return dflt;
        }
        String result = null;
        try {
            result = this.properties.getString(key.substring(1));
        }
        catch (MissingResourceException e) {
            return dflt;
        }
        if (runtimeMappings != null) {
            Enumeration e = runtimeMappings.keys();
            while (e.hasMoreElements()) {
                String keyValue = (String)e.nextElement();
                int i = result.indexOf(keyValue);
                if (i == -1) continue;
                String s1 = result.substring(0, i);
                String s2 = (String)runtimeMappings.get(keyValue);
                String s3 = result.substring(i + keyValue.length());
                result = s1 + s2 + s3;
            }
        }
        if (result.indexOf(123) != -1) {
            result = MessageFormat.format(result, this.mappings);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private IStatus load(URL iniURL, URL propertiesURL, URL mappingsURL) {
        PropertyResourceBundle bundle;
        block43: {
            InputStream is;
            block41: {
                block39: {
                    is = null;
                    is = iniURL.openStream();
                    this.ini = new Properties();
                    this.ini.load(is);
                    Object var9_5 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block39;
                    }
                    catch (IOException e2) {}
                    break block39;
                    {
                        catch (IOException e) {
                            this.ini = null;
                            String message = Messages.getString("IniFileReader.ReadIniError", iniURL.toExternalForm());
                            Status status = new Status(4, PID, 0, message, (Throwable)e);
                            Object var9_6 = null;
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            return status;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_7 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                if (propertiesURL != null) {
                    is = null;
                    is = propertiesURL.openStream();
                    this.properties = new PropertyResourceBundle(is);
                    Object var12_26 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block41;
                    }
                    catch (IOException e3) {}
                    break block41;
                    {
                        catch (IOException e) {
                            this.properties = null;
                            String message = Messages.getString("IniFileReader.ReadPropError", propertiesURL.toExternalForm());
                            Status status = new Status(4, PID, 0, message, (Throwable)e);
                            Object var12_27 = null;
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException e3) {
                                // empty catch block
                            }
                            return status;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_28 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException e3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            bundle = null;
            if (mappingsURL != null) {
                is = null;
                is = mappingsURL.openStream();
                bundle = new PropertyResourceBundle(is);
                Object var15_33 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                    break block43;
                }
                catch (IOException e4) {}
                break block43;
                {
                    catch (IOException e) {
                        bundle = null;
                        String message = Messages.getString("IniFileReader.ReadMapError", mappingsURL.toExternalForm());
                        Status status = new Status(4, PID, 0, message, (Throwable)e);
                        Object var15_34 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException e4) {
                            // empty catch block
                        }
                        return status;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_35 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e4) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        ArrayList<String> mappingsList = new ArrayList<String>();
        if (bundle != null) {
            boolean found = true;
            int i = 0;
            while (found) {
                try {
                    mappingsList.add(bundle.getString(Integer.toString(i)));
                }
                catch (MissingResourceException e) {
                    found = false;
                }
                ++i;
            }
        }
        this.mappings = mappingsList.toArray(new String[mappingsList.size()]);
        return OK_STATUS;
    }
}

