/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CopyRefactoring;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.reorg.NewNameQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgResult;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.widgets.Shell;

public class ReorgCopyStarter {
    private final CopyRefactoring fCopyRefactoring;
    private ReorgResult fResult;

    private ReorgCopyStarter(CopyRefactoring copyRefactoring) {
        Assert.isNotNull(copyRefactoring);
        this.fCopyRefactoring = copyRefactoring;
    }

    public ReorgResult getResult() {
        return this.fResult;
    }

    public static ReorgCopyStarter create(IJavaElement[] javaElements, IResource[] resources, IJavaElement destination) throws JavaModelException {
        Assert.isNotNull(javaElements);
        Assert.isNotNull(resources);
        Assert.isNotNull(destination);
        CopyRefactoring copyRefactoring = CopyRefactoring.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
        if (copyRefactoring == null) {
            return null;
        }
        if (!copyRefactoring.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgCopyStarter(copyRefactoring);
    }

    public static ReorgCopyStarter create(IJavaElement[] javaElements, IResource[] resources, IResource destination) throws JavaModelException {
        Assert.isNotNull(javaElements);
        Assert.isNotNull(resources);
        Assert.isNotNull(destination);
        CopyRefactoring copyRefactoring = CopyRefactoring.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
        if (copyRefactoring == null) {
            return null;
        }
        if (!copyRefactoring.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgCopyStarter(copyRefactoring);
    }

    public void run(Shell parent) throws InterruptedException, InvocationTargetException {
        ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
        NewNameQueries nameQueries = new NewNameQueries(parent);
        this.fCopyRefactoring.setNewNameQueries(nameQueries);
        this.fCopyRefactoring.setReorgQueries(new ReorgQueries(parent));
        try {
            this.fResult = new ReorgResult(!new RefactoringExecutionHelper(this.fCopyRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), false, parent, (IRunnableContext)context).perform(), nameQueries.getNameChanges());
        }
        catch (InterruptedException e) {
            this.fResult = new ReorgResult(true, nameQueries.getNameChanges());
            throw e;
        }
    }
}

