/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;

class PackageExplorerLabelProvider
extends AppearanceAwareLabelProvider {
    private ITreeContentProvider fContentProvider;
    private boolean fIsFlatLayout;
    private TreeHierarchyLayoutProblemsDecorator fProblemDecorator = new TreeHierarchyLayoutProblemsDecorator();

    PackageExplorerLabelProvider(int textFlags, int imageFlags, ITreeContentProvider cp) {
        super(textFlags, imageFlags);
        this.addLabelDecorator(this.fProblemDecorator);
        Assert.isNotNull((Object)cp);
        this.fContentProvider = cp;
    }

    public String getText(Object element) {
        if (this.fIsFlatLayout || !(element instanceof IPackageFragment)) {
            return super.getText(element);
        }
        IPackageFragment fragment = (IPackageFragment)element;
        if (fragment.isDefaultPackage()) {
            return super.getText(fragment);
        }
        Object parent = this.fContentProvider.getParent((Object)fragment);
        if (parent instanceof IPackageFragment) {
            return this.getNameDelta((IPackageFragment)parent, fragment);
        }
        return super.getText(fragment);
    }

    private String getNameDelta(IPackageFragment topFragment, IPackageFragment bottomFragment) {
        String bottomName;
        String topName = topFragment.getElementName();
        if (topName.equals(bottomName = bottomFragment.getElementName())) {
            return topName;
        }
        String deltaname = bottomName.substring(topName.length() + 1);
        return deltaname;
    }

    void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
        this.fProblemDecorator.setIsFlatLayout(state);
    }
}

