/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameFieldProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating {
    private static final String DECLARED_SUPERTYPE = RefactoringCoreMessages.getString("RenameFieldRefactoring.declared_in_supertype");
    private IField fField;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    private ICompilationUnit[] fNewWorkingCopies;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fRenameGetter;
    private boolean fRenameSetter;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameFieldProcessor";
    static /* synthetic */ Class class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker;

    public RenameFieldProcessor(IField field) {
        this.fField = field;
        this.setNewElementName(this.fField.getElementName());
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fRenameGetter = false;
        this.fRenameSetter = false;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        if (this.fField == null) {
            return false;
        }
        return Checks.isAvailable((IJavaElement)this.fField);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.name", new String[]{this.fField.getElementName(), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fField);
    }

    public Object[] getElements() {
        return new Object[]{this.fField};
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
        IMethod setter;
        IMethod getter;
        if (this.fRenameGetter && (getter = this.getGetter()) != null) {
            this.addParticipants(status, result, getter, this.getNewGetterName(), natures, shared);
        }
        if (this.fRenameSetter && (setter = this.getSetter()) != null) {
            this.addParticipants(status, result, setter, this.getNewSetterName(), natures, shared);
        }
    }

    private void addParticipants(RefactoringStatus status, List result, IMethod method, String methodName, String[] natures, SharableParticipants shared) {
        RenameArguments args = new RenameArguments(methodName, this.getUpdateReferences());
        RenameParticipant[] participants = ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)method, (RenameArguments)args, (String[])natures, (SharableParticipants)shared);
        result.addAll(Arrays.asList(participants));
    }

    public final String getCurrentElementName() {
        return this.fField.getElementName();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (RenameFieldProcessor.isInstaceField(this.fField) && !Checks.startsWithLowerCase(newName)) {
            result.addWarning(RefactoringCoreMessages.getString("RenameFieldRefactoring.should_start_lowercase"));
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fField, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameFieldRefactoring.another_name"));
        }
        if (this.fField.getDeclaringType().getField(newName).exists()) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameFieldRefactoring.field_already_defined"));
        }
        return result;
    }

    public Object getNewElement() {
        return this.fField.getDeclaringType().getField(this.getNewElementName());
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public String canEnableGetterRenaming() throws CoreException {
        if (this.fField.getDeclaringType().isInterface()) {
            return this.getGetter() == null ? "" : null;
        }
        IMethod getter = this.getGetter();
        if (getter == null) {
            return "";
        }
        if (MethodChecks.isVirtual(getter) && null != MethodChecks.isDeclaredInInterface(getter, (IProgressMonitor)new NullProgressMonitor())) {
            return DECLARED_SUPERTYPE;
        }
        if (MethodChecks.isVirtual(getter) && null != MethodChecks.overridesAnotherMethod(getter, (IProgressMonitor)new NullProgressMonitor())) {
            return DECLARED_SUPERTYPE;
        }
        return null;
    }

    public String canEnableSetterRenaming() throws CoreException {
        if (this.fField.getDeclaringType().isInterface()) {
            return this.getSetter() == null ? "" : null;
        }
        IMethod setter = this.getSetter();
        if (setter == null) {
            return "";
        }
        if (MethodChecks.isVirtual(setter) && null != MethodChecks.isDeclaredInInterface(setter, (IProgressMonitor)new NullProgressMonitor())) {
            return DECLARED_SUPERTYPE;
        }
        if (MethodChecks.isVirtual(setter) && null != MethodChecks.overridesAnotherMethod(setter, (IProgressMonitor)new NullProgressMonitor())) {
            return DECLARED_SUPERTYPE;
        }
        return null;
    }

    public boolean getRenameGetter() {
        return this.fRenameGetter;
    }

    public void setRenameGetter(boolean renameGetter) {
        this.fRenameGetter = renameGetter;
    }

    public boolean getRenameSetter() {
        return this.fRenameSetter;
    }

    public void setRenameSetter(boolean renameSetter) {
        this.fRenameSetter = renameSetter;
    }

    public IMethod getGetter() throws CoreException {
        return GetterSetterUtil.getGetter(this.fField);
    }

    public IMethod getSetter() throws CoreException {
        return GetterSetterUtil.getSetter(this.fField);
    }

    public String getNewGetterName() throws CoreException {
        IMethod primaryGetterCandidate = JavaModelUtil.findMethod(GetterSetterUtil.getGetterName(this.fField, new String[0]), new String[0], false, this.fField.getDeclaringType());
        if (!JavaModelUtil.isBoolean(this.fField) || primaryGetterCandidate != null && primaryGetterCandidate.exists()) {
            return GetterSetterUtil.getGetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), JavaModelUtil.isBoolean(this.fField), null);
        }
        return GetterSetterUtil.getGetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), false, null);
    }

    public String getNewSetterName() throws CoreException {
        return GetterSetterUtil.getSetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), JavaModelUtil.isBoolean(this.fField), null);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        IField orig = (IField)WorkingCopyUtil.getOriginal((IMember)this.fField);
        if (orig == null || !orig.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.deleted", this.fField.getCompilationUnit().getElementName());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        this.fField = orig;
        return Checks.checkIfCuBroken((IMember)this.fField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            pm.beginTask("", 18);
            pm.setTaskName(RefactoringCoreMessages.getString("RenameFieldRefactoring.checking"));
            RefactoringStatus result = new RefactoringStatus();
            result.merge(Checks.checkIfCuBroken((IMember)this.fField));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkNewElementName(this.getNewElementName()));
            pm.worked(1);
            result.merge(this.checkEnclosingHierarchy());
            pm.worked(1);
            result.merge(this.checkNestedHierarchy(this.fField.getDeclaringType()));
            pm.worked(1);
            if (this.fUpdateReferences) {
                pm.setTaskName(RefactoringCoreMessages.getString("RenameFieldRefactoring.searching"));
                this.fReferences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 3), result);
                pm.setTaskName(RefactoringCoreMessages.getString("RenameFieldRefactoring.checking"));
            } else {
                this.fReferences = new SearchResultGroup[0];
                pm.worked(3);
            }
            if (this.fUpdateReferences) {
                result.merge(this.analyzeAffectedCompilationUnits());
            }
            if (this.getGetter() != null && this.fRenameGetter) {
                result.merge(this.checkAccessor((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getGetter(), this.getNewGetterName()));
                result.merge(Checks.checkIfConstructorName(this.getGetter(), this.getNewGetterName(), this.fField.getDeclaringType().getElementName()));
            } else {
                pm.worked(1);
            }
            if (this.getSetter() != null && this.fRenameSetter) {
                result.merge(this.checkAccessor((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getSetter(), this.getNewSetterName()));
                result.merge(Checks.checkIfConstructorName(this.getSetter(), this.getNewSetterName(), this.fField.getDeclaringType().getElementName()));
            } else {
                pm.worked(1);
            }
            result.merge(this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, 10)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            ValidateEditChecker checker = (ValidateEditChecker)context.getChecker(class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker == null ? (class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker = RenameFieldProcessor.class$("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker")) : class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker);
            checker.addFiles(this.getAllFilesToModify());
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkAccessor(IProgressMonitor pm, IMethod existingAccessor, String newAccessorName) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkAccessorDeclarations(pm, existingAccessor));
        result.merge(this.checkNewAccessor(existingAccessor, newAccessorName));
        return result;
    }

    private RefactoringStatus checkNewAccessor(IMethod existingAccessor, String newAccessorName) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IMethod accessor = JavaModelUtil.findMethod(newAccessorName, existingAccessor.getParameterTypes(), false, this.fField.getDeclaringType());
        if (accessor == null || !accessor.exists()) {
            return null;
        }
        String message = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.already_exists", new String[]{JavaElementUtil.createMethodSignature(accessor), JavaModelUtil.getFullyQualifiedName(this.fField.getDeclaringType())});
        result.addError(message, JavaStatusContext.create((IMember)accessor));
        return result;
    }

    private RefactoringStatus checkAccessorDeclarations(IProgressMonitor pm, IMethod existingAccessor) throws CoreException {
        IJavaSearchScope scope;
        RefactoringStatus result = new RefactoringStatus();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)existingAccessor, (int)0);
        SearchResultGroup[] groupDeclarations = RefactoringSearchEngine.search(pattern, scope = SearchEngine.createHierarchyScope((IType)this.fField.getDeclaringType()), pm, result);
        Assert.isTrue(groupDeclarations.length > 0);
        if (groupDeclarations.length != 1) {
            String message = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.overridden", JavaElementUtil.createMethodSignature(existingAccessor));
            result.addError(message);
        } else {
            SearchResultGroup group = groupDeclarations[0];
            Assert.isTrue(group.getSearchResults().length > 0);
            if (group.getSearchResults().length != 1) {
                String message = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.overridden_or_overrides", JavaElementUtil.createMethodSignature(existingAccessor));
                result.addError(message);
            }
        }
        return result;
    }

    private static boolean isInstaceField(IField field) throws CoreException {
        if (field.getDeclaringType().isInterface()) {
            return false;
        }
        return !JdtFlags.isStatic((IMember)field);
    }

    private RefactoringStatus checkNestedHierarchy(IType type) throws CoreException {
        IType[] nestedTypes = type.getTypes();
        if (nestedTypes == null) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        for (int i = 0; i < nestedTypes.length; ++i) {
            IField otherField = nestedTypes[i].getField(this.getNewElementName());
            if (otherField.exists()) {
                String msg = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.hiding", new String[]{this.fField.getElementName(), this.getNewElementName(), JavaModelUtil.getFullyQualifiedName(nestedTypes[i])});
                result.addWarning(msg, JavaStatusContext.create((IMember)otherField));
            }
            result.merge(this.checkNestedHierarchy(nestedTypes[i]));
        }
        return result;
    }

    private RefactoringStatus checkEnclosingHierarchy() {
        IType current = this.fField.getDeclaringType();
        if (Checks.isTopLevel(current)) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        while (current != null) {
            IField otherField = current.getField(this.getNewElementName());
            if (otherField.exists()) {
                String msg = RefactoringCoreMessages.getFormattedString("RenameFieldRefactoring.hiding2", new String[]{this.getNewElementName(), JavaModelUtil.getFullyQualifiedName(current)});
                result.addWarning(msg, JavaStatusContext.create((IMember)otherField));
            }
            current = current.getDeclaringType();
        }
        return result;
    }

    private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fReferences = Checks.excludeCompilationUnits(this.fReferences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences));
        return result;
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private SearchPattern createSearchPattern() {
        return SearchPattern.createPattern((IJavaElement)this.fField, (int)2);
    }

    private IJavaSearchScope createRefactoringScope() throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)this.fField);
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        return RefactoringSearchEngine.search(this.createSearchPattern(), this.createRefactoringScope(), pm, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.getString("Change.javaChanges"), (Change[])this.fChangeManager.getAllChanges());
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus createChanges(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.getString("RenameFieldRefactoring.checking"), 10);
        RefactoringStatus result = new RefactoringStatus();
        this.fChangeManager = new TextChangeManager(true);
        this.addDeclarationUpdate();
        if (this.fUpdateReferences) {
            this.addReferenceUpdates((IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 2)));
            if (result.hasFatalError()) {
                return result;
            }
        } else {
            pm.worked(3);
        }
        if (this.getGetter() != null && this.fRenameGetter) {
            this.addGetterOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        } else {
            pm.worked(1);
        }
        if (this.getSetter() != null && this.fRenameSetter) {
            this.addSetterOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        } else {
            pm.worked(1);
        }
        if (this.fUpdateTextualMatches) {
            this.addTextMatches((IProgressMonitor)new SubProgressMonitor(pm, 5));
        } else {
            pm.worked(5);
        }
        pm.done();
        return result;
    }

    private void addDeclarationUpdate() throws CoreException {
        ReplaceEdit textEdit = new ReplaceEdit(this.fField.getNameRange().getOffset(), this.fField.getElementName().length(), this.getNewElementName());
        ICompilationUnit cu = this.fField.getCompilationUnit();
        String groupName = RefactoringCoreMessages.getString("RenameFieldRefactoring.Update_field_declaration");
        TextChangeCompatibility.addTextEdit(this.fChangeManager.get(cu), groupName, (TextEdit)textEdit);
    }

    private void addReferenceUpdates(IProgressMonitor pm) {
        pm.beginTask("", this.fReferences.length);
        String editName = RefactoringCoreMessages.getString("RenameFieldRefactoring.Update_field_reference");
        for (int i = 0; i < this.fReferences.length; ++i) {
            ICompilationUnit cu = this.fReferences[i].getCompilationUnit();
            if (cu == null) continue;
            SearchMatch[] results = this.fReferences[i].getSearchResults();
            for (int j = 0; j < results.length; ++j) {
                TextChangeCompatibility.addTextEdit(this.fChangeManager.get(cu), editName, this.createTextChange(results[j]));
            }
            pm.worked(1);
        }
    }

    private TextEdit createTextChange(SearchMatch match) {
        String oldName = this.fField.getElementName();
        int offset = match.getOffset() + match.getLength() - oldName.length();
        return new ReplaceEdit(offset, oldName.length(), this.getNewElementName());
    }

    private void addGetterOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        this.addAccessorOccurrences(pm, this.getGetter(), RefactoringCoreMessages.getString("RenameFieldRefactoring.Update_getter_occurrence"), this.getNewGetterName(), status);
    }

    private void addSetterOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        this.addAccessorOccurrences(pm, this.getSetter(), RefactoringCoreMessages.getString("RenameFieldRefactoring.Update_setter_occurrence"), this.getNewSetterName(), status);
    }

    private void addAccessorOccurrences(IProgressMonitor pm, IMethod accessor, String editName, String newAccessorName, RefactoringStatus status) throws CoreException {
        Assert.isTrue(accessor.exists());
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)accessor);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)accessor, (int)3);
        SearchResultGroup[] groupedResults = RefactoringSearchEngine.search(pattern, scope, new MethodOccurenceCollector(accessor.getElementName()), pm, status);
        for (int i = 0; i < groupedResults.length; ++i) {
            ICompilationUnit cu = groupedResults[i].getCompilationUnit();
            if (cu == null) continue;
            SearchMatch[] results = groupedResults[i].getSearchResults();
            for (int j = 0; j < results.length; ++j) {
                SearchMatch searchResult = results[j];
                ReplaceEdit edit = new ReplaceEdit(searchResult.getOffset(), searchResult.getLength(), newAccessorName);
                TextChangeCompatibility.addTextEdit(this.fChangeManager.get(cu), editName, (TextEdit)edit);
            }
        }
    }

    private void addTextMatches(IProgressMonitor pm) throws CoreException {
        TextMatchUpdater.perform(pm, this.createRefactoringScope(), this, this.fChangeManager, this.fReferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        try {
            pm.beginTask("", 2);
            RefactoringStatus result = new RefactoringStatus();
            SearchResultGroup[] oldReferences = this.fReferences;
            SearchResultGroup[] newReferences = this.getNewReferences((IProgressMonitor)new SubProgressMonitor(pm, 1), this.fChangeManager, result);
            result.merge(RenameAnalyzeUtil.analyzeRenameChanges2(this.fChangeManager, oldReferences, newReferences, this.getNewElementName()));
            refactoringStatus = result;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            pm.done();
            if (this.fNewWorkingCopies != null) {
                for (int i = 0; i < this.fNewWorkingCopies.length; ++i) {
                    this.fNewWorkingCopies[i].destroy();
                }
            }
            throw throwable;
        }
        pm.done();
        if (this.fNewWorkingCopies != null) {
            for (int i = 0; i < this.fNewWorkingCopies.length; ++i) {
                this.fNewWorkingCopies[i].destroy();
            }
        }
        return refactoringStatus;
    }

    private SearchResultGroup[] getNewReferences(IProgressMonitor pm, TextChangeManager manager, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 2);
        ICompilationUnit[] compilationUnitsToModify = manager.getAllCompilationUnits();
        this.fNewWorkingCopies = RenameAnalyzeUtil.getNewWorkingCopies(compilationUnitsToModify, manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        ICompilationUnit declaringCuWorkingCopy = RenameAnalyzeUtil.findWorkingCopyForCu(this.fNewWorkingCopies, this.fField.getCompilationUnit());
        if (declaringCuWorkingCopy == null) {
            return new SearchResultGroup[0];
        }
        IField field = this.getNewField(declaringCuWorkingCopy);
        if (field == null || !field.exists()) {
            return new SearchResultGroup[0];
        }
        SearchPattern newPattern = SearchPattern.createPattern((IJavaElement)field, (int)2);
        return RefactoringSearchEngine.search(newPattern, this.createRefactoringScope(), (IProgressMonitor)new SubProgressMonitor(pm, 1), this.fNewWorkingCopies, status);
    }

    private IField getNewField(ICompilationUnit newWorkingCopyOfDeclaringCu) throws CoreException {
        IType[] allNewTypes = newWorkingCopyOfDeclaringCu.getAllTypes();
        String fullyTypeName = this.fField.getDeclaringType().getFullyQualifiedName();
        for (int i = 0; i < allNewTypes.length; ++i) {
            if (!allNewTypes[i].getFullyQualifiedName().equals(fullyTypeName)) continue;
            return allNewTypes[i].getField(this.getNewElementName());
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

