/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.internal.presentations.AbstractTableInformationControl;
import org.eclipse.ui.internal.presentations.DefaultEditorPresentation;
import org.eclipse.ui.internal.presentations.DefaultPartPresentation;
import org.eclipse.ui.internal.presentations.PaneFolder;
import org.eclipse.ui.presentations.IPresentablePart;

public class BasicStackList
extends AbstractTableInformationControl {
    public BasicStackList(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, treeStyle);
    }

    protected TableViewer createTableViewer(Composite parent, int style) {
        Table table = new Table(parent, 4 | style & 0xFFFFFFFD);
        table.setLayoutData((Object)new GridData(2));
        TableViewer tableViewer = new TableViewer(table){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void internalRefresh(Object element) {
                boolean usingMotif = "motif".equals(SWT.getPlatform());
                try {
                    if (usingMotif) {
                        this.getTable().setRedraw(false);
                    }
                    super.internalRefresh(element);
                }
                finally {
                    if (usingMotif) {
                        this.getTable().setRedraw(true);
                    }
                }
            }
        };
        tableViewer.addFilter((ViewerFilter)new AbstractTableInformationControl.NamePatternFilter());
        tableViewer.setContentProvider((IContentProvider)new BasicStackListContentProvider());
        tableViewer.setSorter((ViewerSorter)new BasicStackListViewerSorter());
        tableViewer.setLabelProvider((IBaseLabelProvider)new BasicStackListLabelProvider());
        return tableViewer;
    }

    public void setInput(Object information) {
        DefaultPartPresentation basicStackPresentation = (DefaultPartPresentation)information;
        this.inputChanged(basicStackPresentation, basicStackPresentation.getTabFolder().getSelection());
    }

    protected void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        DefaultPartPresentation basicStackPresentation = null;
        if (selectedElement != null) {
            basicStackPresentation = (DefaultPartPresentation)this.getTableViewer().getInput();
        }
        this.dispose();
        if (basicStackPresentation != null) {
            basicStackPresentation.setSelection((CTabItem)selectedElement);
        }
    }

    protected boolean deleteSelectedElements() {
        IStructuredSelection structuredSelection = this.getSelectedElements();
        if (structuredSelection != null) {
            DefaultPartPresentation basicStackPresentation = (DefaultPartPresentation)this.getTableViewer().getInput();
            ArrayList<IPresentablePart> list = new ArrayList<IPresentablePart>(structuredSelection.size());
            Iterator iterator = structuredSelection.iterator();
            while (iterator.hasNext()) {
                IPresentablePart presentablePart = basicStackPresentation.getPartForTab((CTabItem)iterator.next());
                list.add(presentablePart);
            }
            basicStackPresentation.close(list.toArray(new IPresentablePart[list.size()]));
        }
        if (((DefaultPartPresentation)this.getTableViewer().getInput()).isDisposed()) {
            this.fComposite.dispose();
            return true;
        }
        return false;
    }

    private class BasicStackListViewerSorter
    extends ViewerSorter {
        public BasicStackListViewerSorter() {
        }

        public BasicStackListViewerSorter(Collator collator) {
            super(collator);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name2;
            String name1;
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (viewer == null || !(viewer instanceof ContentViewer)) {
                name1 = e1.toString();
                name2 = e2.toString();
            } else {
                IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                if (prov instanceof ILabelProvider) {
                    ILabelProvider lprov = (ILabelProvider)prov;
                    name1 = lprov.getText(e1);
                    name2 = lprov.getText(e2);
                    String prefix = DefaultEditorPresentation.DIRTY_PREFIX;
                    if (name1.startsWith(prefix)) {
                        name1 = name1.substring(prefix.length());
                    }
                    if (name2.startsWith(prefix)) {
                        name2 = name2.substring(prefix.length());
                    }
                } else {
                    name1 = e1.toString();
                    name2 = e2.toString();
                }
            }
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.collator.compare(name1, name2);
        }

        public int category(Object element) {
            CTabItem tabItem = (CTabItem)element;
            if (tabItem.isShowing()) {
                return 1;
            }
            return 0;
        }
    }

    private class BasicStackListLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private Font boldFont = null;

        public String getText(Object element) {
            CTabItem tabItem = (CTabItem)element;
            DefaultPartPresentation basicStackPresentation = (DefaultPartPresentation)BasicStackList.this.getTableViewer().getInput();
            IPresentablePart presentablePart = basicStackPresentation.getPartForTab(tabItem);
            return basicStackPresentation.getLabelText(presentablePart, true);
        }

        public Image getImage(Object element) {
            CTabItem tabItem = (CTabItem)element;
            DefaultPartPresentation basicStackPresentation = (DefaultPartPresentation)BasicStackList.this.getTableViewer().getInput();
            IPresentablePart presentablePart = basicStackPresentation.getPartForTab(tabItem);
            return basicStackPresentation.getLabelImage(presentablePart);
        }

        public Font getFont(Object element) {
            CTabItem tabItem = (CTabItem)element;
            CTabFolder tabFolder = tabItem.getParent();
            boolean singleTab = tabFolder.getSingle();
            if (tabItem.isShowing() || singleTab) {
                return null;
            }
            if (this.boldFont == null) {
                Font originalFont = tabItem.getFont();
                FontData[] fontData = originalFont.getFontData();
                for (int i = 0; i < fontData.length; ++i) {
                    fontData[i].setStyle(fontData[i].getStyle() | 1);
                }
                this.boldFont = new Font((Device)tabItem.getDisplay(), fontData);
            }
            return this.boldFont;
        }

        public void dispose() {
            super.dispose();
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
        }
    }

    private class BasicStackListContentProvider
    implements IStructuredContentProvider {
        private DefaultPartPresentation basicStackPresentation;

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.basicStackPresentation == null) {
                return new CTabItem[0];
            }
            PaneFolder tabFolder = this.basicStackPresentation.getTabFolder();
            return tabFolder.getItems();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.basicStackPresentation = (DefaultPartPresentation)newInput;
        }
    }
}

