/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.filemappers;

import org.codehaus.plexus.components.io.filemappers.IdentityMapper;

public class FileExtensionMapper
extends IdentityMapper {
    public static final String ROLE_HINT = "fileExtension";
    private String targetExtension;

    public void setTargetExtension(String pTargetExtension) {
        if (pTargetExtension == null) {
            throw new IllegalArgumentException("The target extension is null.");
        }
        if (pTargetExtension.length() == 0) {
            throw new IllegalArgumentException("The target extension is empty.");
        }
        this.targetExtension = pTargetExtension.charAt(0) == '.' ? pTargetExtension : '.' + pTargetExtension;
    }

    public String getTargetExtension() {
        return this.targetExtension;
    }

    public String getMappedFileName(String pName) {
        String ext = this.getTargetExtension();
        if (ext == null) {
            throw new IllegalStateException("The target extension has not been set.");
        }
        String name = super.getMappedFileName(pName);
        int offset = pName.indexOf(46);
        if (offset == -1) {
            return name + ext;
        }
        return name.substring(0, offset) + ext;
    }
}

