/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.xml;

final class XMLEncode {
    private static final int CDATA_BLOCK_THRESHOLD_LENGTH = 12;
    private static final char DEFAULT_QUOTE_CHAR = '\"';

    XMLEncode() {
    }

    public static boolean isWhiteSpace(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String xmlEncodeTextForAttribute(String text, char quoteChar) {
        if (text == null) {
            return null;
        }
        return XMLEncode.xmlEncodeTextAsPCDATA(text, true, quoteChar);
    }

    public static String xmlEncodeText(String text) {
        String cdata;
        if (text == null) {
            return null;
        }
        if (!XMLEncode.needsEncoding(text)) {
            return text;
        }
        if (text.length() > 12 && (cdata = XMLEncode.xmlEncodeTextAsCDATABlock(text)) != null) {
            return cdata;
        }
        return XMLEncode.xmlEncodeTextAsPCDATA(text);
    }

    public static String xmlEncodeTextAsPCDATA(String text) {
        if (text == null) {
            return null;
        }
        return XMLEncode.xmlEncodeTextAsPCDATA(text, false);
    }

    public static String xmlEncodeTextAsPCDATA(String text, boolean forAttribute) {
        return XMLEncode.xmlEncodeTextAsPCDATA(text, forAttribute, '\"');
    }

    public static String xmlEncodeTextAsPCDATA(String text, boolean forAttribute, char quoteChar) {
        if (text == null) {
            return null;
        }
        StringBuilder n = new StringBuilder(text.length() * 2);
        block9: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    n.append("&amp;");
                    continue block9;
                }
                case '<': {
                    n.append("&lt;");
                    continue block9;
                }
                case '>': {
                    n.append("&gt;");
                    continue block9;
                }
                case '\"': {
                    if (forAttribute) {
                        n.append("&quot;");
                        continue block9;
                    }
                    n.append(c);
                    continue block9;
                }
                case '\'': {
                    if (forAttribute) {
                        n.append("&apos;");
                        continue block9;
                    }
                    n.append(c);
                    continue block9;
                }
                case '\r': {
                    if (forAttribute) {
                        if (i != text.length() && text.charAt(i + 1) == '\n') continue block9;
                        n.append("&#13;");
                        continue block9;
                    }
                    n.append(c);
                    continue block9;
                }
                case '\n': {
                    if (!forAttribute) continue block9;
                    n.append("&#10;");
                    continue block9;
                }
                default: {
                    n.append(c);
                }
            }
        }
        if (forAttribute) {
            n.append(quoteChar);
            n.insert(0, quoteChar);
        }
        return n.toString();
    }

    public static String xmlEncodeTextAsCDATABlock(String text) {
        if (text == null) {
            return null;
        }
        if (XMLEncode.isCompatibleWithCDATABlock(text)) {
            return "<![CDATA[" + text + "]]>";
        }
        return null;
    }

    public static boolean needsEncoding(String text) {
        return XMLEncode.needsEncoding(text, false);
    }

    public static boolean needsEncoding(String data, boolean checkForAttr) {
        if (data == null) {
            return false;
        }
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c != '&' && c != '<' && (!checkForAttr || c != '\"' && c != '\'')) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompatibleWithCDATABlock(String text) {
        return text != null && !text.contains("]]>");
    }

    public static String xmlDecodeTextToCDATA(String pcdata) {
        if (pcdata == null) {
            return null;
        }
        StringBuilder n = new StringBuilder(pcdata.length());
        for (int i = 0; i < pcdata.length(); ++i) {
            char c = pcdata.charAt(i);
            if (c == '&') {
                char c1 = XMLEncode.lookAhead(1, i, pcdata);
                char c2 = XMLEncode.lookAhead(2, i, pcdata);
                char c3 = XMLEncode.lookAhead(3, i, pcdata);
                char c4 = XMLEncode.lookAhead(4, i, pcdata);
                char c5 = XMLEncode.lookAhead(5, i, pcdata);
                if (c1 == 'a' && c2 == 'm' && c3 == 'p' && c4 == ';') {
                    n.append("&");
                    i += 4;
                    continue;
                }
                if (c1 == 'l' && c2 == 't' && c3 == ';') {
                    n.append("<");
                    i += 3;
                    continue;
                }
                if (c1 == 'g' && c2 == 't' && c3 == ';') {
                    n.append(">");
                    i += 3;
                    continue;
                }
                if (c1 == 'q' && c2 == 'u' && c3 == 'o' && c4 == 't' && c5 == ';') {
                    n.append("\"");
                    i += 5;
                    continue;
                }
                if (c1 == 'a' && c2 == 'p' && c3 == 'o' && c4 == 's' && c5 == ';') {
                    n.append("'");
                    i += 5;
                    continue;
                }
                n.append("&");
                continue;
            }
            n.append(c);
        }
        return n.toString();
    }

    private static char lookAhead(int la, int offset, String data) {
        try {
            return data.charAt(offset + la);
        }
        catch (StringIndexOutOfBoundsException e) {
            return '\u0000';
        }
    }

    private static boolean contains(String text, char[] chars) {
        if (text == null || chars == null || chars.length == 0) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            for (char aChar : chars) {
                if (aChar != c) continue;
                return true;
            }
        }
        return false;
    }
}

