<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
    <xsl:output method="text" encoding="UTF-8" doctype-system="xkb.dtd"/>
    <xsl:template match="/xkbConfigRegistry">
        <xsl:text><![CDATA[.\" WARNING: this man page is autogenerated. Do not edit or you will lose all your changes.
.TH XKEYBOARD-CONFIG __miscmansuffix__ __vendorversion__
.SH NAME
xkeyboard-config \- XKB data description files
.SH DESCRIPTION
xkeyboard-config provides the description files for the X Keyboard
Extension (XKB). The configuration options below are usually applied with
setxkbmap(__appmansuffix__).
.SH MODELS
.TS
left,box;
lB lB
___
lB l.
Model	Description
]]></xsl:text>
        <xsl:apply-templates select="modelList"/>
        <xsl:text><![CDATA[
.TE
.SH LAYOUTS
.TS
left,box;
lB lB
____
lB l.
Layout(Variant)	Description
]]></xsl:text>
        <xsl:apply-templates select="layoutList"/>
        <xsl:text><![CDATA[
.TE
.SH OPTIONS
]]></xsl:text>
        <xsl:apply-templates select="optionList"/>
        <xsl:text><![CDATA[
.SH FILES
__xkb_base__/compat

__xkb_base__/compiled

__xkb_base__/geometry

__xkb_base__/keycodes

__xkb_base__/keymap

__xkb_base__/rules

__xkb_base__/semantics

__xkb_base__/symbols

__xkb_base__/types

.SH SEE ALSO
setxkbmap(__appmansuffix__)
]]></xsl:text>
    </xsl:template>

<!-- split model/description into a normal table -->
    <xsl:template match="modelList">
        <xsl:for-each select="model">
            <xsl:value-of select="configItem/name"/><xsl:text>&#9;</xsl:text><xsl:value-of select="configItem/description"/>
            <xsl:text>&#10;</xsl:text>
        </xsl:for-each>
    </xsl:template>

<!-- split layout/variant/description into a table like this

        layout1                 description
        layout1(variant1)       description
        layout1(variant2)       description
        layout2                 description
        layout2(variant1)       description
-->
    <xsl:template match="layoutList">
        <xsl:for-each select="layout">
            <xsl:value-of select="configItem/name"/>
            <xsl:text>&#9;</xsl:text>
            <xsl:value-of select="configItem/description"/>
            <xsl:text>&#10;</xsl:text>
            <xsl:for-each select="variantList/variant">
                <xsl:value-of select="../../configItem/name"/>
                <xsl:text>(</xsl:text>
                <xsl:value-of select="configItem/name"/>
                <xsl:text>)</xsl:text>
                <xsl:text>&#9;</xsl:text>
                <xsl:value-of select="configItem/description"/>
                <xsl:text>&#10;</xsl:text>
            </xsl:for-each>
            <xsl:text>&#10;</xsl:text>
            <xsl:text>_&#10;</xsl:text>
        </xsl:for-each>
    </xsl:template>

<!-- split option into a table like this

option description:
        optarg          description
        optarg          description
        optarg          description

option2 description:
        optarg          description
        optarg          description
-->
    <xsl:template match="optionList">
        <xsl:for-each select="group">
            <xsl:text><![CDATA[
.SS]]></xsl:text>
            <xsl:text>&#10;</xsl:text>
            <xsl:value-of select="configItem/description"/>
            <xsl:text><![CDATA[
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
]]></xsl:text>
            <xsl:for-each select="option">
                <xsl:value-of select="configItem/name"/>
                <xsl:text>&#9;</xsl:text>
                <xsl:value-of select="configItem/description"/>
                <xsl:text>&#10;</xsl:text>
            </xsl:for-each>
            <xsl:text><![CDATA[
.TE

]]></xsl:text>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
