/*	$NetBSD: log2.h,v 1.5 2014/08/06 14:05:08 riastradh Exp $	*/

/*-
 * Copyright (c) 2013 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Taylor R. Campbell.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LINUX_LOG2_H_
#define _LINUX_LOG2_H_

#include <sys/types.h>
#include <sys/bitops.h>

#include <machine/limits.h>

static inline bool
is_power_of_2(unsigned long x)
{
	return ((x != 0) && (((x - 1) & x) == 0));
}

static inline unsigned long
roundup_pow_of_two(unsigned long n)
{
	unsigned i;

	if (n == 0)
		return 1;

	n -= 1;
	for (i = 1; i < CHAR_BIT * sizeof n; i <<= 1)
		n |= (n >> i);

	return (n + 1);
}

static inline unsigned long
rounddown_pow_of_two(unsigned long n)
{

	/* XXX fls64 is not fls_ulong, but it'll do for now.  */
	return (1UL << (fls64(n) - 1));
}

static inline unsigned
order_base_2(unsigned long n)
{

	return ilog2(roundup_pow_of_two(n));
}

#endif  /* _LINUX_LOG2_H_ */
