/*	$NetBSD: imx7_iomuxreg.h,v 1.1 2016/05/17 06:44:45 ryo Exp $	*/

/*
 * Copyright (c) 2015 Internet Initiative Japan, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX7_IOMUXREG_H_
#define _ARM_IMX_IMX7_IOMUXREG_H_

/* IOMUXC GPR (AIPS1_IOMUXC_GPR_BASE:0x30340000) */
#define IOMUXC_GPR_GPR0					0x30340000
#define IOMUXC_GPR_GPR1					0x30340004
#define  IOMUXC_GPR_GPR1_ENET2_CLK_DIR			__BIT(18)
#define  IOMUXC_GPR_GPR1_ENET1_CLK_DIR			__BIT(17)
#define  IOMUXC_GPR_GPR1_ENET2_TX_CLK_SEL		__BIT(14)
#define  IOMUXC_GPR_GPR1_ENET1_TX_CLK_SEL		__BIT(13)
#define IOMUXC_GPR_GPR2					0x30340008
#define IOMUXC_GPR_GPR3					0x3034000c
#define IOMUXC_GPR_GPR4					0x30340010
#define IOMUXC_GPR_GPR5					0x30340014
#define IOMUXC_GPR_GPR6					0x30340018
#define IOMUXC_GPR_GPR7					0x3034001c
#define IOMUXC_GPR_GPR8					0x30340020
#define IOMUXC_GPR_GPR9					0x30340024
#define IOMUXC_GPR_GPR10				0x30340028
#define IOMUXC_GPR_GPR11				0x3034002c
#define IOMUXC_GPR_GPR12				0x30340030
#define IOMUXC_GPR_GPR13				0x30340034
#define IOMUXC_GPR_GPR14				0x30340038
#define IOMUXC_GPR_GPR15				0x3034003c
#define IOMUXC_GPR_GPR16				0x30340040
#define IOMUXC_GPR_GPR17				0x30340044
#define IOMUXC_GPR_GPR18				0x30340048
#define IOMUXC_GPR_GPR19				0x3034004c
#define IOMUXC_GPR_GPR20				0x30340050
#define IOMUXC_GPR_GPR21				0x30340054
#define IOMUXC_GPR_GPR22				0x30340058
#define AIPS1_IOMUXC_GPR_SIZE				0x00000060

/* IOMUXC (AIPS1_IOMUXC_BASE:0x30330000) */
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO08		0x30330014
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO09		0x30330018
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO10		0x3033001c
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO11		0x30330020
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO12		0x30330024
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO13		0x30330028
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO14		0x3033002c
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO15		0x30330030
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00		0x30330034
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01		0x30330038
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02		0x3033003c
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03		0x30330040
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04		0x30330044
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05		0x30330048
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06		0x3033004c
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07		0x30330050
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA08		0x30330054
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA09		0x30330058
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA10		0x3033005c
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA11		0x30330060
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA12		0x30330064
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA13		0x30330068
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA14		0x3033006c
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA15		0x30330070
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK		0x30330074
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE			0x30330078
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE			0x3033007c
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDSHR		0x30330080
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE0		0x30330084
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1		0x30330088
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE2		0x3033008c
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE3		0x30330090
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK		0x30330094
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE			0x30330098
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL			0x3033009c
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP			0x303300a0
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR0			0x303300a4
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR1			0x303300a8
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_COM		0x303300ac
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_STAT		0x303300b0
#define IOMUXC_SW_MUX_CTL_PAD_LCD_CLK			0x303300b4
#define IOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE		0x303300b8
#define IOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC			0x303300bc
#define IOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC			0x303300c0
#define IOMUXC_SW_MUX_CTL_PAD_LCD_RESET			0x303300c4
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA00		0x303300c8
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA01		0x303300cc
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA02		0x303300d0
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA03		0x303300d4
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA04		0x303300d8
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA05		0x303300dc
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA06		0x303300e0
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA07		0x303300e4
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA08		0x303300e8
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA09		0x303300ec
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA10		0x303300f0
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA11		0x303300f4
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA12		0x303300f8
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA13		0x303300fc
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA14		0x30330100
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA15		0x30330104
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA16		0x30330108
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA17		0x3033010c
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA18		0x30330110
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA19		0x30330114
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA20		0x30330118
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA21		0x3033011c
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA22		0x30330120
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA23		0x30330124
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA		0x30330128
#define IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA		0x3033012c
#define IOMUXC_SW_MUX_CTL_PAD_UART2_RX_DATA		0x30330130
#define IOMUXC_SW_MUX_CTL_PAD_UART2_TX_DATA		0x30330134
#define IOMUXC_SW_MUX_CTL_PAD_UART3_RX_DATA		0x30330138
#define IOMUXC_SW_MUX_CTL_PAD_UART3_TX_DATA		0x3033013c
#define IOMUXC_SW_MUX_CTL_PAD_UART3_RTS_B		0x30330140
#define IOMUXC_SW_MUX_CTL_PAD_UART3_CTS_B		0x30330144
#define IOMUXC_SW_MUX_CTL_PAD_I2C1_SCL			0x30330148
#define IOMUXC_SW_MUX_CTL_PAD_I2C1_SDA			0x3033014c
#define IOMUXC_SW_MUX_CTL_PAD_I2C2_SCL			0x30330150
#define IOMUXC_SW_MUX_CTL_PAD_I2C2_SDA			0x30330154
#define IOMUXC_SW_MUX_CTL_PAD_I2C3_SCL			0x30330158
#define IOMUXC_SW_MUX_CTL_PAD_I2C3_SDA			0x3033015c
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SCL			0x30330160
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SDA			0x30330164
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK		0x30330168
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI		0x3033016c
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MISO		0x30330170
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SS0		0x30330174
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_SCLK		0x30330178
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_MOSI		0x3033017c
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_MISO		0x30330180
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_SS0		0x30330184
#define IOMUXC_SW_MUX_CTL_PAD_SD1_CD_B			0x30330188
#define IOMUXC_SW_MUX_CTL_PAD_SD1_WP			0x3033018c
#define IOMUXC_SW_MUX_CTL_PAD_SD1_RESET_B		0x30330190
#define IOMUXC_SW_MUX_CTL_PAD_SD1_CLK			0x30330194
#define IOMUXC_SW_MUX_CTL_PAD_SD1_CMD			0x30330198
#define IOMUXC_SW_MUX_CTL_PAD_SD1_DATA0			0x3033019c
#define IOMUXC_SW_MUX_CTL_PAD_SD1_DATA1			0x303301a0
#define IOMUXC_SW_MUX_CTL_PAD_SD1_DATA2			0x303301a4
#define IOMUXC_SW_MUX_CTL_PAD_SD1_DATA3			0x303301a8
#define IOMUXC_SW_MUX_CTL_PAD_SD2_CD_B			0x303301ac
#define IOMUXC_SW_MUX_CTL_PAD_SD2_WP			0x303301b0
#define IOMUXC_SW_MUX_CTL_PAD_SD2_RESET_B		0x303301b4
#define IOMUXC_SW_MUX_CTL_PAD_SD2_CLK			0x303301b8
#define IOMUXC_SW_MUX_CTL_PAD_SD2_CMD			0x303301bc
#define IOMUXC_SW_MUX_CTL_PAD_SD2_DATA0			0x303301c0
#define IOMUXC_SW_MUX_CTL_PAD_SD2_DATA1			0x303301c4
#define IOMUXC_SW_MUX_CTL_PAD_SD2_DATA2			0x303301c8
#define IOMUXC_SW_MUX_CTL_PAD_SD2_DATA3			0x303301cc
#define IOMUXC_SW_MUX_CTL_PAD_SD3_CLK			0x303301d0
#define IOMUXC_SW_MUX_CTL_PAD_SD3_CMD			0x303301d4
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA0			0x303301d8
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA1			0x303301dc
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA2			0x303301e0
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA3			0x303301e4
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA4			0x303301e8
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA5			0x303301ec
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA6			0x303301f0
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA7			0x303301f4
#define IOMUXC_SW_MUX_CTL_PAD_SD3_STROBE		0x303301f8
#define IOMUXC_SW_MUX_CTL_PAD_SD3_RESET_B		0x303301fc
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_RX_DATA		0x30330200
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_TX_BCLK		0x30330204
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_TX_SYNC		0x30330208
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_TX_DATA		0x3033020c
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_RX_SYNC		0x30330210
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_RX_BCLK		0x30330214
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_MCLK			0x30330218
#define IOMUXC_SW_MUX_CTL_PAD_SAI2_TX_SYNC		0x3033021c
#define IOMUXC_SW_MUX_CTL_PAD_SAI2_TX_BCLK		0x30330220
#define IOMUXC_SW_MUX_CTL_PAD_SAI2_RX_DATA		0x30330224
#define IOMUXC_SW_MUX_CTL_PAD_SAI2_TX_DATA		0x30330228
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RD0		0x3033022c
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RD1		0x30330230
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RD2		0x30330234
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RD3		0x30330238
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RX_CTL	0x3033023c
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RXC		0x30330240
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TD0		0x30330244
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TD1		0x30330248
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TD2		0x3033024c
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TD3		0x30330250
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TX_CTL	0x30330254
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TXC		0x30330258
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_TX_CLK		0x3033025c
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RX_CLK		0x30330260
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_CRS			0x30330264
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_COL			0x30330268
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO08		0x3033026c
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO09		0x30330270
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO10		0x30330274
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO11		0x30330278
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO12		0x3033027c
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO13		0x30330280
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO14		0x30330284
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO15		0x30330288
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_MOD			0x3033028c
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TCK			0x30330290
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TDI			0x30330294
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TDO			0x30330298
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TMS			0x3033029c
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TRST_B		0x303302a0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00		0x303302a4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01		0x303302a8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02		0x303302ac
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03		0x303302b0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04		0x303302b4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05		0x303302b8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06		0x303302bc
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07		0x303302c0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08		0x303302c4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09		0x303302c8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10		0x303302cc
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11		0x303302d0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12		0x303302d4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13		0x303302d8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14		0x303302dc
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15		0x303302e0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK		0x303302e4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE			0x303302e8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE			0x303302ec
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR		0x303302f0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0		0x303302f4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1		0x303302f8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2		0x303302fc
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3		0x30330300
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK		0x30330304
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE			0x30330308
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL			0x3033030c
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP			0x30330310
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0			0x30330314
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1			0x30330318
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM		0x3033031c
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT		0x30330320
#define IOMUXC_SW_PAD_CTL_PAD_LCD_CLK			0x30330324
#define IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE		0x30330328
#define IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC			0x3033032c
#define IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC			0x30330330
#define IOMUXC_SW_PAD_CTL_PAD_LCD_RESET			0x30330334
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00		0x30330338
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01		0x3033033c
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02		0x30330340
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03		0x30330344
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04		0x30330348
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05		0x3033034c
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06		0x30330350
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07		0x30330354
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08		0x30330358
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09		0x3033035c
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10		0x30330360
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11		0x30330364
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12		0x30330368
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13		0x3033036c
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14		0x30330370
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15		0x30330374
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16		0x30330378
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17		0x3033037c
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18		0x30330380
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19		0x30330384
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20		0x30330388
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21		0x3033038c
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22		0x30330390
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23		0x30330394
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA		0x30330398
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA		0x3033039c
#define IOMUXC_SW_PAD_CTL_PAD_UART2_RX_DATA		0x303303a0
#define IOMUXC_SW_PAD_CTL_PAD_UART2_TX_DATA		0x303303a4
#define IOMUXC_SW_PAD_CTL_PAD_UART3_RX_DATA		0x303303a8
#define IOMUXC_SW_PAD_CTL_PAD_UART3_TX_DATA		0x303303ac
#define IOMUXC_SW_PAD_CTL_PAD_UART3_RTS_B		0x303303b0
#define IOMUXC_SW_PAD_CTL_PAD_UART3_CTS_B		0x303303b4
#define IOMUXC_SW_PAD_CTL_PAD_I2C1_SCL			0x303303b8
#define IOMUXC_SW_PAD_CTL_PAD_I2C1_SDA			0x303303bc
#define IOMUXC_SW_PAD_CTL_PAD_I2C2_SCL			0x303303c0
#define IOMUXC_SW_PAD_CTL_PAD_I2C2_SDA			0x303303c4
#define IOMUXC_SW_PAD_CTL_PAD_I2C3_SCL			0x303303c8
#define IOMUXC_SW_PAD_CTL_PAD_I2C3_SDA			0x303303cc
#define IOMUXC_SW_PAD_CTL_PAD_I2C4_SCL			0x303303d0
#define IOMUXC_SW_PAD_CTL_PAD_I2C4_SDA			0x303303d4
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK		0x303303d8
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI		0x303303dc
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MISO		0x303303e0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SS0		0x303303e4
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_SCLK		0x303303e8
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_MOSI		0x303303ec
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_MISO		0x303303f0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_SS0		0x303303f4
#define IOMUXC_SW_PAD_CTL_PAD_SD1_CD_B			0x303303f8
#define IOMUXC_SW_PAD_CTL_PAD_SD1_WP			0x303303fc
#define IOMUXC_SW_PAD_CTL_PAD_SD1_RESET_B		0x30330400
#define IOMUXC_SW_PAD_CTL_PAD_SD1_CLK			0x30330404
#define IOMUXC_SW_PAD_CTL_PAD_SD1_CMD			0x30330408
#define IOMUXC_SW_PAD_CTL_PAD_SD1_DATA0			0x3033040c
#define IOMUXC_SW_PAD_CTL_PAD_SD1_DATA1			0x30330410
#define IOMUXC_SW_PAD_CTL_PAD_SD1_DATA2			0x30330414
#define IOMUXC_SW_PAD_CTL_PAD_SD1_DATA3			0x30330418
#define IOMUXC_SW_PAD_CTL_PAD_SD2_CD_B			0x3033041c
#define IOMUXC_SW_PAD_CTL_PAD_SD2_WP			0x30330420
#define IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_B		0x30330424
#define IOMUXC_SW_PAD_CTL_PAD_SD2_CLK			0x30330428
#define IOMUXC_SW_PAD_CTL_PAD_SD2_CMD			0x3033042c
#define IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0			0x30330430
#define IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1			0x30330434
#define IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2			0x30330438
#define IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3			0x3033043c
#define IOMUXC_SW_PAD_CTL_PAD_SD3_CLK			0x30330440
#define IOMUXC_SW_PAD_CTL_PAD_SD3_CMD			0x30330444
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA0			0x30330448
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA1			0x3033044c
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA2			0x30330450
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA3			0x30330454
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA4			0x30330458
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA5			0x3033045c
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA6			0x30330460
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA7			0x30330464
#define IOMUXC_SW_PAD_CTL_PAD_SD3_STROBE		0x30330468
#define IOMUXC_SW_PAD_CTL_PAD_SD3_RESET_B		0x3033046c
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_RX_DATA		0x30330470
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_TX_BCLK		0x30330474
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_TX_SYNC		0x30330478
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_TX_DATA		0x3033047c
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_RX_SYNC		0x30330480
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_RX_BCLK		0x30330484
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_MCLK			0x30330488
#define IOMUXC_SW_PAD_CTL_PAD_SAI2_TX_SYNC		0x3033048c
#define IOMUXC_SW_PAD_CTL_PAD_SAI2_TX_BCLK		0x30330490
#define IOMUXC_SW_PAD_CTL_PAD_SAI2_RX_DATA		0x30330494
#define IOMUXC_SW_PAD_CTL_PAD_SAI2_TX_DATA		0x30330498
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RD0		0x3033049c
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RD1		0x303304a0
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RD2		0x303304a4
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RD3		0x303304a8
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RX_CTL	0x303304ac
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RXC		0x303304b0
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TD0		0x303304b4
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TD1		0x303304b8
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TD2		0x303304bc
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TD3		0x303304c0
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TX_CTL	0x303304c4
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TXC		0x303304c8
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_TX_CLK		0x303304cc
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RX_CLK		0x303304d0
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_CRS			0x303304d4
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_COL			0x303304d8
#define IOMUXC_FLEXCAN1_RX_SELECT_INPUT			0x303304dc
#define IOMUXC_FLEXCAN2_RX_SELECT_INPUT			0x303304e0
#define IOMUXC_CCM_EXT_CLK_1_SELECT_INPUT		0x303304e4
#define IOMUXC_CCM_EXT_CLK_2_SELECT_INPUT		0x303304e8
#define IOMUXC_CCM_EXT_CLK_3_SELECT_INPUT		0x303304ec
#define IOMUXC_CCM_EXT_CLK_4_SELECT_INPUT		0x303304f0
#define IOMUXC_CCM_PMIC_READY_SELECT_INPUT		0x303304f4
#define IOMUXC_CSI_DATA2_SELECT_INPUT			0x303304f8
#define IOMUXC_CSI_DATA3_SELECT_INPUT			0x303304fc
#define IOMUXC_CSI_DATA4_SELECT_INPUT			0x30330500
#define IOMUXC_CSI_DATA5_SELECT_INPUT			0x30330504
#define IOMUXC_CSI_DATA6_SELECT_INPUT			0x30330508
#define IOMUXC_CSI_DATA7_SELECT_INPUT			0x3033050c
#define IOMUXC_CSI_DATA8_SELECT_INPUT			0x30330510
#define IOMUXC_CSI_DATA9_SELECT_INPUT			0x30330514
#define IOMUXC_CSI_HSYNC_SELECT_INPUT			0x30330518
#define IOMUXC_CSI_PIXCLK_SELECT_INPUT			0x3033051c
#define IOMUXC_CSI_VSYNC_SELECT_INPUT			0x30330520
#define IOMUXC_ECSPI1_SCLK_SELECT_INPUT			0x30330524
#define IOMUXC_ECSPI1_MISO_SELECT_INPUT			0x30330528
#define IOMUXC_ECSPI1_MOSI_SELECT_INPUT			0x3033052c
#define IOMUXC_ECSPI1_SS0_B_SELECT_INPUT		0x30330530
#define IOMUXC_ECSPI2_SCLK_SELECT_INPUT			0x30330534
#define IOMUXC_ECSPI2_MISO_SELECT_INPUT			0x30330538
#define IOMUXC_ECSPI2_MOSI_SELECT_INPUT			0x3033053c
#define IOMUXC_ECSPI2_SS0_B_SELECT_INPUT		0x30330540
#define IOMUXC_ECSPI3_SCLK_SELECT_INPUT			0x30330544
#define IOMUXC_ECSPI3_MISO_SELECT_INPUT			0x30330548
#define IOMUXC_ECSPI3_MOSI_SELECT_INPUT			0x3033054c
#define IOMUXC_ECSPI3_SS0_B_SELECT_INPUT		0x30330550
#define IOMUXC_ECSPI4_SCLK_SELECT_INPUT			0x30330554
#define IOMUXC_ECSPI4_MISO_SELECT_INPUT			0x30330558
#define IOMUXC_ECSPI4_MOSI_SELECT_INPUT			0x3033055c
#define IOMUXC_ECSPI4_SS0_B_SELECT_INPUT		0x30330560
#define IOMUXC_CCM_ENET1_REF_CLK_SELECT_INPUT		0x30330564
#define IOMUXC_ENET1_MDIO_SELECT_INPUT			0x30330568
#define IOMUXC_ENET1_RX_CLK_SELECT_INPUT		0x3033056c
#define IOMUXC_CCM_ENET2_REF_CLK_SELECT_INPUT		0x30330570
#define IOMUXC_ENET2_MDIO_SELECT_INPUT			0x30330574
#define IOMUXC_ENET2_RX_CLK_SELECT_INPUT		0x30330578
#define IOMUXC_EPDC_PWR_IRQ_SELECT_INPUT		0x3033057c
#define IOMUXC_EPDC_PWR_STAT_SELECT_INPUT		0x30330580
#define IOMUXC_FLEXTIMER1_CH0_SELECT_INPUT		0x30330584
#define IOMUXC_FLEXTIMER1_CH1_SELECT_INPUT		0x30330588
#define IOMUXC_FLEXTIMER1_CH2_SELECT_INPUT		0x3033058c
#define IOMUXC_FLEXTIMER1_CH3_SELECT_INPUT		0x30330590
#define IOMUXC_FLEXTIMER1_CH4_SELECT_INPUT		0x30330594
#define IOMUXC_FLEXTIMER1_CH5_SELECT_INPUT		0x30330598
#define IOMUXC_FLEXTIMER1_CH6_SELECT_INPUT		0x3033059c
#define IOMUXC_FLEXTIMER1_CH7_SELECT_INPUT		0x303305a0
#define IOMUXC_FLEXTIMER1_PHA_SELECT_INPUT		0x303305a4
#define IOMUXC_FLEXTIMER1_PHB_SELECT_INPUT		0x303305a8
#define IOMUXC_FLEXTIMER2_CH0_SELECT_INPUT		0x303305ac
#define IOMUXC_FLEXTIMER2_CH1_SELECT_INPUT		0x303305b0
#define IOMUXC_FLEXTIMER2_CH2_SELECT_INPUT		0x303305b4
#define IOMUXC_FLEXTIMER2_CH3_SELECT_INPUT		0x303305b8
#define IOMUXC_FLEXTIMER2_CH4_SELECT_INPUT		0x303305bc
#define IOMUXC_FLEXTIMER2_CH5_SELECT_INPUT		0x303305c0
#define IOMUXC_FLEXTIMER2_CH6_SELECT_INPUT		0x303305c4
#define IOMUXC_FLEXTIMER2_CH7_SELECT_INPUT		0x303305c8
#define IOMUXC_FLEXTIMER2_PHA_SELECT_INPUT		0x303305cc
#define IOMUXC_FLEXTIMER2_PHB_SELECT_INPUT		0x303305d0
#define IOMUXC_I2C1_SCL_SELECT_INPUT			0x303305d4
#define IOMUXC_I2C1_SDA_SELECT_INPUT			0x303305d8
#define IOMUXC_I2C2_SCL_SELECT_INPUT			0x303305dc
#define IOMUXC_I2C2_SDA_SELECT_INPUT			0x303305e0
#define IOMUXC_I2C3_SCL_SELECT_INPUT			0x303305e4
#define IOMUXC_I2C3_SDA_SELECT_INPUT			0x303305e8
#define IOMUXC_I2C4_SCL_SELECT_INPUT			0x303305ec
#define IOMUXC_I2C4_SDA_SELECT_INPUT			0x303305f0
#define IOMUXC_KPP_COL0_SELECT_INPUT			0x303305f4
#define IOMUXC_KPP_COL1_SELECT_INPUT			0x303305f8
#define IOMUXC_KPP_COL2_SELECT_INPUT			0x303305fc
#define IOMUXC_KPP_COL3_SELECT_INPUT			0x30330600
#define IOMUXC_KPP_COL4_SELECT_INPUT			0x30330604
#define IOMUXC_KPP_COL5_SELECT_INPUT			0x30330608
#define IOMUXC_KPP_COL6_SELECT_INPUT			0x3033060c
#define IOMUXC_KPP_COL7_SELECT_INPUT			0x30330610
#define IOMUXC_KPP_ROW0_SELECT_INPUT			0x30330614
#define IOMUXC_KPP_ROW1_SELECT_INPUT			0x30330618
#define IOMUXC_KPP_ROW2_SELECT_INPUT			0x3033061c
#define IOMUXC_KPP_ROW3_SELECT_INPUT			0x30330620
#define IOMUXC_KPP_ROW4_SELECT_INPUT			0x30330624
#define IOMUXC_KPP_ROW5_SELECT_INPUT			0x30330628
#define IOMUXC_KPP_ROW6_SELECT_INPUT			0x3033062c
#define IOMUXC_KPP_ROW7_SELECT_INPUT			0x30330630
#define IOMUXC_LCD_BUSY_SELECT_INPUT			0x30330634
#define IOMUXC_LCD_DATA00_SELECT_INPUT			0x30330638
#define IOMUXC_LCD_DATA01_SELECT_INPUT			0x3033063c
#define IOMUXC_LCD_DATA02_SELECT_INPUT			0x30330640
#define IOMUXC_LCD_DATA03_SELECT_INPUT			0x30330644
#define IOMUXC_LCD_DATA04_SELECT_INPUT			0x30330648
#define IOMUXC_LCD_DATA05_SELECT_INPUT			0x3033064c
#define IOMUXC_LCD_DATA06_SELECT_INPUT			0x30330650
#define IOMUXC_LCD_DATA07_SELECT_INPUT			0x30330654
#define IOMUXC_LCD_DATA08_SELECT_INPUT			0x30330658
#define IOMUXC_LCD_DATA09_SELECT_INPUT			0x3033065c
#define IOMUXC_LCD_DATA10_SELECT_INPUT			0x30330660
#define IOMUXC_LCD_DATA11_SELECT_INPUT			0x30330664
#define IOMUXC_LCD_DATA12_SELECT_INPUT			0x30330668
#define IOMUXC_LCD_DATA13_SELECT_INPUT			0x3033066c
#define IOMUXC_LCD_DATA14_SELECT_INPUT			0x30330670
#define IOMUXC_LCD_DATA15_SELECT_INPUT			0x30330674
#define IOMUXC_LCD_DATA16_SELECT_INPUT			0x30330678
#define IOMUXC_LCD_DATA17_SELECT_INPUT			0x3033067c
#define IOMUXC_LCD_DATA18_SELECT_INPUT			0x30330680
#define IOMUXC_LCD_DATA19_SELECT_INPUT			0x30330684
#define IOMUXC_LCD_DATA20_SELECT_INPUT			0x30330688
#define IOMUXC_LCD_DATA21_SELECT_INPUT			0x3033068c
#define IOMUXC_LCD_DATA22_SELECT_INPUT			0x30330690
#define IOMUXC_LCD_DATA23_SELECT_INPUT			0x30330694
#define IOMUXC_LCD_VSYNC_SELECT_INPUT			0x30330698
#define IOMUXC_SAI1_RX_BCLK_SELECT_INPUT		0x3033069c
#define IOMUXC_SAI1_RX_DATA_SELECT_INPUT		0x303306a0
#define IOMUXC_SAI1_RX_SYNC_SELECT_INPUT		0x303306a4
#define IOMUXC_SAI1_TX_BCLK_SELECT_INPUT		0x303306a8
#define IOMUXC_SAI1_TX_SYNC_SELECT_INPUT		0x303306ac
#define IOMUXC_SAI2_RX_BCLK_SELECT_INPUT		0x303306b0
#define IOMUXC_SAI2_RX_DATA_SELECT_INPUT		0x303306b4
#define IOMUXC_SAI2_RX_SYNC_SELECT_INPUT		0x303306b8
#define IOMUXC_SAI2_TX_BCLK_SELECT_INPUT		0x303306bc
#define IOMUXC_SAI2_TX_SYNC_SELECT_INPUT		0x303306c0
#define IOMUXC_SAI3_RX_BCLK_SELECT_INPUT		0x303306c4
#define IOMUXC_SAI3_RX_DATA_SELECT_INPUT		0x303306c8
#define IOMUXC_SAI3_RX_SYNC_SELECT_INPUT		0x303306cc
#define IOMUXC_SAI3_TX_BCLK_SELECT_INPUT		0x303306d0
#define IOMUXC_SAI3_TX_SYNC_SELECT_INPUT		0x303306d4
#define IOMUXC_SDMA_EVENTS0_SELECT_INPUT		0x303306d8
#define IOMUXC_SDMA_EVENTS1_SELECT_INPUT		0x303306dc
#define IOMUXC_SIM1_PORT1_PD_SELECT_INPUT		0x303306e0
#define IOMUXC_SIM1_PORT1_TRXD_SELECT_INPUT		0x303306e4
#define IOMUXC_SIM2_PORT1_PD_SELECT_INPUT		0x303306e8
#define IOMUXC_SIM2_PORT1_TRXD_SELECT_INPUT		0x303306ec
#define IOMUXC_UART1_RTS_B_SELECT_INPUT			0x303306f0
#define IOMUXC_UART1_RX_DATA_SELECT_INPUT		0x303306f4
#define IOMUXC_UART2_RTS_B_SELECT_INPUT			0x303306f8
#define IOMUXC_UART2_RX_DATA_SELECT_INPUT		0x303306fc
#define IOMUXC_UART3_RTS_B_SELECT_INPUT			0x30330700
#define IOMUXC_UART3_RX_DATA_SELECT_INPUT		0x30330704
#define IOMUXC_UART4_RTS_B_SELECT_INPUT			0x30330708
#define IOMUXC_UART4_RX_DATA_SELECT_INPUT		0x3033070c
#define IOMUXC_UART5_RTS_B_SELECT_INPUT			0x30330710
#define IOMUXC_UART5_RX_DATA_SELECT_INPUT		0x30330714
#define IOMUXC_UART6_RTS_B_SELECT_INPUT			0x30330718
#define IOMUXC_UART6_RX_DATA_SELECT_INPUT		0x3033071c
#define IOMUXC_UART7_RTS_B_SELECT_INPUT			0x30330720
#define IOMUXC_UART7_RX_DATA_SELECT_INPUT		0x30330724
#define IOMUXC_USB_OTG2_OC_SELECT_INPUT			0x30330728
#define IOMUXC_USB_OTG1_OC_SELECT_INPUT			0x3033072c
#define IOMUXC_USB_OTG2_ID_SELECT_INPUT			0x30330730
#define IOMUXC_USB_OTG1_ID_SELECT_INPUT			0x30330734
#define IOMUXC_SD3_CD_B_SELECT_INPUT			0x30330738
#define IOMUXC_SD3_WP_SELECT_INPUT			0x3033073c
#define AIPS1_IOMUXC_SIZE				0x00000740

/* IOMUXC LPSR (AIPS1_IOMUXC_LPSR_BASE:0x302c0000) */
#define IOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO1_IO00		0x302c0000
#define IOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO1_IO01		0x302c0004
#define IOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO1_IO02		0x302c0008
#define IOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO1_IO03		0x302c000c
#define IOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO1_IO04		0x302c0010
#define IOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO1_IO05		0x302c0014
#define IOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO1_IO06		0x302c0018
#define IOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO1_IO07		0x302c001c
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_TEST_MODE		0x302c0020
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_SRC_POR_B		0x302c0024
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_BOOT_MODE0		0x302c0028
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_BOOT_MODE1		0x302c002c
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO1_IO00		0x302c0030
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO1_IO01		0x302c0034
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO1_IO02		0x302c0038
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO1_IO03		0x302c003c
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO1_IO04		0x302c0040
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO1_IO05		0x302c0044
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO1_IO06		0x302c0048
#define IOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO1_IO07		0x302c004c
#define AIPS1_IOMUXC_LPSR_SIZE				0x00000050

/* IOMUXC LPSR GPR (AIPS1_IOMUXC_LPSR_GPR_BASE:0x30270000) */
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR0		0x30270000
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR1		0x30270004
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR2		0x30270008
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR3		0x3027000c
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR4		0x30270010
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR5		0x30270014
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR7		0x3027001c
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR8		0x30270020
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR9		0x30270024
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR6		0x30270028
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR10		0x30270028
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR11		0x3027002c
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR12		0x30270030
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR13		0x30270034
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR14		0x30270038
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR15		0x3027003c
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR16		0x30270040
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR17		0x30270044
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR18		0x30270048
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR19		0x3027004c
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR20		0x30270050
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR21		0x30270054
#define IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR22		0x30270058
#define AIPS1_IOMUXC_LPSR_GPR_SIZE			0x00000060

/* IOMUXC_SW_MUX_CTL_PAD_xxx */
#define IOMUX_CONFIG_SION	__BIT(4)
#define IOMUX_CONFIG_ALT0	0
#define IOMUX_CONFIG_ALT1	1
#define IOMUX_CONFIG_ALT2	2
#define IOMUX_CONFIG_ALT3	3
#define IOMUX_CONFIG_ALT4	4
#define IOMUX_CONFIG_ALT5	5
#define IOMUX_CONFIG_ALT6	6
#define IOMUX_CONFIG_ALT7	7
#define IOMUX_CONFIG_ALT8	8
/* IOMUXC_SW_PAD_CTL_PAD_xxx */
#define PAD_CTL_PS_MASK				__BITS(6, 5)
#define PAD_CTL_PS_100K_PD			__SHIFTIN(0x0, PAD_CTL_PS_MASK)
#define PAD_CTL_PS_5K_PU			__SHIFTIN(0x1, PAD_CTL_PS_MASK)
#define PAD_CTL_PS_47K_PU			__SHIFTIN(0x2, PAD_CTL_PS_MASK)
#define PAD_CTL_PS_100K_PU			__SHIFTIN(0x3, PAD_CTL_PS_MASK)
#define PAD_CTL_PE				__BIT(4)
#define PAD_CTL_PULL_DISABLE			0
#define PAD_CTL_PULL_ENABLE			PAD_CTL_PE
#define PAD_CTL_HYS				__BIT(3)
#define PAD_CTL_HYSTERESIS_DISABLE		0
#define PAD_CTL_HYSTERESIS_ENABLE		PAD_CTL_HYS
#define PAD_CTL_SRE				__BIT(2)
#define PAD_CTL_SRE_FAST			0
#define PAD_CTL_SRE_SLOW			PAD_CTL_SRE
#define PAD_CTL_DSE_MASK			__BITS(0, 1)
#define PAD_CTL_DSE_X1				__SHIFTIN(0x0, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_X2				__SHIFTIN(0x1, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_X4				__SHIFTIN(0x2, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_X6				__SHIFTIN(0x3, PAD_CTL_DSE_MASK)
/* IOMUXC_SW_PAD_CTL_PAD_xxx */
#define INPUT_DAISY_0		0
#define INPUT_DAISY_1		1
#define INPUT_DAISY_2		2
#define INPUT_DAISY_3		3
#define INPUT_DAISY_4		4
#define INPUT_DAISY_5		5
#define INPUT_DAISY_6		6
#define INPUT_DAISY_7		7

#endif /* _ARM_IMX_IMX7_IOMUXREG_H_ */
