/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlEventReader;
import org.ovirt.engine.sdk4.services.EventService;
import org.ovirt.engine.sdk4.types.Event;

public class EventServiceImpl
extends ServiceImpl
implements EventService {
    public EventServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public EventService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public EventService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "EventService:" + this.getPath();
    }

    private class RemoveResponseImpl
    implements EventService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<EventService.RemoveRequest, EventService.RemoveResponse>
    implements EventService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public EventService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public EventService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(EventServiceImpl.this.getConnection().getUrl() + EventServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = EventServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            EventServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements EventService.GetResponse {
        private Event event;

        private GetResponseImpl() {
        }

        public void event(Event event) {
            this.event = event;
        }

        @Override
        public Event event() {
            return this.event;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<EventService.GetRequest, EventService.GetResponse>
    implements EventService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public EventService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public EventService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(EventServiceImpl.this.getConnection().getUrl() + EventServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = EventServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.event(XmlEventReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            EventServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

