/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.CustomPropertyBuilder;
import org.ovirt.engine.sdk4.builders.NetworkBuilder;
import org.ovirt.engine.sdk4.builders.NetworkFilterBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.QosBuilder;
import org.ovirt.engine.sdk4.builders.VnicPassThroughBuilder;
import org.ovirt.engine.sdk4.internal.containers.VnicProfileContainer;
import org.ovirt.engine.sdk4.types.CustomProperty;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.NetworkFilter;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Qos;
import org.ovirt.engine.sdk4.types.VnicPassThrough;
import org.ovirt.engine.sdk4.types.VnicProfile;

public class VnicProfileBuilder {
    private String comment;
    private List<CustomProperty> customProperties;
    private String description;
    private VnicProfile failover;
    private String href;
    private String id;
    private Boolean migratable;
    private String name;
    private Network network;
    private NetworkFilter networkFilter;
    private VnicPassThrough passThrough;
    private List<Permission> permissions;
    private Boolean portMirroring;
    private Qos qos;

    public VnicProfileBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public VnicProfileBuilder customProperties(List<CustomProperty> newCustomProperties) {
        if (newCustomProperties != null) {
            if (this.customProperties == null) {
                this.customProperties = new ArrayList<CustomProperty>(newCustomProperties);
            } else {
                this.customProperties.addAll(newCustomProperties);
            }
        }
        return this;
    }

    public VnicProfileBuilder customProperties(CustomProperty ... newCustomProperties) {
        if (newCustomProperties != null) {
            if (this.customProperties == null) {
                this.customProperties = new ArrayList<CustomProperty>(newCustomProperties.length);
            }
            Collections.addAll(this.customProperties, newCustomProperties);
        }
        return this;
    }

    public VnicProfileBuilder customProperties(CustomPropertyBuilder ... newCustomProperties) {
        if (newCustomProperties != null) {
            if (this.customProperties == null) {
                this.customProperties = new ArrayList<CustomProperty>(newCustomProperties.length);
            }
            for (CustomPropertyBuilder builder : newCustomProperties) {
                this.customProperties.add(builder.build());
            }
        }
        return this;
    }

    public VnicProfileBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public VnicProfileBuilder failover(VnicProfile newFailover) {
        this.failover = newFailover;
        return this;
    }

    public VnicProfileBuilder failover(VnicProfileBuilder newFailover) {
        this.failover = newFailover == null ? null : newFailover.build();
        return this;
    }

    public VnicProfileBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public VnicProfileBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public VnicProfileBuilder migratable(boolean newMigratable) {
        this.migratable = newMigratable;
        return this;
    }

    public VnicProfileBuilder migratable(Boolean newMigratable) {
        this.migratable = newMigratable;
        return this;
    }

    public VnicProfileBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public VnicProfileBuilder network(Network newNetwork) {
        this.network = newNetwork;
        return this;
    }

    public VnicProfileBuilder network(NetworkBuilder newNetwork) {
        this.network = newNetwork == null ? null : newNetwork.build();
        return this;
    }

    public VnicProfileBuilder networkFilter(NetworkFilter newNetworkFilter) {
        this.networkFilter = newNetworkFilter;
        return this;
    }

    public VnicProfileBuilder networkFilter(NetworkFilterBuilder newNetworkFilter) {
        this.networkFilter = newNetworkFilter == null ? null : newNetworkFilter.build();
        return this;
    }

    public VnicProfileBuilder passThrough(VnicPassThrough newPassThrough) {
        this.passThrough = newPassThrough;
        return this;
    }

    public VnicProfileBuilder passThrough(VnicPassThroughBuilder newPassThrough) {
        this.passThrough = newPassThrough == null ? null : newPassThrough.build();
        return this;
    }

    public VnicProfileBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public VnicProfileBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public VnicProfileBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public VnicProfileBuilder portMirroring(boolean newPortMirroring) {
        this.portMirroring = newPortMirroring;
        return this;
    }

    public VnicProfileBuilder portMirroring(Boolean newPortMirroring) {
        this.portMirroring = newPortMirroring;
        return this;
    }

    public VnicProfileBuilder qos(Qos newQos) {
        this.qos = newQos;
        return this;
    }

    public VnicProfileBuilder qos(QosBuilder newQos) {
        this.qos = newQos == null ? null : newQos.build();
        return this;
    }

    public VnicProfile build() {
        VnicProfileContainer container = new VnicProfileContainer();
        container.comment(this.comment);
        container.customProperties(this.customProperties);
        container.description(this.description);
        container.failover(this.failover);
        container.href(this.href);
        container.id(this.id);
        container.migratable(this.migratable);
        container.name(this.name);
        container.network(this.network);
        container.networkFilter(this.networkFilter);
        container.passThrough(this.passThrough);
        container.permissions(this.permissions);
        container.portMirroring(this.portMirroring);
        container.qos(this.qos);
        return container;
    }
}

