/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.GlusterBrickBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.GlusterBrickServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterBrickReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterBrickWriter;
import org.ovirt.engine.sdk4.services.GlusterBrickService;
import org.ovirt.engine.sdk4.services.GlusterBricksService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.GlusterBrick;

public class GlusterBricksServiceImpl
extends ServiceImpl
implements GlusterBricksService {
    public GlusterBricksServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public GlusterBricksService.ActivateRequest activate() {
        return new ActivateRequestImpl();
    }

    @Override
    public GlusterBricksService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public GlusterBricksService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public GlusterBricksService.MigrateRequest migrate() {
        return new MigrateRequestImpl();
    }

    @Override
    public GlusterBricksService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public GlusterBricksService.StopMigrateRequest stopMigrate() {
        return new StopMigrateRequestImpl();
    }

    @Override
    public GlusterBrickService brickService(String id) {
        return new GlusterBrickServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.brickService(path);
        }
        return this.brickService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "GlusterBricksService:" + this.getPath();
    }

    private class StopMigrateResponseImpl
    implements GlusterBricksService.StopMigrateResponse {
        private StopMigrateResponseImpl() {
        }
    }

    private class StopMigrateRequestImpl
    extends BaseRequest<GlusterBricksService.StopMigrateRequest, GlusterBricksService.StopMigrateResponse>
    implements GlusterBricksService.StopMigrateRequest {
        private Boolean async;
        private List<GlusterBrick> bricks;

        private StopMigrateRequestImpl() {
        }

        @Override
        public GlusterBricksService.StopMigrateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public GlusterBricksService.StopMigrateRequest bricks(List<GlusterBrick> bricks) {
            this.bricks = bricks;
            return this;
        }

        @Override
        public GlusterBricksService.StopMigrateRequest bricks(GlusterBrick ... bricks) {
            this.bricks = Arrays.asList(bricks);
            return this;
        }

        @Override
        public GlusterBricksService.StopMigrateRequest bricks(GlusterBrickBuilder ... bricks) {
            this.bricks = new ArrayList<GlusterBrick>(bricks.length);
            for (GlusterBrickBuilder element : bricks) {
                this.bricks.add(element.build());
            }
            return this;
        }

        @Override
        public GlusterBricksService.StopMigrateResponse send() {
            HttpPost request = new HttpPost(GlusterBricksServiceImpl.this.getConnection().getUrl() + GlusterBricksServiceImpl.this.getPath() + "/stopmigrate");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.bricks(this.bricks);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = GlusterBricksServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = GlusterBricksServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new StopMigrateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements GlusterBricksService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<GlusterBricksService.RemoveRequest, GlusterBricksService.RemoveResponse>
    implements GlusterBricksService.RemoveRequest {
        private Boolean async;
        private List<GlusterBrick> bricks;
        private BigInteger replicaCount;

        private RemoveRequestImpl() {
        }

        @Override
        public GlusterBricksService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public GlusterBricksService.RemoveRequest bricks(List<GlusterBrick> bricks) {
            this.bricks = bricks;
            return this;
        }

        @Override
        public GlusterBricksService.RemoveRequest bricks(GlusterBrick ... bricks) {
            this.bricks = Arrays.asList(bricks);
            return this;
        }

        @Override
        public GlusterBricksService.RemoveRequest bricks(GlusterBrickBuilder ... bricks) {
            this.bricks = new ArrayList<GlusterBrick>(bricks.length);
            for (GlusterBrickBuilder element : bricks) {
                this.bricks.add(element.build());
            }
            return this;
        }

        @Override
        public GlusterBricksService.RemoveRequest replicaCount(BigInteger replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        @Override
        public GlusterBricksService.RemoveRequest replicaCount(Integer replicaCount) {
            this.replicaCount = BigInteger.valueOf(replicaCount.intValue());
            return this;
        }

        @Override
        public GlusterBricksService.RemoveRequest replicaCount(Long replicaCount) {
            this.replicaCount = BigInteger.valueOf(replicaCount);
            return this;
        }

        @Override
        public GlusterBricksService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(GlusterBricksServiceImpl.this.getConnection().getUrl() + GlusterBricksServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.replicaCount != null) {
                    uriBuilder.addParameter("replica_count", XmlWriter.renderInteger(this.replicaCount));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = GlusterBricksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            GlusterBricksServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class MigrateResponseImpl
    implements GlusterBricksService.MigrateResponse {
        private MigrateResponseImpl() {
        }
    }

    private class MigrateRequestImpl
    extends BaseRequest<GlusterBricksService.MigrateRequest, GlusterBricksService.MigrateResponse>
    implements GlusterBricksService.MigrateRequest {
        private Boolean async;
        private List<GlusterBrick> bricks;

        private MigrateRequestImpl() {
        }

        @Override
        public GlusterBricksService.MigrateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public GlusterBricksService.MigrateRequest bricks(List<GlusterBrick> bricks) {
            this.bricks = bricks;
            return this;
        }

        @Override
        public GlusterBricksService.MigrateRequest bricks(GlusterBrick ... bricks) {
            this.bricks = Arrays.asList(bricks);
            return this;
        }

        @Override
        public GlusterBricksService.MigrateRequest bricks(GlusterBrickBuilder ... bricks) {
            this.bricks = new ArrayList<GlusterBrick>(bricks.length);
            for (GlusterBrickBuilder element : bricks) {
                this.bricks.add(element.build());
            }
            return this;
        }

        @Override
        public GlusterBricksService.MigrateResponse send() {
            HttpPost request = new HttpPost(GlusterBricksServiceImpl.this.getConnection().getUrl() + GlusterBricksServiceImpl.this.getPath() + "/migrate");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.bricks(this.bricks);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = GlusterBricksServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = GlusterBricksServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new MigrateResponseImpl();
        }
    }

    private class ListResponseImpl
    implements GlusterBricksService.ListResponse {
        private List<GlusterBrick> bricks;

        private ListResponseImpl() {
        }

        public void bricks(List<GlusterBrick> bricks) {
            this.bricks = bricks;
        }

        @Override
        public List<GlusterBrick> bricks() {
            return this.bricks;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<GlusterBricksService.ListRequest, GlusterBricksService.ListResponse>
    implements GlusterBricksService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public GlusterBricksService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public GlusterBricksService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public GlusterBricksService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public GlusterBricksService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public GlusterBricksService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(GlusterBricksServiceImpl.this.getConnection().getUrl() + GlusterBricksServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = GlusterBricksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.bricks(XmlGlusterBrickReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            GlusterBricksServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements GlusterBricksService.AddResponse {
        private List<GlusterBrick> bricks;

        private AddResponseImpl() {
        }

        public void bricks(List<GlusterBrick> bricks) {
            this.bricks = bricks;
        }

        @Override
        public List<GlusterBrick> bricks() {
            return this.bricks;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<GlusterBricksService.AddRequest, GlusterBricksService.AddResponse>
    implements GlusterBricksService.AddRequest {
        private List<GlusterBrick> bricks;
        private BigInteger replicaCount;
        private BigInteger stripeCount;

        private AddRequestImpl() {
        }

        @Override
        public GlusterBricksService.AddRequest bricks(List<GlusterBrick> bricks) {
            this.bricks = bricks;
            return this;
        }

        @Override
        public GlusterBricksService.AddRequest bricks(GlusterBrick ... bricks) {
            this.bricks = Arrays.asList(bricks);
            return this;
        }

        @Override
        public GlusterBricksService.AddRequest bricks(GlusterBrickBuilder ... bricks) {
            this.bricks = new ArrayList<GlusterBrick>(bricks.length);
            for (GlusterBrickBuilder element : bricks) {
                this.bricks.add(element.build());
            }
            return this;
        }

        @Override
        public GlusterBricksService.AddRequest replicaCount(BigInteger replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        @Override
        public GlusterBricksService.AddRequest replicaCount(Integer replicaCount) {
            this.replicaCount = BigInteger.valueOf(replicaCount.intValue());
            return this;
        }

        @Override
        public GlusterBricksService.AddRequest replicaCount(Long replicaCount) {
            this.replicaCount = BigInteger.valueOf(replicaCount);
            return this;
        }

        @Override
        public GlusterBricksService.AddRequest stripeCount(BigInteger stripeCount) {
            this.stripeCount = stripeCount;
            return this;
        }

        @Override
        public GlusterBricksService.AddRequest stripeCount(Integer stripeCount) {
            this.stripeCount = BigInteger.valueOf(stripeCount.intValue());
            return this;
        }

        @Override
        public GlusterBricksService.AddRequest stripeCount(Long stripeCount) {
            this.stripeCount = BigInteger.valueOf(stripeCount);
            return this;
        }

        @Override
        public GlusterBricksService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(GlusterBricksServiceImpl.this.getConnection().getUrl() + GlusterBricksServiceImpl.this.getPath());
                if (this.replicaCount != null) {
                    uriBuilder.addParameter("replica_count", XmlWriter.renderInteger(this.replicaCount));
                }
                if (this.stripeCount != null) {
                    uriBuilder.addParameter("stripe_count", XmlWriter.renderInteger(this.stripeCount));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlGlusterBrickWriter.writeMany(this.bricks.iterator(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = GlusterBricksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.bricks(XmlGlusterBrickReader.readMany(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            GlusterBricksServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }

    private class ActivateResponseImpl
    implements GlusterBricksService.ActivateResponse {
        private ActivateResponseImpl() {
        }
    }

    private class ActivateRequestImpl
    extends BaseRequest<GlusterBricksService.ActivateRequest, GlusterBricksService.ActivateResponse>
    implements GlusterBricksService.ActivateRequest {
        private Boolean async;
        private List<GlusterBrick> bricks;

        private ActivateRequestImpl() {
        }

        @Override
        public GlusterBricksService.ActivateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public GlusterBricksService.ActivateRequest bricks(List<GlusterBrick> bricks) {
            this.bricks = bricks;
            return this;
        }

        @Override
        public GlusterBricksService.ActivateRequest bricks(GlusterBrick ... bricks) {
            this.bricks = Arrays.asList(bricks);
            return this;
        }

        @Override
        public GlusterBricksService.ActivateRequest bricks(GlusterBrickBuilder ... bricks) {
            this.bricks = new ArrayList<GlusterBrick>(bricks.length);
            for (GlusterBrickBuilder element : bricks) {
                this.bricks.add(element.build());
            }
            return this;
        }

        @Override
        public GlusterBricksService.ActivateResponse send() {
            HttpPost request = new HttpPost(GlusterBricksServiceImpl.this.getConnection().getUrl() + GlusterBricksServiceImpl.this.getPath() + "/activate");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.bricks(this.bricks);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = GlusterBricksServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = GlusterBricksServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ActivateResponseImpl();
        }
    }
}

