/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.OpenStackNetworkProviderBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ExternalProviderCertificatesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ExternalProviderServiceImpl;
import org.ovirt.engine.sdk4.internal.services.OpenstackNetworksServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackNetworkProviderReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackNetworkProviderWriter;
import org.ovirt.engine.sdk4.services.ExternalProviderCertificatesService;
import org.ovirt.engine.sdk4.services.OpenstackNetworkProviderService;
import org.ovirt.engine.sdk4.services.OpenstackNetworksService;
import org.ovirt.engine.sdk4.types.OpenStackNetworkProvider;

public class OpenstackNetworkProviderServiceImpl
extends ExternalProviderServiceImpl
implements OpenstackNetworkProviderService {
    public OpenstackNetworkProviderServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public OpenstackNetworkProviderService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public OpenstackNetworkProviderService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public OpenstackNetworkProviderService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public ExternalProviderCertificatesService certificatesService() {
        return new ExternalProviderCertificatesServiceImpl(this.getConnection(), this.getPath() + "/certificates");
    }

    @Override
    public OpenstackNetworksService networksService() {
        return new OpenstackNetworksServiceImpl(this.getConnection(), this.getPath() + "/networks");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("certificates")) {
            return this.certificatesService();
        }
        if (path.startsWith("certificates/")) {
            return this.certificatesService().service(path.substring(13));
        }
        if (path.equals("networks")) {
            return this.networksService();
        }
        if (path.startsWith("networks/")) {
            return this.networksService().service(path.substring(9));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    @Override
    public String toString() {
        return "OpenstackNetworkProviderService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements OpenstackNetworkProviderService.UpdateResponse {
        private OpenStackNetworkProvider provider;

        private UpdateResponseImpl() {
        }

        public void provider(OpenStackNetworkProvider provider) {
            this.provider = provider;
        }

        @Override
        public OpenStackNetworkProvider provider() {
            return this.provider;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<OpenstackNetworkProviderService.UpdateRequest, OpenstackNetworkProviderService.UpdateResponse>
    implements OpenstackNetworkProviderService.UpdateRequest {
        private Boolean async;
        private OpenStackNetworkProvider provider;

        private UpdateRequestImpl() {
        }

        @Override
        public OpenstackNetworkProviderService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public OpenstackNetworkProviderService.UpdateRequest provider(OpenStackNetworkProvider provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public OpenstackNetworkProviderService.UpdateRequest provider(OpenStackNetworkProviderBuilder provider) {
            this.provider = provider.build();
            return this;
        }

        @Override
        public OpenstackNetworkProviderService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackNetworkProviderServiceImpl.this.getConnection().getUrl() + OpenstackNetworkProviderServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlOpenStackNetworkProviderWriter.writeOne(this.provider, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackNetworkProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.provider(XmlOpenStackNetworkProviderReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackNetworkProviderServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements OpenstackNetworkProviderService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<OpenstackNetworkProviderService.RemoveRequest, OpenstackNetworkProviderService.RemoveResponse>
    implements OpenstackNetworkProviderService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public OpenstackNetworkProviderService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public OpenstackNetworkProviderService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackNetworkProviderServiceImpl.this.getConnection().getUrl() + OpenstackNetworkProviderServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackNetworkProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            OpenstackNetworkProviderServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements OpenstackNetworkProviderService.GetResponse {
        private OpenStackNetworkProvider provider;

        private GetResponseImpl() {
        }

        public void provider(OpenStackNetworkProvider provider) {
            this.provider = provider;
        }

        @Override
        public OpenStackNetworkProvider provider() {
            return this.provider;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<OpenstackNetworkProviderService.GetRequest, OpenstackNetworkProviderService.GetResponse>
    implements OpenstackNetworkProviderService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public OpenstackNetworkProviderService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public OpenstackNetworkProviderService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackNetworkProviderServiceImpl.this.getConnection().getUrl() + OpenstackNetworkProviderServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackNetworkProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.provider(XmlOpenStackNetworkProviderReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackNetworkProviderServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

