/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NetworkLabelBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.NetworkLabelServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkLabelReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkLabelWriter;
import org.ovirt.engine.sdk4.services.NetworkLabelService;
import org.ovirt.engine.sdk4.services.NetworkLabelsService;
import org.ovirt.engine.sdk4.types.NetworkLabel;

public class NetworkLabelsServiceImpl
extends ServiceImpl
implements NetworkLabelsService {
    public NetworkLabelsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public NetworkLabelsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public NetworkLabelsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public NetworkLabelService labelService(String id) {
        return new NetworkLabelServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.labelService(path);
        }
        return this.labelService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "NetworkLabelsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements NetworkLabelsService.ListResponse {
        private List<NetworkLabel> labels;

        private ListResponseImpl() {
        }

        public void labels(List<NetworkLabel> labels) {
            this.labels = labels;
        }

        @Override
        public List<NetworkLabel> labels() {
            return this.labels;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<NetworkLabelsService.ListRequest, NetworkLabelsService.ListResponse>
    implements NetworkLabelsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public NetworkLabelsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public NetworkLabelsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public NetworkLabelsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public NetworkLabelsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public NetworkLabelsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NetworkLabelsServiceImpl.this.getConnection().getUrl() + NetworkLabelsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NetworkLabelsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.labels(XmlNetworkLabelReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            NetworkLabelsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements NetworkLabelsService.AddResponse {
        private NetworkLabel label;

        private AddResponseImpl() {
        }

        public void label(NetworkLabel label) {
            this.label = label;
        }

        @Override
        public NetworkLabel label() {
            return this.label;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<NetworkLabelsService.AddRequest, NetworkLabelsService.AddResponse>
    implements NetworkLabelsService.AddRequest {
        private NetworkLabel label;

        private AddRequestImpl() {
        }

        @Override
        public NetworkLabelsService.AddRequest label(NetworkLabel label) {
            this.label = label;
            return this;
        }

        @Override
        public NetworkLabelsService.AddRequest label(NetworkLabelBuilder label) {
            this.label = label.build();
            return this;
        }

        @Override
        public NetworkLabelsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NetworkLabelsServiceImpl.this.getConnection().getUrl() + NetworkLabelsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlNetworkLabelWriter.writeOne(this.label, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NetworkLabelsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.label(XmlNetworkLabelReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            NetworkLabelsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

